/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.index.spatial.binary;

import com.mapinfo.mapmarker.cgge.dp.CompressedSegment;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexIOHandler;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SpatialIndexIOHandler1
extends SpatialIndexIOHandler {
    private final long coordFactor;

    SpatialIndexIOHandler1(IDictionaryMetaData metaData) {
        super(metaData);
        this.coordFactor = this.calculateCoordFactor(metaData);
    }

    private long calculateCoordFactor(IDictionaryMetaData metaData) {
        int decimalPrecison = Math.max(5, metaData.getCoordDecimalPrecision());
        return (long)Math.pow(10.0, decimalPrecison);
    }

    @Override
    public void read(SpatialIndexValue spatialIndexValue, DataInput in) throws IOException {
        spatialIndexValue.setSac((int)IOUtil.readVUnsignedNumber(in));
        spatialIndexValue.setStreetStartOffset(IOUtil.readVUnsignedNumber(in));
        spatialIndexValue.setBounds(this.readBounds(in, spatialIndexValue.getSpatialInfo()));
    }

    @Override
    public void write(SpatialIndexValue spatialIndexValue, DataOutput out) throws IOException {
        IOUtil.writeVUnsignedNumber(out, spatialIndexValue.getSac());
        IOUtil.writeVUnsignedNumber(out, spatialIndexValue.getStreetStartOffset());
        this.writeBounds(spatialIndexValue.getBounds(), out);
    }

    private Envelope readBounds(DataInput in, SpatialInfo spatialInfo) throws IOException {
        long LLX = IOUtil.readSignedVLong(in);
        long LLY = IOUtil.readSignedVLong(in);
        long URX = LLX + IOUtil.readSignedVLong(in);
        long URY = LLY + IOUtil.readSignedVLong(in);
        double coordFactorDbl = this.coordFactor;
        return new Envelope((double)LLX / coordFactorDbl, (double)LLY / coordFactorDbl, (double)URX / coordFactorDbl, (double)URY / coordFactorDbl, spatialInfo);
    }

    private void writeBounds(Envelope bounds, DataOutput out) throws IOException {
        long LLX = CompressedSegment.convertDoubleToLongAndRound(bounds.getLLX(), this.coordFactor);
        long LLY = CompressedSegment.convertDoubleToLongAndRound(bounds.getLLY(), this.coordFactor);
        long URX = CompressedSegment.convertDoubleToLongAndRound(bounds.getURX(), this.coordFactor);
        long URY = CompressedSegment.convertDoubleToLongAndRound(bounds.getURY(), this.coordFactor);
        IOUtil.writeSignedVLong(LLX, out);
        IOUtil.writeSignedVLong(LLY, out);
        IOUtil.writeSignedVLong(URX - LLX, out);
        IOUtil.writeSignedVLong(URY - LLY, out);
    }
}

