/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.index.spatial.binary;

import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexIOHandler;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.DataInputStreamIterator;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class SpatialIndexValueIterator
extends DataInputStreamIterator<SpatialIndexValue> {
    private static final SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private final SpatialInfo srcSpatialInfo;
    private final SpatialIndexIOHandler spatialIndexIoHandler;

    public SpatialIndexValueIterator(CoordSys srcCoordSys, SpatialIndexIOHandler ioHandler) {
        this.srcSpatialInfo = new SpatialInfo(srcCoordSys);
        this.spatialIndexIoHandler = ioHandler;
    }

    protected SpatialIndexValue read(DataInputStream stream) throws IOException {
        SpatialIndexValue value = new SpatialIndexValue(this.srcSpatialInfo);
        this.spatialIndexIoHandler.read(value, stream);
        return this.transformCoords(value);
    }

    private SpatialIndexValue transformCoords(SpatialIndexValue value) {
        Envelope bounds = value.getBounds();
        CoordSys srcCoordSys = bounds.getSpatialInfo().getCoordSys();
        if (!srcCoordSys.equals(SPATIAL_INFO.getCoordSys())) {
            DirectPosition lowerLeft = CoordConvertor.transformPointToWGS84((CoordSys)srcCoordSys, (DirectPosition)bounds.getLowerLeft());
            DirectPosition upperRight = CoordConvertor.transformPointToWGS84((CoordSys)srcCoordSys, (DirectPosition)bounds.getUpperRight());
            Envelope transformedBounds = new Envelope(lowerLeft, upperRight, SPATIAL_INFO);
            SpatialIndexValue transformedValue = new SpatialIndexValue(value, transformedBounds);
            return transformedValue;
        }
        return value;
    }
}

