/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.AbstractGeocodingHelper;
import com.mapinfo.mapmarker.cgge.helper.CGGEPOIHelperUtil;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.List;

public class CGGEPOIGeocodingHelper
extends AbstractGeocodingHelper {
    private int m_tryCount;
    private CGGEPOIHelperUtil m_poiHelper;

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.setGeocodeType(4);
        this.m_tryCount = 0;
        this.m_poiHelper = new CGGEPOIHelperUtil(country, language);
        return true;
    }

    private List<DictionaryAreaTermItem> getAreaTerms(AddressWord[] searchWords, IDataManager dataManager, double minQuality, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        List<DictionaryAreaTermItem> dictionaryAreaList = null;
        List<FieldType> sacSearchFileds = this.getSacSearchFields();
        if (sacSearchFileds != null) {
            for (FieldType type : sacSearchFileds) {
                if (dictionaryAreaList == null) {
                    dictionaryAreaList = this.findAreaList(searchWords, type, minQuality, dataManager, options);
                    continue;
                }
                List<DictionaryAreaTermItem> areaList = dataManager.findAreaTerms(4, searchWords, type, minQuality, options);
                if (areaList == null) continue;
                dictionaryAreaList.addAll(areaList);
            }
        }
        return dictionaryAreaList;
    }

    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        switch (this.m_tryCount) {
            case 0: {
                ++this.m_tryCount;
                this.initSacAndStreetSearchFields(dataManager);
                AddressWord[] searchWords = this.getSearchWords(parsedAddr, true, 0xFFFFFFF);
                AddressWord[] areaSearchWords = this.getAreaSearchWords(parsedAddr, FieldType.AREA_NAME_3_FIELD_TYPE, true, 0xFFFFFFF);
                this.setSearchWordList(this.getSearchableWords(searchWords, dataManager, 1.0, options));
                this.setSearchAreaList(this.getAreaTerms(areaSearchWords, dataManager, 1.0, options));
                if (this.isSearchWordAndAreaTermAvailable()) {
                    return true;
                }
            }
            case 1: {
                ++this.m_tryCount;
                AddressWord[] areaSearchWords = this.getAreaSearchWords(parsedAddr, FieldType.AREA_NAME_4_FIELD_TYPE, true, 0xFFFFFFF);
                this.setSearchAreaList(this.getAreaTerms(areaSearchWords, dataManager, 1.0, options));
                if (this.isSearchWordAndAreaTermAvailable()) {
                    return true;
                }
            }
            case 2: {
                ++this.m_tryCount;
                AddressWord[] areaSearchWords = this.getAreaSearchWords(parsedAddr, FieldType.POST_CODE_FIELD_TYPE, true, 0xFFFFFFF);
                this.setSearchAreaList(this.getAreaTerms(areaSearchWords, dataManager, 1.0, options));
                if (this.isSearchWordAndAreaTermAvailable()) {
                    return true;
                }
            }
            case 3: {
                AddressWord[] searchWords;
                ++this.m_tryCount;
                if (this.m_poiHelper.isSearchOnSplitWordAllowed()) {
                    searchWords = this.getSearchWords(parsedAddr, true, 0xFFFFFFF);
                    AddressWord[] splittedSearchWords = this.getSplitWords(searchWords);
                    AddressWord[] areaSearchWords = this.getAreaSearchWords(parsedAddr, FieldType.AREA_NAME_3_FIELD_TYPE, true, 0xFFFFFFF);
                    this.setSearchWordList(this.getSearchableWords(splittedSearchWords, dataManager, 1.0, options));
                    this.setSearchAreaList(this.getAreaTerms(areaSearchWords, dataManager, 0.7, options));
                    if (this.isSearchWordAndAreaTermAvailable()) {
                        return true;
                    }
                }
            }
            case 4: {
                ++this.m_tryCount;
                AddressWord[] searchWords = this.getSearchWords(parsedAddr, false, 0xFFFFFFF);
                AddressWord[] areaSearchWords = this.getAreaSearchWords(parsedAddr, FieldType.AREA_NAME_3_FIELD_TYPE, true, 0xFFFFFFF);
                this.setSearchWordList(this.getSearchableWords(searchWords, dataManager, 0.7, options));
                this.setSearchAreaList(this.getAreaTerms(areaSearchWords, dataManager, 0.7, options));
                if (this.isSearchWordAndAreaTermAvailable()) {
                    return true;
                }
            }
            case 5: {
                ++this.m_tryCount;
                AddressWord[] areaSearchWords = this.getAreaSearchWords(parsedAddr, FieldType.AREA_NAME_4_FIELD_TYPE, true, 0xFFFFFFF);
                this.setSearchAreaList(this.getAreaTerms(areaSearchWords, dataManager, 0.7, options));
                if (this.isSearchWordAndAreaTermAvailable()) {
                    return true;
                }
            }
            case 6: {
                ++this.m_tryCount;
                AddressWord[] searchWords = this.getSearchWords(parsedAddr, false, 3922);
                AddressWord[] areaSearchWords = this.getAreaSearchWords(parsedAddr, FieldType.AREA_NAME_3_FIELD_TYPE, true, 0xFFFFFFF);
                this.setSearchWordList(this.getSearchableWords(searchWords, dataManager, 0.95, options));
                this.setSearchAreaList(this.getAreaTerms(areaSearchWords, dataManager, 0.95, options));
                if (this.isSearchWordAndAreaTermAvailable()) {
                    return true;
                }
            }
            case 7: {
                ++this.m_tryCount;
                AddressWord[] inputWords = this.getSearchWords(parsedAddr, false, 3666);
                if (inputWords == null) break;
                AddressWord[] searchWords = null;
                int commonWordCount = 0;
                for (int i = 0; i < inputWords.length; ++i) {
                    if (!CodedWord.isCommonWord(inputWords[i].getAttributes())) continue;
                    ++commonWordCount;
                }
                if (commonWordCount != inputWords.length) {
                    return false;
                }
                searchWords = inputWords;
                AddressWord[] areaSearchWords = this.getAreaSearchWords(parsedAddr, FieldType.AREA_NAME_3_FIELD_TYPE, true, 0xFFFFFFF);
                this.setSearchWordList(this.getSearchableWords(searchWords, dataManager, 0.85, options));
                this.setSearchAreaList(this.getAreaTerms(areaSearchWords, dataManager, 0.7, options));
                if (!this.isSearchWordAndAreaTermAvailable()) break;
                return true;
            }
        }
        return false;
    }

    private boolean isSearchWordAndAreaTermAvailable() {
        return !ListUtils.isEmpty(this.getSearchWordList()) && !ListUtils.isEmpty(this.getSearchAreaList());
    }

    private AddressWord[] getAreaSearchWords(ParsedAddress address, FieldType type, boolean weightedWords, int includeMask) {
        AddressWord[] searchWords = null;
        searchWords = address.isSeparateAreaFields() ? (AddressWord[])address.getField(type) : (AddressWord[])address.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        if (searchWords != null) {
            searchWords = this.filterSearchWords(searchWords, weightedWords, false, includeMask);
        }
        return searchWords;
    }

    protected AddressWord[] getSearchWords(ParsedAddress parsedAddr, boolean weightedWords, int includeMask) {
        AddressWord[] inputWords = (AddressWord[])parsedAddr.getField(FieldType.PLACE_NAME_FIELD_TYPE);
        if (inputWords == null) {
            inputWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        }
        AddressWord[] searchWords = null;
        if (inputWords != null) {
            searchWords = this.filterSearchWords(inputWords, weightedWords, false, includeMask);
        }
        return searchWords;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (this.generateCases(dataManager, parsedAddress, options, curCandList)) {
            return super.retrieveCandidates(dataManager, parsedAddress, options);
        }
        this.finishRetries();
        return null;
    }

    @Override
    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList candList = super.retrieveCandidates(dataManager, parsedAddress, options);
        return candList;
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, int includeMask) {
        int wordsLen;
        AddressWord[] retAddressWords = null;
        int n = wordsLen = words == null ? 0 : words.length;
        if (wordsLen > 0) {
            if (wordsLen == 1) {
                retAddressWords = AddressWordArray.clone(words);
            } else {
                ICGGEParser parser = this.getHelperParser();
                ICGGESoundex soundex = this.getHelperSoundex();
                boolean containsTypeSeparator = false;
                ArrayList<AddressWord> filteredWordList = new ArrayList<AddressWord>(wordsLen);
                int typeCount = 0;
                for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
                    AddressWord addrWord = words[wordNdx];
                    if (!CodedWord.isThoroughfareTypeWord(addrWord.getAttributes())) continue;
                    ++typeCount;
                }
                boolean filterTypes = typeCount < 2 && (includeMask & 0x200) == 512;
                boolean filterCommonWord = (includeMask & 0x100) == 256;
                boolean filterArticles = (includeMask & 0x400) == 1024;
                boolean filterNumbers = (includeMask & 4) == 4;
                boolean filterNumerics = (includeMask & 8) == 8;
                for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
                    boolean isNormalWord;
                    AddressWord addrWord = words[wordNdx];
                    short wordAttribs = addrWord.getAttributes();
                    boolean filter = true;
                    if (CodedWord.isDelimiter(wordAttribs)) {
                        if (!"%".equals(addrWord.getWord())) continue;
                        containsTypeSeparator = true;
                        continue;
                    }
                    boolean bl = isNormalWord = !CodedWord.isNumber(wordAttribs) && !CodedWord.isNumeric(wordAttribs) && !CodedWord.isProbableRomanNumeral(wordAttribs) && !CodedWord.isThoroughfareTypeWord(wordAttribs) && !CodedWord.isArticleWord(wordAttribs) && !CodedWord.isCommonWord(wordAttribs) && !MMUtils.containsDigits(addrWord.getWordChars());
                    if (isNormalWord) {
                        if (includeNormalWords) {
                            filter = false;
                        }
                    } else {
                        if (!filterNumbers && CodedWord.isNumber(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterNumerics && (CodedWord.isNumeric(wordAttribs) || CodedWord.isProbableRomanNumeral(wordAttribs) || MMUtils.containsDigits(addrWord.getWordChars()))) {
                            filter = false;
                        }
                        if (!filterTypes && CodedWord.isThoroughfareTypeWord(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterArticles && CodedWord.isArticleWord(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterCommonWord && CodedWord.isCommonWord(wordAttribs)) {
                            filter = false;
                        }
                    }
                    if (filter) continue;
                    filteredWordList.add(addrWord);
                }
                if (containsTypeSeparator) {
                    StringBuilder builder = new StringBuilder();
                    for (int searchWordNdx = 1; searchWordNdx < wordsLen - 1; ++searchWordNdx) {
                        AddressWord searchWord = words[searchWordNdx];
                        if (!CodedWord.isDelimiter(searchWord.getAttributes()) || !"%".equals(searchWord.getWord())) continue;
                        builder.append(words[searchWordNdx - 1].getWord());
                        builder.append(words[searchWordNdx + 1].getWord());
                        filteredWordList.add(parser.convertToAddressWord(builder.toString(), soundex));
                        builder.delete(0, builder.length());
                    }
                }
                if (combineAlphaNumeric) {
                    StringBuilder builder = new StringBuilder();
                    for (int wordNdx = 1; wordNdx < wordsLen; ++wordNdx) {
                        AddressWord preWord;
                        AddressWord word = words[wordNdx];
                        if (!CodedWord.isNumber(word.getAttributes()) || CodedWord.isNumber((preWord = words[wordNdx - 1]).getAttributes()) || CodedWord.isDelimiter(preWord.getAttributes())) continue;
                        builder.append(preWord.getWordChars());
                        builder.append(word.getWordChars());
                        filteredWordList.add(parser.convertToAddressWord(builder.toString(), soundex));
                        builder.delete(0, builder.length());
                        ++wordNdx;
                    }
                }
                if (filteredWordList.size() > 0) {
                    retAddressWords = filteredWordList.toArray(new AddressWord[filteredWordList.size()]);
                }
            }
        }
        return retAddressWords;
    }

    private List<DictionaryAddressWord> getSearchableWords(AddressWord[] searchWords, IDataManager dataManager, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        ArrayList<DictionaryAddressWord> searchableWordList = new ArrayList<DictionaryAddressWord>(10);
        int searchWordLen = searchWords == null ? 0 : searchWords.length;
        List<FieldType> addressSearchFileds = this.getAddressSearchFields();
        if (searchWordLen > 0 && addressSearchFileds != null) {
            for (FieldType type : addressSearchFileds) {
                for (int searchWordNdx = 0; searchWordNdx < searchWordLen; ++searchWordNdx) {
                    AddressWord searchWord = searchWords[searchWordNdx];
                    List<DictionaryAddressWord> streetCodedWordList = dataManager.findMatchingWords(4, searchWord, FieldType.PLACE_NAME_FIELD_TYPE, minQuality, options);
                    if (streetCodedWordList == null) continue;
                    for (DictionaryAddressWord aw : streetCodedWordList) {
                        aw.getAddressWord().m_wordType = type;
                        searchableWordList.add(aw);
                    }
                }
            }
        }
        return searchableWordList;
    }

    protected CGGEPOIHelperUtil getPOIHelperUtil() {
        return this.m_poiHelper;
    }
}

