/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CGGEPOIHelperUtil {
    private static final String RESOURCE_PATH_INITIALS = "/com/mapinfo/mapmarker/";
    private static final String RESOURCE_PATH_CONFIG = "/config/";
    private static final String RESOURCE_HELPER_INITIALS = "_POIGeocodingHelper";
    private static String KEY_ALLOW_SEARCH_ON_SPLIT_AREA_WORDS = "allow_search_on_split_words";
    private Properties m_HelperProperties;

    public CGGEPOIHelperUtil(String country, String language) {
        this.m_HelperProperties = POIHelperPropertyContainer.getHelperProperties(country, language);
    }

    public boolean isSearchOnSplitWordAllowed() {
        return PropertiesUtil.getBooleanPropertyValue(this.m_HelperProperties, KEY_ALLOW_SEARCH_ON_SPLIT_AREA_WORDS, false);
    }

    private void addUniqueFieldTypestoList(List<FieldType> source, List<FieldType> sink) {
        if (source != null) {
            for (FieldType fieldType : source) {
                if (sink.contains(fieldType)) continue;
                sink.add(fieldType);
            }
        }
    }

    private static class POIHelperPropertyContainer {
        private static Map<String, Properties> m_POIHelperPropertyContainer = new HashMap<String, Properties>();

        private POIHelperPropertyContainer() {
        }

        private static Properties getCountryConfig(String country, String language) {
            Properties prop = null;
            try {
                prop = CGGEResourceBundle.getBundle(CGGEPOIHelperUtil.RESOURCE_PATH_INITIALS + country + CGGEPOIHelperUtil.RESOURCE_PATH_CONFIG + country + CGGEPOIHelperUtil.RESOURCE_HELPER_INITIALS, language);
            }
            catch (CGGEInternalException e) {
                prop = new Properties();
            }
            return prop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Properties getHelperProperties(String country, String language) {
            String key = POIHelperPropertyContainer.buildPropertyHolderKey(country, language);
            Properties props = null;
            Map<String, Properties> map = m_POIHelperPropertyContainer;
            synchronized (map) {
                props = m_POIHelperPropertyContainer.get(key);
                if (props == null) {
                    props = POIHelperPropertyContainer.getCountryConfig(country, language);
                    m_POIHelperPropertyContainer.put(key, props);
                }
            }
            return props;
        }

        private static String buildPropertyHolderKey(String country, String language) {
            StringBuilder builder = new StringBuilder(country);
            builder.append("_");
            builder.append(language);
            return builder.toString().toUpperCase();
        }
    }
}

