/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.AbstractGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CGGEPostalGeocodingHelper
extends AbstractGeocodingHelper {
    private int m_tryCount;
    public boolean m_pcAreaIntersectionSacsOnly;

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.setGeocodeType(2);
        this.m_tryCount = 0;
        this.m_pcAreaIntersectionSacsOnly = false;
        return true;
    }

    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        switch (this.m_tryCount) {
            case 0: {
                if (this.getSacSearchFields() == null || this.getAddressSearchFields() == null) {
                    this.initSacAndStreetSearchFields(dataManager);
                }
                ++this.m_tryCount;
                AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
                List<DictionaryAreaTermItem> areaList = null;
                List<DictionaryAddressWord> searchWordList = null;
                if (pcWords != null) {
                    areaList = this.findAreaList(pcWords, 1.0, dataManager, options);
                    if (areaList != null) {
                        searchWordList = this.getSearchableWords(pcWords, dataManager, 1.0, options);
                    }
                } else {
                    List<PostCode> probablePcs = parsedAddr.getProbablePostcodes();
                    if (probablePcs != null) {
                        for (PostCode pc : probablePcs) {
                            pcWords = pc.getWords();
                            areaList = ListUtils.addToList(areaList, this.findAreaList(pcWords, 1.0, dataManager, options));
                            searchWordList = ListUtils.addToList(searchWordList, this.getSearchableWords(pcWords, dataManager, 1.0, options));
                        }
                    }
                }
                if (areaList == null || searchWordList == null) break;
                this.setSearchAreaList(areaList);
                this.setSearchWordList(searchWordList);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void initSacAndStreetSearchFields(IDataManager dataManager) throws CGGEInternalException {
        super.initSacAndStreetSearchFields(dataManager);
        if (ListUtils.isEmpty(this.getSacSearchFields())) {
            this.setSacSearchFields(Collections.singletonList(FieldType.POST_CODE_FIELD_TYPE));
        }
        if (ListUtils.isEmpty(this.getAddressSearchFields())) {
            this.setAddressSearchFields(Collections.singletonList(FieldType.POST_CODE_FIELD_TYPE));
        }
    }

    protected List<DictionaryAreaTermItem> findAreaList(AddressWord[] words, double minQuality, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        ArrayList<DictionaryAreaTermItem> areaList = new ArrayList<DictionaryAreaTermItem>();
        for (FieldType searchType : this.getSacSearchFields()) {
            List<DictionaryAreaTermItem> dictionaryAreas = this.findAreaList(words, searchType, minQuality, dataManager, options);
            if (dictionaryAreas == null) continue;
            areaList.addAll(dictionaryAreas);
        }
        return areaList.isEmpty() ? null : areaList;
    }

    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] pcWords, IDataManager dataManager, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        ArrayList<DictionaryAddressWord> dictionaryWordList = new ArrayList<DictionaryAddressWord>();
        for (FieldType searchType : this.getAddressSearchFields()) {
            List<DictionaryAddressWord> dictionaryWords = this.getSearchableWords(pcWords, searchType, dataManager, minQuality, options);
            if (dictionaryWords == null) continue;
            dictionaryWordList.addAll(dictionaryWords);
        }
        return dictionaryWordList.isEmpty() ? null : dictionaryWordList;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (this.generateCases(dataManager, parsedAddress, options, curCandList)) {
            return this.retrieveCandidates(dataManager, parsedAddress, options);
        }
        this.finishRetries();
        return null;
    }
}

