/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.matcher;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.InternalScoringUnit;
import java.util.Comparator;

public class CGGEInternalScoringRangeComparator
implements Comparator<InternalScoringRange> {
    protected int comparePlaceNameScores(InternalScoringRange r1, InternalScoringRange r2) {
        FieldScore place1Score = r1.getFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        FieldScore place2Score = r2.getFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        if (place1Score != null && place2Score != null) {
            return place1Score.compare(place1Score, place2Score);
        }
        if (place1Score != null) {
            return 1;
        }
        if (place2Score != null) {
            return -1;
        }
        return 0;
    }

    protected int compareAddressNumberScores(InternalScoringRange r1, InternalScoringRange r2) {
        AddressNumberScore n1Score = (AddressNumberScore)r1.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        AddressNumberScore n2Score = (AddressNumberScore)r2.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        if (n1Score != null && n2Score != null) {
            return n1Score.compare(n1Score, n2Score);
        }
        if (n1Score != null) {
            return 1;
        }
        if (n2Score != null) {
            return -1;
        }
        return 0;
    }

    protected int compareUnitScore(InternalScoringRange r1, InternalScoringRange r2) {
        int u1Count = r1.getUnitCount();
        int u2Count = r2.getUnitCount();
        if (u1Count > 0 && u2Count > 0) {
            InternalScoringUnit unit1 = r1.getUnitAt(0);
            return unit1.compare(unit1, r2.getUnitAt(0));
        }
        if (u1Count > 0 && r1.getUnitAt(0).getCombinedScore() > 0.0) {
            return 1;
        }
        if (u2Count > 0 && r2.getUnitAt(0).getCombinedScore() > 0.0) {
            return -1;
        }
        return 0;
    }

    protected int compareAddressNumbers(InternalScoringRange r1, InternalScoringRange r2) {
        AddressNumber from1 = r1.getFrom();
        AddressNumber from2 = r2.getFrom();
        if (from1 != null && from2 != null) {
            int comp = from1.compare(from1, from2);
            if (comp != 0) {
                return -comp;
            }
        } else {
            if (from1 != null) {
                return -1;
            }
            if (from2 != null) {
                return 1;
            }
        }
        AddressNumber to1 = r1.getTo();
        AddressNumber to2 = r2.getTo();
        if (to1 != null && to2 != null) {
            int comp = to1.compare(to1, to2);
            if (comp != 0) {
                return -comp;
            }
        } else {
            if (to1 != null) {
                return -1;
            }
            if (to2 != null) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int compare(InternalScoringRange r1, InternalScoringRange r2) {
        if (r1.isCloseMatch() == r2.isCloseMatch()) {
            double comp = r1.getCombinedScore() - r2.getCombinedScore();
            if (comp == 0.0) {
                int comp1 = 0;
                if (r1.getCombinedScore() > 0.001) {
                    comp1 = this.comparePlaceNameScores(r1, r2);
                    if (comp1 == 0 && (comp1 = this.compareAddressNumberScores(r1, r2)) == 0 && (comp1 = this.compareUnitScore(r1, r2)) == 0) {
                        comp1 = this.compareAddressNumbers(r1, r2);
                    }
                } else {
                    comp1 = this.compareAddressNumberScores(r1, r2);
                    if (comp1 == 0 && (comp1 = this.compareUnitScore(r1, r2)) == 0) {
                        comp1 = this.compareAddressNumbers(r1, r2);
                    }
                }
                return comp1;
            }
            if (comp > 0.0) {
                return 1;
            }
            return -1;
        }
        if (r1.isCloseMatch()) {
            return 1;
        }
        return -1;
    }
}

