/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.matcher;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MatchedWordStats {
    private int wordCount;
    private int matchedWordCount;
    private int matchedSignificantWordCount;
    private int unMatchedNormalWordCount;
    private int unmatchedArticleAndNumericWordCount;
    private int partialNonArtcileOrNumericWordCount;
    private int partialMatchedNormalWordCount;
    private int unmatchedSignificantWordCount;
    private int weightedCandWords;
    private int partialMatchedCandWords;

    int getTotalWords() {
        return this.wordCount;
    }

    int getMatchedWordCount() {
        return this.matchedWordCount;
    }

    int getMatchedSignificantWordCount() {
        return this.matchedSignificantWordCount;
    }

    int getUnMatchedNormalWordCount() {
        return this.unMatchedNormalWordCount;
    }

    int getUnMatchedArticleOrNumericWordCount() {
        return this.unmatchedArticleAndNumericWordCount;
    }

    int getPartialMatchNonArticleOrNumericWordCount() {
        return this.partialNonArtcileOrNumericWordCount;
    }

    int getPartialMatchNormalWordCount() {
        return this.partialMatchedNormalWordCount;
    }

    int getUnmatchedSignificantWordCount() {
        return this.unmatchedSignificantWordCount;
    }

    int getWeightedCandidateWordCount() {
        return this.weightedCandWords;
    }

    int getPartialMatchCandidateWordCount() {
        return this.partialMatchedCandWords;
    }

    void process(List<AddressWord[]> inputList, InternalScoringAddress addr) {
        int inputListCount = inputList == null ? 0 : inputList.size();
        Collection<FieldScore> fieldScores = addr.getFieldScoreList();
        ArrayList<Object> fieldScoreList = null;
        fieldScoreList = fieldScores != null ? new ArrayList<FieldScore>(addr.getFieldScoreList()) : new ArrayList(3);
        if (addr.getRangeCount() > 0) {
            Collection<FieldScore> unitFieldScores;
            InternalScoringRange range = addr.getRangeAt(0);
            Collection<FieldScore> rangeFieldScores = range.getFieldScoreList();
            if (rangeFieldScores != null) {
                fieldScoreList.addAll(rangeFieldScores);
            }
            if (range.getUnitCount() > 0 && (unitFieldScores = range.getUnitAt(0).getFieldScoreList()) != null) {
                fieldScoreList.addAll(unitFieldScores);
            }
        }
        int scoreCount = fieldScoreList == null ? 0 : fieldScoreList.size();
        IntArray perfectWords = new IntArray();
        IntArray matchedWords = new IntArray();
        for (int inputNdx = 0; inputNdx < inputListCount; ++inputNdx) {
            int inputWordsLen;
            AddressWord[] inputWords = inputList.get(inputNdx);
            int n = inputWordsLen = inputWords == null ? 0 : inputWords.length;
            if (inputWordsLen <= 0) continue;
            perfectWords.removeAll();
            matchedWords.removeAll();
            for (int scoreNdx = 0; scoreNdx < scoreCount; ++scoreNdx) {
                AddressWord matchedInputWord;
                int matchedNdx;
                int matchedWordCount;
                FieldScore score = (FieldScore)fieldScoreList.get(scoreNdx);
                if (score == null || score.m_inputWords != inputWords) continue;
                if (score.m_perfectInputWords != null) {
                    perfectWords.add(score.m_perfectInputWords);
                    matchedWordCount = score.m_perfectInputWords.size();
                    for (matchedNdx = 0; matchedNdx < matchedWordCount; ++matchedNdx) {
                        int index = score.m_perfectInputWords.get(matchedNdx);
                        if (index >= score.m_inputWords.length || !AddressWord.isSignificantWord(matchedInputWord = score.m_inputWords[index])) continue;
                        ++this.matchedSignificantWordCount;
                    }
                }
                if (score.m_matchedInputWords != null) {
                    matchedWords.add(score.m_matchedInputWords);
                    matchedWordCount = score.m_matchedInputWords.size();
                    for (matchedNdx = 0; matchedNdx < matchedWordCount; ++matchedNdx) {
                        int ndx = score.m_matchedInputWords.get(matchedNdx);
                        if (ndx >= inputWordsLen || !AddressWord.isSignificantWord(matchedInputWord = score.m_inputWords[score.m_matchedInputWords.get(matchedNdx)])) continue;
                        ++this.partialMatchedNormalWordCount;
                    }
                }
                if (score.m_matchedCandWords == null) continue;
                int candWordCount = score.m_candWords.length;
                for (int candWordNdx = 0; candWordNdx < candWordCount; ++candWordNdx) {
                    if (score.m_candWords[candWordNdx].m_weight > 0) {
                        ++this.weightedCandWords;
                    }
                    if (!score.m_matchedCandWords.contains(candWordNdx)) continue;
                    ++this.partialMatchedCandWords;
                }
            }
            this.wordCount += inputWordsLen;
            perfectWords.sort();
            perfectWords.removeDuplicates();
            this.matchedWordCount += perfectWords.size();
            for (int wordNdx = 0; wordNdx < inputWordsLen; ++wordNdx) {
                if (perfectWords.contains(wordNdx)) continue;
                AddressWord inputWord = inputWords[wordNdx];
                short wordAttribs = inputWord.getAttributes();
                if (!CodedWord.isDelimiter(wordAttribs)) {
                    if (CodedWord.isNumber(wordAttribs) || CodedWord.isArticleWord(wordAttribs)) {
                        ++this.unmatchedArticleAndNumericWordCount;
                    } else {
                        ++this.unMatchedNormalWordCount;
                        if (matchedWords.contains(wordNdx)) {
                            ++this.partialNonArtcileOrNumericWordCount;
                        }
                    }
                    if (!AddressWord.isSignificantWord(inputWord)) continue;
                    ++this.unmatchedSignificantWordCount;
                    continue;
                }
                --this.wordCount;
            }
        }
    }
}

