/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.matcher;

import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;

class TransientScoreObject {
    private final InternalScoringAddress addr;
    private final MatchingOptions matchOptions;
    private double scorePossible = 0.0;
    private double score = 0.0;
    private int fieldsAvailable = 0;
    private int fieldsMatched = 0;

    TransientScoreObject(InternalScoringAddress addr, MatchingOptions matchOptions) {
        this.addr = addr;
        this.matchOptions = matchOptions;
    }

    void incScorePossible(double d) {
        this.scorePossible += d;
    }

    void setScorePossible(double d) {
        this.scorePossible = d;
    }

    void incScore(double d) {
        this.score += d;
    }

    void incFieldsAvailable() {
        ++this.fieldsAvailable;
    }

    void incFieldsMatched() {
        ++this.fieldsMatched;
    }

    int getFieldsAvailable() {
        return this.fieldsAvailable;
    }

    int getFieldsMatched() {
        return this.fieldsMatched;
    }

    double getWeightedScore() {
        if (this.scorePossible > 0.0) {
            return this.score / this.scorePossible;
        }
        return 0.0;
    }

    double getScore() {
        return this.score;
    }

    double getScorePossible() {
        return this.scorePossible;
    }

    InternalScoringAddress getScoringAddress() {
        return this.addr;
    }

    MatchingOptions getMatchOptions() {
        return this.matchOptions;
    }

    public void setFieldsAvailable(int fieldsAvailable) {
        this.fieldsAvailable = fieldsAvailable;
    }
}

