/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.parser;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CGGEThoroughfareTypeHandler
extends DatasetInfoComponent
implements ICGGEThoroughfareTypeHandler {
    private Properties m_properties;
    private boolean m_initialised;
    private Pattern m_startPattern;
    private Pattern m_endPattern;
    private boolean m_supportPartial;
    private boolean m_preferStart;
    private String m_country;
    public static final String KEY_CONCATENATOR = "+";
    private List<String> m_startTypeList = new ArrayList<String>();
    private List<String> m_endTypeList = new ArrayList<String>();
    private Map<String, String> m_tftMap = new HashMap<String, String>();
    private static final String PRE_TYPE_PREFIX = "pre_";
    private static final String POST_TYPE_PREFIX = "post_";

    public CGGEThoroughfareTypeHandler() {
    }

    public CGGEThoroughfareTypeHandler(String country, String language) throws IOException, CGGEInternalException {
        this();
        this.init(country, language);
    }

    public CGGEThoroughfareTypeHandler(String country, String language, boolean supportPartial, boolean preferStart) throws CGGEInternalException {
        this();
        this.m_supportPartial = supportPartial;
        this.m_preferStart = preferStart;
    }

    @Override
    public int[] findThoroughfareType(String str) {
        int[] startEnd = null;
        if (this.m_initialised && str != null && str.length() > 0) {
            String type;
            int len;
            Matcher matcher = null;
            if (this.m_preferStart && this.m_startPattern != null && (matcher = this.m_startPattern.matcher(str)) != null && matcher.find() && matcher != null && matcher.find()) {
                startEnd = new int[]{matcher.start(), matcher.end()};
            }
            if (startEnd == null && this.m_endPattern != null) {
                matcher = this.m_endPattern.matcher(str);
                while (matcher != null && matcher.find()) {
                    startEnd = new int[]{matcher.start(), matcher.end()};
                }
            }
            if (startEnd != null && (len = (type = str.substring((int)startEnd[0], (int)startEnd[1])).trim().length()) < startEnd[1] - startEnd[0]) {
                startEnd[1] = startEnd[0] + len;
            }
        }
        return startEnd;
    }

    @Override
    public int[] findThoroughfareTypeHandlesAttachedPreTypes(String str) {
        int[] startEnd = null;
        if (this.m_initialised && str != null && str.length() > 0) {
            String type;
            int len;
            Matcher matcher = null;
            if (this.m_preferStart && this.m_startPattern != null) {
                matcher = this.m_startPattern.matcher(str);
                while (matcher != null && matcher.find()) {
                    startEnd = new int[]{matcher.start(), matcher.end()};
                }
            }
            if (startEnd == null && this.m_endPattern != null) {
                matcher = this.m_endPattern.matcher(str);
                while (matcher != null && matcher.find()) {
                    startEnd = new int[]{matcher.start(), matcher.end()};
                }
            }
            if (startEnd != null && (len = (type = str.substring((int)startEnd[0], (int)startEnd[1])).trim().length()) < startEnd[1] - startEnd[0]) {
                startEnd[1] = startEnd[0] + len;
            }
        }
        return startEnd;
    }

    @Override
    public boolean isThoroughfareType(String str) {
        boolean retFlag = false;
        if (str != null && str.trim().length() > 0 && !(retFlag = this.m_endTypeList.contains(str.trim().toUpperCase()))) {
            retFlag = this.m_startTypeList.contains(str.trim().toUpperCase());
        }
        return retFlag;
    }

    @Override
    public boolean isThoroughfareTypeAtStart(String str) {
        return str == null ? false : this.m_startTypeList.contains(str.toUpperCase());
    }

    @Override
    public boolean isThoroughfareTypeAtEnd(String str) {
        return str == null ? false : this.m_endTypeList.contains(str.toUpperCase());
    }

    @Override
    public String getPreferedTypeName(String str) {
        return this.getProperTypeName(str);
    }

    @Override
    public String getProperTypeName(String str) {
        return str == null ? null : this.m_tftMap.get(str.toUpperCase());
    }

    public boolean doesSupportPartial() {
        return this.m_supportPartial;
    }

    public boolean doesPreferStart() {
        return this.m_preferStart;
    }

    @Override
    public List<String> getAllThoroughfareTypes() {
        ArrayList<String> combinedList = new ArrayList<String>();
        combinedList.addAll(this.m_endTypeList);
        combinedList.addAll(this.m_startTypeList);
        return combinedList;
    }

    private String removeConcatenator(String input) {
        StringBuilder builder = null;
        if (input != null) {
            builder = new StringBuilder(input);
            int idx = -1;
            while ((idx = builder.indexOf(KEY_CONCATENATOR)) >= 0) {
                builder.replace(idx, idx + 1, " ");
            }
        }
        return builder != null ? builder.toString() : null;
    }

    @Override
    public String getCountry() {
        return null;
    }

    @Override
    public String getLanguage() {
        return null;
    }

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_properties = this.getConfiguration(country, language, "_ThoroughfareTypes");
        Set<Map.Entry<Object, Object>> entries = this.m_properties.entrySet();
        if (entries != null) {
            for (Map.Entry<Object, Object> entry : entries) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ((key = this.removeConcatenator(key)).startsWith(PRE_TYPE_PREFIX)) {
                    key = key.replace(PRE_TYPE_PREFIX, "");
                    this.addToList(this.m_startTypeList, key, value);
                    continue;
                }
                if (!key.startsWith(POST_TYPE_PREFIX)) continue;
                key = key.replace(POST_TYPE_PREFIX, "");
                this.addToList(this.m_endTypeList, key, value);
            }
        }
        this.removeDuplicate();
        Collections.sort(this.m_startTypeList, new StringLenghtComparator());
        Collections.reverse(this.m_startTypeList);
        Collections.sort(this.m_endTypeList, new StringLenghtComparator());
        Collections.reverse(this.m_endTypeList);
        StringBuilder buf = new StringBuilder();
        Iterator<String> it = this.m_startTypeList.iterator();
        while (it.hasNext()) {
            buf.append("\\b");
            buf.append(this.fixPeriodForPattern(it.next()));
            if (!it.hasNext()) continue;
            buf.append("|");
        }
        if (buf.length() > 0) {
            this.m_startPattern = Pattern.compile(buf.toString(), 2);
            buf.delete(0, buf.length());
        }
        it = this.m_endTypeList.iterator();
        while (it.hasNext()) {
            if (!this.m_supportPartial) {
                buf.append("\\b");
            }
            String s = it.next();
            s = this.fixPeriodForPattern(s);
            buf.append(s);
            if (s.charAt(s.length() - 1) != '.') {
                buf.append("\\b");
            }
            if (!it.hasNext()) continue;
            buf.append("|");
        }
        if (buf.length() > 0) {
            this.m_endPattern = Pattern.compile(buf.toString(), 2);
        }
        ((ArrayList)this.m_startTypeList).trimToSize();
        ((ArrayList)this.m_endTypeList).trimToSize();
        this.m_initialised = true;
        return this.m_initialised;
    }

    private String fixPeriodForPattern(String s) {
        char[] contents;
        StringBuilder b = new StringBuilder();
        for (char c : contents = s.toCharArray()) {
            if ('.' == c) {
                b.append('\\');
            }
            b.append(c);
        }
        return b.toString();
    }

    private void removeDuplicate() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.m_endTypeList);
        this.m_endTypeList = new ArrayList<String>(set);
        set.clear();
        set.addAll(this.m_startTypeList);
        this.m_startTypeList = new ArrayList<String>(set);
    }

    private List<String> getValuesAsList(String key, String values) {
        ArrayList<String> lst = new ArrayList<String>();
        if (values != null && values.length() > 0) {
            StringTokenizer st = new StringTokenizer(values.trim(), ",");
            while (st.hasMoreTokens()) {
                lst.add(st.nextToken().trim().toUpperCase());
            }
        }
        lst.add(key.toUpperCase());
        return lst;
    }

    private void addToList(List<String> thoroughFares, String key, String value) {
        if (key != null && key.trim().length() > 0) {
            List<String> valueList = this.getValuesAsList(key, value.trim());
            thoroughFares.addAll(valueList);
            this.addtoMap(key, valueList);
        }
    }

    public void addtoMap(String key, List<String> values) {
        for (String val : values) {
            this.m_tftMap.put(val.toUpperCase(), key);
        }
    }

    private static class StringLenghtComparator
    implements Comparator<String> {
        private StringLenghtComparator() {
        }

        @Override
        public int compare(String str1, String str2) {
            return str1.length() - str2.length();
        }
    }
}

