/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.reverseGeocode;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.convertor.CGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.convertor.ICGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.common.IReverseGeocodeCandidate;
import com.mapinfo.mapmarker.core.interpolator.Interpolator;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeUtils;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class CGGEInternalReverseGeocodeCandidate
implements IReverseGeocodeCandidate {
    private InternalStreetAddress m_streetAddress;
    private GeocodeOptions m_options;
    private IDataManager m_dataManager;
    private int m_userPriority;
    private AddressNumberDistance m_resultDistance;

    public CGGEInternalReverseGeocodeCandidate(InternalStreetAddress streetAddress, GeocodeOptions options, IDataManager datamanger, int userPriority) {
        this.m_streetAddress = streetAddress;
        this.m_options = options;
        this.m_dataManager = datamanger;
        this.m_userPriority = userPriority;
    }

    public double getDistance() {
        return this.m_streetAddress.getDistance();
    }

    public void matchAddressNumber(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        List<InternalRangeAddress> rangeList = this.m_streetAddress.getRangeList();
        int numberOfRanges = rangeList.size();
        if (numberOfRanges > 0) {
            this.m_resultDistance = this.calcClosestHN(this.m_streetAddress.getRangeList(), location, constraints);
            InternalRangeAddress range = rangeList.get(this.m_resultDistance.m_rangeNumber);
            range.setReverseGeocdedNumber(this.m_resultDistance.m_addressNumber);
            rangeList.remove(this.m_resultDistance.m_rangeNumber);
            rangeList.add(0, range);
            this.m_streetAddress.setClosestNumberRangeForReverseGeocode(0);
            this.m_streetAddress.setRangeList(rangeList);
        }
    }

    private AddressNumberDistance calcClosestHN(List<InternalRangeAddress> ranges, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        AddressNumberDistance hnrDistanceResult;
        int rangeNumber = 0;
        AddressNumberDistance leftDistance = null;
        AddressNumberDistance rightDistance = null;
        String srs = MidevConversionUtils.getSRSname((CoordSys)location.getCoordSysObject());
        CoordSys coordSys = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(srs);
        DirectPosition inputAsWGS84 = CoordConvertor.transformPointToWGS84((CoordSys)coordSys, (DirectPosition)location.getPositionPoint());
        CoordSys candidateCoordSys = this.m_streetAddress.getDataSetInfo().getMetaData().getSourceCoordSysObject();
        for (InternalRangeAddress range : ranges) {
            if (range.getDistance() == this.m_streetAddress.getDistance()) {
                List convertedSegment = CoordConvertor.transformPointsToWGS84((CoordSys)candidateCoordSys, range.getPoints());
                List<AddressNumber> addresses = range.computeAddressNumbers();
                if (!addresses.isEmpty()) {
                    for (AddressNumber addrNum : addresses) {
                        double housePercentage = range.calculateMatchedAddressNumPosition(range, addrNum);
                        DirectPosition addrPnt = Interpolator.interpolate((List)convertedSegment, (range.getRangeSide() == 1 ? 1 : 0) != 0, (double)housePercentage, (Length)constraints.getCornerOffsetAsLength(), (Length)constraints.getStreetOffsetAsLength());
                        double distance = ReverseGeocodeUtils.getDistance((DirectPosition)inputAsWGS84, (DirectPosition)addrPnt);
                        switch (range.getRangeSide()) {
                            case 0: 
                            case 1: {
                                if (leftDistance != null && !(distance < leftDistance.getDistance())) break;
                                leftDistance = new AddressNumberDistance(rangeNumber, addrNum.getHnrNumber1(), distance, housePercentage, addrPnt, convertedSegment);
                                break;
                            }
                            case 2: {
                                if (rightDistance != null && !(distance < rightDistance.getDistance())) break;
                                rightDistance = new AddressNumberDistance(rangeNumber, addrNum.getHnrNumber1(), distance, housePercentage, addrPnt, convertedSegment);
                            }
                        }
                    }
                }
            }
            ++rangeNumber;
        }
        if (leftDistance != null && rightDistance != null) {
            if (this.isAddressPointRange(ranges.get(leftDistance.m_rangeNumber)) && this.isAddressPointRange(ranges.get(rightDistance.m_rangeNumber))) {
                if (leftDistance.getDistance() == rightDistance.getDistance()) {
                    return leftDistance.m_rangeNumber < rightDistance.m_rangeNumber ? leftDistance : rightDistance;
                }
                if (leftDistance.getDistance() < rightDistance.getDistance()) {
                    return leftDistance;
                }
                return rightDistance;
            }
            hnrDistanceResult = leftDistance.getDistance() == rightDistance.getDistance() ? (leftDistance.m_rangeNumber < rightDistance.m_rangeNumber ? leftDistance : rightDistance) : (leftDistance.getDistance() < rightDistance.getDistance() ? (ReverseGeocodeUtils.pointsOnSameSideOfSegment((DirectPosition)inputAsWGS84, (DirectPosition)leftDistance.getInterpolatedLocation(), leftDistance.getSegmentAsWGS84()) ? leftDistance : rightDistance) : (ReverseGeocodeUtils.pointsOnSameSideOfSegment((DirectPosition)inputAsWGS84, (DirectPosition)rightDistance.getInterpolatedLocation(), rightDistance.getSegmentAsWGS84()) ? rightDistance : leftDistance));
        } else {
            hnrDistanceResult = leftDistance != null ? leftDistance : rightDistance;
        }
        if (hnrDistanceResult != null) {
            return hnrDistanceResult;
        }
        rangeNumber = 0;
        AddressNumberDistance centroidDistance = null;
        for (InternalRangeAddress range : ranges) {
            if (range.getDistance() == this.m_streetAddress.getDistance()) {
                List convertedSegment = CoordConvertor.transformPointsToWGS84((CoordSys)candidateCoordSys, range.getPoints());
                DirectPosition offsetCentroid = Interpolator.interpolate((List)convertedSegment, (range.getRangeSide() == 1 ? 1 : 0) != 0, (double)0.5, (Length)constraints.getCornerOffsetAsLength(), (Length)constraints.getStreetOffsetAsLength());
                centroidDistance = new AddressNumberDistance(rangeNumber, 0, range.getDistance(), 0.5, offsetCentroid, convertedSegment);
                if (ReverseGeocodeUtils.pointsOnSameSideOfSegment((DirectPosition)inputAsWGS84, (DirectPosition)offsetCentroid, (List)convertedSegment)) {
                    return centroidDistance;
                }
            }
            ++rangeNumber;
        }
        if (centroidDistance == null) {
            throw new IllegalStateException("Since this method is always called with ranges and one of the ranges should be the correct distance, this should not actually happen");
        }
        return centroidDistance;
    }

    private boolean isAddressPointRange(InternalRangeAddress range) {
        return range.isAddressPointData();
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        CGGEHandler handler = CGGEHandler.getInstance(this.m_streetAddress.getDataSetInfo(), this.m_streetAddress.getCountry(), this.m_streetAddress.getLanguage());
        ICGGECandidateConvertor candidateConverter = handler.getCandidateConvertor();
        IConstraints geoConstraints = this.m_options.getGeocodeConstraints();
        geoConstraints.setClientCoordinateSystem(location.getCoordSysObject());
        geoConstraints.setCornerOffset(constraints.getCornerOffset().getScalarValue());
        geoConstraints.setCornerOffsetUnits(constraints.getCornerOffset().getLinearUnit().getAbbreviation());
        geoConstraints.setStreetOffset(constraints.getStreetOffset().getScalarValue());
        geoConstraints.setStreetOffsetUnits(constraints.getStreetOffset().getLinearUnit().getAbbreviation());
        return ((CGGECandidateConvertor)candidateConverter).convertToReverseGeocodeCandidateAddress(this.m_streetAddress, this.m_dataManager, this.m_options, constraints);
    }

    public boolean isFromCorrectStreetSide(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        if (this.m_streetAddress.getDistance() == 0.0) {
            return true;
        }
        InternalRangeAddress range = this.m_streetAddress.getRangeList().get(0);
        return ReverseGeocodeUtils.pointsOnSameSideOfSegment((DirectPosition)CoordConvertor.transformPointToWGS84((CoordSys)location.getCoordSysObject(), (DirectPosition)location.getPositionPoint()), (DirectPosition)this.m_resultDistance.getInterpolatedLocation(), this.m_resultDistance.getSegmentAsWGS84());
    }

    public int getUserDictionaryPriority() {
        return this.m_userPriority;
    }

    public boolean matchesLocale(Locale loc) {
        if (loc != null) {
            return loc.getLanguage().equals(this.m_streetAddress.getLanguage());
        }
        return false;
    }

    public boolean isDefaultLocale() {
        CGGEHandler handler = CGGEHandler.getInstance(this.m_streetAddress.getDataSetInfo(), this.m_streetAddress.getCountry(), this.m_streetAddress.getLanguage());
        if (handler.getCountryDefaultLanguage() != null) {
            return handler.getCountryDefaultLanguage().equals(this.m_streetAddress.getLanguage());
        }
        return false;
    }

    public static class ReverseGeococodeCandidateComparator
    implements Comparator<CGGEInternalReverseGeocodeCandidate> {
        @Override
        public int compare(CGGEInternalReverseGeocodeCandidate candidate1, CGGEInternalReverseGeocodeCandidate candidate2) {
            return Double.compare(candidate1.getDistance(), candidate2.getDistance());
        }
    }

    private static class AddressNumberDistance {
        private final int m_rangeNumber;
        private final int m_addressNumber;
        private final double m_distance;
        private final double m_housePercentage;
        private final DirectPosition m_interpolatedLocation;
        private final List<DirectPosition> m_segmentAsWGS84;

        private AddressNumberDistance(int rangeNumber, int addressNumber, double distance, double housePercentage, DirectPosition interpolatedLocation, List<DirectPosition> segmentAsWGS84) {
            this.m_rangeNumber = rangeNumber;
            this.m_addressNumber = addressNumber;
            this.m_distance = distance;
            this.m_housePercentage = housePercentage;
            this.m_interpolatedLocation = interpolatedLocation;
            this.m_segmentAsWGS84 = segmentAsWGS84;
        }

        public double getDistance() {
            return this.m_distance;
        }

        public int getAddressNumber() {
            return this.m_addressNumber;
        }

        public int getRangeNumber() {
            return this.m_rangeNumber;
        }

        public double getHousePercentage() {
            return this.m_housePercentage;
        }

        public DirectPosition getInterpolatedLocation() {
            return this.m_interpolatedLocation;
        }

        public List<DirectPosition> getSegmentAsWGS84() {
            return this.m_segmentAsWGS84;
        }
    }
}

