/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.scorer;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.scorer.ScorerUtilities;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CGGEScorer
implements ICGGEScorer {
    private String m_country;
    private String m_language;
    private ICGGESoundex m_soundex;

    public CGGEScorer() {
    }

    protected CGGEScorer(ICGGESoundex soundex) {
        this.m_soundex = soundex;
    }

    protected ICGGESoundex getSoundex() {
        if (this.m_soundex == null) {
            this.m_soundex = CGGEHandler.getInstance(null, this.m_country, this.m_language).getSoundex();
        }
        return this.m_soundex;
    }

    @Override
    public boolean canMatchWords(AddressWord addrWord1, AddressWord addrWord2) {
        CodedWord word1 = addrWord1.getCodedWord();
        CodedWord word2 = addrWord2.getCodedWord();
        if (word1.getSoundex() == 0 && word1.getAttributes() == 0 || word2.getSoundex() == 0 && word2.getAttributes() == 0) {
            return false;
        }
        return word1.isSameSoundex(word2) || word1.isSameStartLetter(word2) || word1.isNumeral() && word2.isNumeral() || addrWord1.hasAlternates() && addrWord1.isRelatedWord(addrWord2) || addrWord2.hasAlternates() && addrWord2.isRelatedWord(addrWord1);
    }

    @Override
    public final FieldScore scoreAddressWords(AddressWord[] addressWords1, AddressWord[] addressWords2, FieldType type, FieldScore fieldScore) {
        if (DebugLevel.getDebugLevel((int)4) >= 3) {
            MMJLog.getLog().debug("CGGEScorer::scoreAddressWords");
            if (addressWords1 == null) {
                MMJLog.getLog().debug("inputWords: none");
            } else {
                MMJLog.getLog().debug("inputWords: ");
                for (AddressWord word : addressWords1) {
                    MMJLog.getLog().debug("\t" + word.toString());
                }
            }
            if (addressWords2 == null) {
                MMJLog.getLog().debug("candWords: none");
            } else {
                MMJLog.getLog().debug("candWords: ");
                for (AddressWord word : addressWords2) {
                    MMJLog.getLog().debug("\t" + word.toString());
                }
            }
        }
        AddressWord[] addressWords1Copy = addressWords1;
        AddressWord[] addressWords2Copy = addressWords2;
        int size1 = addressWords1 == null ? 0 : addressWords1.length;
        int size2 = addressWords2 == null ? 0 : addressWords2.length;
        FieldScore retScore = fieldScore == null ? new FieldScore() : fieldScore;
        retScore.m_matched = false;
        retScore.m_matchedCandWords = null;
        retScore.m_matchedInputWords = null;
        retScore.m_perfectCandWords = null;
        retScore.m_perfectInputWords = null;
        retScore.m_value = 0.0;
        if (size1 > 0 && size2 > 0) {
            boolean words1Changed = false;
            boolean words2Changed = false;
            addressWords1 = this.removeNonWeightedWords(addressWords1);
            addressWords2 = this.removeNonWeightedWords(addressWords2);
            if (addressWords1 == null || addressWords1.length < size1) {
                size1 = addressWords1.length;
                words1Changed = true;
            }
            if (addressWords2 == null || addressWords2.length < size2) {
                size2 = addressWords2.length;
                words2Changed = true;
            }
            if (size1 > 0 && size2 > 0) {
                this.scoreAddressWordArrays(addressWords1, addressWords2, type, retScore);
                boolean nonNumericCombinedWordsGood = false;
                if (retScore.m_value < 1.0) {
                    short[] numericCombine = new short[]{0};
                    boolean[] wordsChanged = this.handleCombinedWordsScoring(addressWords1, addressWords2, type, fieldScore, retScore, words1Changed, words2Changed, numericCombine);
                    words1Changed = wordsChanged[0];
                    words2Changed = wordsChanged[1];
                    if (retScore.m_value == 1.0 && numericCombine[0] == 0) {
                        nonNumericCombinedWordsGood = true;
                    }
                }
                if (retScore.m_value < 1.0) {
                    int newSize1;
                    ICGGESoundex soundex = this.getSoundex();
                    List<AddressWord[]> addressWordList1 = this.replaceMultiAbbrInput(addressWords1, soundex);
                    int n = newSize1 = addressWordList1 == null ? 0 : addressWordList1.size();
                    if (newSize1 > 0) {
                        FieldScore score1 = new FieldScore();
                        for (int i = 0; i < newSize1; ++i) {
                            AddressWord[] expandedWords = addressWordList1.get(i);
                            this.scoreAddressWordArrays(expandedWords, addressWords2, type, score1);
                            if (this.compareExpandedInputAltScores(score1, retScore) <= 0) continue;
                            words1Changed = true;
                            retScore.copy(score1);
                            if (score1.m_value >= 1.0) break;
                        }
                    }
                    if (retScore.m_value < 1.0) {
                        int newSize2;
                        List<AddressWord[]> addressWordList2 = this.replaceMultiAbbrInput(addressWords2, soundex);
                        int n2 = newSize2 = addressWordList2 == null ? 0 : addressWordList2.size();
                        if (newSize2 > 0) {
                            FieldScore score1 = new FieldScore();
                            for (int i = 0; i < newSize2; ++i) {
                                AddressWord[] expandedWords = addressWordList2.get(i);
                                this.scoreAddressWordArrays(addressWords1, expandedWords, type, score1);
                                if (score1.compare(score1, retScore) <= 0) continue;
                                words2Changed = true;
                                retScore.copy(score1);
                                if (score1.m_value >= 1.0) break;
                            }
                        }
                    }
                }
                if (words1Changed) {
                    this.reassignWordPositions(retScore.m_matchedInputWords, retScore.m_inputWords);
                    this.reassignWordPositions(retScore.m_perfectInputWords, retScore.m_inputWords);
                }
                if (words2Changed) {
                    this.reassignWordPositions(retScore.m_matchedCandWords, retScore.m_candWords);
                    this.reassignWordPositions(retScore.m_perfectCandWords, retScore.m_candWords);
                }
                if (nonNumericCombinedWordsGood) {
                    retScore.m_nonNumericCombinedWordScoreUsed = true;
                }
            }
        }
        retScore.m_inputWords = addressWords1Copy;
        retScore.m_candWords = addressWords2Copy;
        return retScore;
    }

    protected int compareExpandedInputAltScores(FieldScore expandedInputScore, FieldScore originalScore) {
        return expandedInputScore.compareTo(originalScore);
    }

    protected boolean[] handleCombinedWordsScoring(AddressWord[] addressWords1, AddressWord[] addressWords2, FieldType type, FieldScore fieldScore, FieldScore retScore, boolean words1Changed, boolean words2Changed, short[] numericCombine) {
        ICGGESoundex soundex = this.getSoundex();
        AddressWord[] newAddressWord2 = CGGEScorer.combineWords(addressWords1, addressWords2, soundex, numericCombine);
        AddressWord[] newAddressWord1 = CGGEScorer.combineWords(addressWords2, addressWords1, soundex, numericCombine);
        boolean[] wordsChanged = new boolean[]{words1Changed, words2Changed};
        if (newAddressWord1 != null || newAddressWord2 != null) {
            if (newAddressWord1 != null) {
                wordsChanged[0] = true;
            }
            if (newAddressWord2 != null) {
                wordsChanged[1] = true;
            }
            FieldScore score1 = new FieldScore();
            score1.copy(retScore);
            this.scoreAddressWordArrays(newAddressWord1 == null ? addressWords1 : newAddressWord1, newAddressWord2 == null ? addressWords2 : newAddressWord2, type, score1);
            if (score1.m_value > retScore.m_value) {
                retScore.copy(score1);
            }
        }
        return wordsChanged;
    }

    private static boolean isProbableAbbreviationCase(char[] chars1, char[] chars2, int size1, int size2) {
        if (size2 > 0 && size1 > 0 && chars1[0] != chars2[0]) {
            return false;
        }
        int ndx2 = 0;
        for (int ndx1 = 0; ndx1 < size1 && ndx2 < size2; ++ndx1) {
            char ch1 = chars1[ndx1];
            char ch2 = chars2[ndx2];
            if (ch1 != ch2) continue;
            ++ndx2;
        }
        return ndx2 == size2;
    }

    private List<AddressWord[]> replaceMultiAbbrInput(AddressWord[] addressWords, ICGGESoundex soundex) {
        ArrayList<AddressWord[]> expandedList = null;
        int wordCount = addressWords.length;
        for (int i = 0; i < wordCount; ++i) {
            AddressWord word = addressWords[i];
            List<WordAlternate> wordAltList = word.getAlternates();
            if (wordAltList == null) continue;
            for (WordAlternate wordAlt : wordAltList) {
                if (wordAlt.getAltType() != WordAlternate.ALT_TYPE.MULTI_WORD_ABBREVIATION) continue;
                AddressWord[] altWords = AddressWordArray.clone(wordAlt.getAltWords());
                ScorerUtilities.redistributeWeight(addressWords[i], altWords);
                short attribs = word.getAttributes();
                int addAttribs = 0;
                if (CodedWord.isCommonWord(attribs)) {
                    addAttribs = (short)(addAttribs | 0x100);
                }
                if (CodedWord.isArticleWord(attribs)) {
                    addAttribs = (short)(addAttribs | 0x400);
                }
                if (CodedWord.isThoroughfareTypeWord(attribs)) {
                    addAttribs = (short)(addAttribs | 0x200);
                }
                if (CodedWord.isDirectionalWord(attribs)) {
                    addAttribs = (short)(addAttribs | 0x800);
                }
                if (addAttribs > 0) {
                    for (AddressWord altWord : altWords) {
                        altWord.setAttribute((short)(altWord.getAttributes() | addAttribs));
                    }
                }
                int originalPos = addressWords[i].getData() == null ? i : (Integer)addressWords[i].getData();
                for (int j = 0; j < altWords.length; ++j) {
                    altWords[j].setData(originalPos);
                }
                if (altWords.length <= 1) continue;
                AddressWord[] expandWords = new AddressWord[wordCount + (altWords.length - 1)];
                if (i > 0) {
                    AddressWordArray.arraycopy(addressWords, 0, expandWords, 0, i);
                }
                AddressWordArray.arraycopy(altWords, 0, expandWords, i, altWords.length);
                if (i < wordCount - 1) {
                    AddressWordArray.arraycopy(addressWords, i + 1, expandWords, i + altWords.length, wordCount - (i + 1));
                }
                for (int j = i + 1; j < wordCount; ++j) {
                    int newNdx = j + (altWords.length - 1);
                    originalPos = expandWords[newNdx].getData() == null ? j : (Integer)expandWords[newNdx].getData();
                    expandWords[newNdx].setData(originalPos);
                }
                if (expandedList == null) {
                    expandedList = new ArrayList<AddressWord[]>(5);
                }
                expandedList.add(expandWords);
            }
        }
        return expandedList;
    }

    private void reassignWordPositions(IntArray wordsMatchedNdx, AddressWord[] words) {
        if (wordsMatchedNdx != null) {
            for (int wordMatchedNdx = 0; wordMatchedNdx < wordsMatchedNdx.size(); ++wordMatchedNdx) {
                int[] ndxs;
                int wordNdx = wordsMatchedNdx.get(wordMatchedNdx);
                AddressWord word = words[wordNdx];
                Object data = word.getData();
                if (data == null) continue;
                if (data instanceof Integer) {
                    wordsMatchedNdx.set(wordMatchedNdx, (Integer)data);
                    continue;
                }
                if (!(data instanceof int[]) || (ndxs = (int[])data).length <= 0) continue;
                wordsMatchedNdx.set(wordMatchedNdx, ndxs[0]);
                for (int i = 1; i < ndxs.length; ++i) {
                    if (wordsMatchedNdx.size() == wordMatchedNdx + 1) {
                        wordsMatchedNdx.add(ndxs[i]);
                    } else {
                        wordsMatchedNdx.insert(wordMatchedNdx + 1, ndxs[i]);
                    }
                    ++wordMatchedNdx;
                }
            }
        }
    }

    private static boolean startsWith(AddressWord word1, AddressWord word2, ICGGESoundex soundex) {
        CodedWord codedWord1 = word1.getCodedWord();
        CodedWord codedWord2 = word2.getCodedWord();
        if (codedWord2.getWordLength() < codedWord1.getWordLength()) {
            if (codedWord1.isNumeral() || codedWord2.isNumeral()) {
                if (MMUtils.startsWith(codedWord1.getNormalizedChar(), codedWord2.getNormalizedChar())) {
                    return true;
                }
            } else {
                return soundex.startsWithSoundex(codedWord1.getSoundex(), codedWord2.getSoundex());
            }
        }
        return false;
    }

    private static boolean combineWords(AddressWord fullWord, List<AddressWord> splitWordList, ICGGESoundex soundex, int start, short[] numericCombine) {
        int i;
        boolean combined = false;
        int n = splitWordList == null ? 0 : splitWordList.size();
        char[] bestCombinedWord = null;
        int bestCombinedSoundex = 0;
        int bestStart = -1;
        double bestCombinedScore = 0.0;
        boolean combinedWithNumeric = false;
        int n2 = i = start == -1 ? 0 : start;
        while (i < n - 1) {
            AddressWord splitWord1 = splitWordList.get(i);
            if (CGGEScorer.startsWith(fullWord, splitWord1, soundex)) {
                AddressWord splitWord2 = splitWordList.get(i + 1);
                if (!(CodedWord.isNumeric(splitWord2.getAttributes()) && !CodedWord.isNumeric(fullWord.getAttributes()) || MMUtils.startsWithDigits(splitWord2.getNormalizedChars()) && !MMUtils.containsDigits(fullWord.getNormalizedChars()))) {
                    char[] chars1 = splitWord1.getNormalizedChars();
                    char[] chars2 = splitWord2.getNormalizedChars();
                    CharArray combinedWord = new CharArray(chars1.length + chars2.length);
                    combinedWord.add(chars1);
                    combinedWord.add(chars2);
                    boolean canCombine = CharArray.startsWith(fullWord.getNormalizedChars(), combinedWord.getInternalBuffer());
                    int combinedSndx = soundex.addSoundex(splitWord1.getSoundex(), splitWord2.getSoundex());
                    if (!canCombine) {
                        canCombine = soundex.startsWithSoundex(fullWord.getSoundex(), combinedSndx);
                    }
                    if (canCombine) {
                        if (Character.isDigit(combinedWord.charAt(0)) || Character.isDigit(combinedWord.charAt(combinedWord.length() - 1))) {
                            combinedWithNumeric = true;
                        }
                        if (bestCombinedWord == null) {
                            bestCombinedSoundex = combinedSndx;
                            bestCombinedWord = combinedWord.getInternalBuffer();
                            bestStart = i;
                        } else {
                            double score1 = CGGEScorer.privateScoreKeys(fullWord.getNormalizedChars(), combinedWord.getInternalBuffer());
                            double score2 = bestCombinedScore;
                            if (score2 <= 0.0) {
                                score2 = CGGEScorer.privateScoreKeys(fullWord.getNormalizedChars(), bestCombinedWord);
                            }
                            if (score1 > score2) {
                                bestCombinedSoundex = combinedSndx;
                                bestCombinedSoundex = combinedSndx;
                                bestCombinedWord = combinedWord.getInternalBuffer();
                                bestStart = i;
                                bestCombinedScore = score1;
                            }
                        }
                    }
                }
            } else if (start > -1) break;
            ++i;
        }
        if (bestCombinedWord != null) {
            AddressWord splitWord1 = splitWordList.get(bestStart);
            AddressWord splitWord2 = splitWordList.get(bestStart + 1);
            AddressWord newAddressWord = new AddressWord(bestCombinedWord, bestCombinedSoundex, -1, splitWord1.m_wordType, (byte)(splitWord1.m_weight + splitWord2.m_weight));
            IntArray newPos = new IntArray(3);
            Object data = splitWord1.getData();
            if (data != null) {
                if (data instanceof Integer) {
                    newPos.add((int)((Integer)data));
                } else if (data instanceof int[]) {
                    newPos.add((int[])data);
                }
            } else {
                newPos.add(bestStart);
            }
            data = splitWord2.getData();
            if (data != null) {
                if (data instanceof Integer) {
                    newPos.add((int)((Integer)data));
                } else if (data instanceof int[]) {
                    newPos.add((int[])data);
                }
            } else {
                newPos.add(bestStart + 1);
            }
            newAddressWord.setData(newPos.asArray());
            splitWordList.remove(bestStart + 1);
            splitWordList.set(bestStart, newAddressWord);
            for (int i2 = bestStart + 1; i2 < splitWordList.size(); ++i2) {
                AddressWord word = splitWordList.get(i2);
                data = word.getData();
                if (data != null) {
                    if (!(data instanceof Integer)) continue;
                    newPos.add((Integer)data + 1);
                    continue;
                }
                word.setData(new Integer(i2 + 1));
            }
            if (bestStart + 1 < splitWordList.size() && bestCombinedScore < 1.0) {
                CGGEScorer.combineWords(fullWord, splitWordList, soundex, bestStart, numericCombine);
            }
            combined = true;
        }
        if (combinedWithNumeric && numericCombine != null) {
            numericCombine[0] = 1;
        }
        return combined;
    }

    protected static AddressWord[] combineWords(AddressWord[] addressWords1, AddressWord[] addressWords2, ICGGESoundex soundex, short[] numericsCombine) {
        int addrWord2Len;
        int addrWord1Len = addressWords1 == null ? 0 : addressWords1.length;
        int n = addrWord2Len = addressWords2 == null ? 0 : addressWords2.length;
        if (addrWord2Len > 1 && addrWord1Len > 0) {
            List<AddressWord> addrWordList = AddressWordArray.arrayAsList(addressWords2);
            for (int addrWord1Ndx = 0; addrWord1Ndx < addrWord1Len; ++addrWord1Ndx) {
                CGGEScorer.combineWords(addressWords1[addrWord1Ndx], addrWordList, soundex, -1, numericsCombine);
            }
            if (addrWordList.size() < addressWords2.length) {
                return addrWordList.toArray(new AddressWord[addrWordList.size()]);
            }
        }
        return null;
    }

    protected void scoreAddressWordArrays(AddressWord[] inputWords, AddressWord[] candWords, FieldType type, FieldScore fieldScore) {
        if (type == FieldType.STREET_NAME_FIELD_TYPE) {
            this.scoreAddressWordArraysForStreet(inputWords, candWords, fieldScore);
        } else {
            this.scoreAddressWordArraysGeneral(inputWords, candWords, fieldScore);
        }
    }

    private FieldScoreEx calculateScoreForWordsMatchedInOrder(WordScore[][] matchMatrix, AddressWord[] inputWords, int size1, AddressWord[] candWords, int size2, double highScore) {
        int col;
        FieldScoreEx fieldScore = new FieldScoreEx();
        IntArray w1MatchedNdx = new IntArray(size1);
        IntArray w2MatchedNdx = new IntArray(size2);
        IntArray w1perfectNdx = new IntArray(size1);
        IntArray w2perfectNdx = new IntArray(size2);
        double higestIndividualWordScore = 0.0;
        int bestStartCol = -1;
        int bestStartRow = 0;
        block0: for (int row = 0; row < size2; ++row) {
            for (col = 0; col < size1; ++col) {
                double currentWordScore;
                double fullScore = 0.0;
                WordScore ws = matchMatrix[row][col];
                double d = currentWordScore = ws != null ? ws.m_score : 0.0;
                if (currentWordScore > 0.0) {
                    fullScore += currentWordScore * ((double)candWords[row].m_weight * 0.01);
                    int i = 1;
                    while (row + i < size2 && col + i < size1) {
                        ws = matchMatrix[row + i][col + i];
                        currentWordScore = ws != null ? ws.m_score : 0.0;
                        fullScore += currentWordScore * ((double)candWords[row + i].m_weight * 0.01);
                        ++i;
                    }
                    if (fullScore > highScore) {
                        highScore = fullScore;
                        bestStartCol = col;
                        bestStartRow = row;
                    }
                }
                if (highScore >= 1.0) continue block0;
            }
        }
        int altWordMatchCount = 0;
        if (bestStartCol > -1) {
            highScore = 0.0;
            col = bestStartCol;
            for (int row = bestStartRow; row < size2 && col < size1; ++row, ++col) {
                WordScore ws = matchMatrix[row][col];
                if (ws == null) {
                    ws = this.privateScoreAddressWords(candWords[row], inputWords[col]);
                    if (ws.m_score < 0.8) {
                        ws = null;
                    }
                }
                if (ws == null) continue;
                highScore += ws.m_score * ((double)candWords[row].m_weight * 0.01);
                w1MatchedNdx.add(col);
                w2MatchedNdx.add(row);
                if (ws.m_score >= 1.0) {
                    w1perfectNdx.add(col);
                    w2perfectNdx.add(row);
                }
                if (ws.m_score > higestIndividualWordScore) {
                    higestIndividualWordScore = ws.m_score;
                }
                if (!ws.m_matchedWithAlt) continue;
                ++altWordMatchCount;
            }
        }
        fieldScore.m_value = highScore;
        fieldScore.m_matchedInputWords = w1MatchedNdx;
        fieldScore.m_perfectInputWords = w1perfectNdx;
        fieldScore.m_matchedCandWords = w2MatchedNdx;
        fieldScore.m_perfectCandWords = w2perfectNdx;
        fieldScore.m_highestIndividualWordScore = higestIndividualWordScore;
        fieldScore.m_altMatchedCount = altWordMatchCount;
        return fieldScore;
    }

    private static FieldScoreEx calculateScoreCaterForSwappedWords(WordScore[][] matchMatrix, AddressWord[] inputWords, int size1, AddressWord[] candWords, int size2, double highScore) {
        IntArray w1MatchedNdx = null;
        IntArray w2MatchedNdx = null;
        IntArray w1perfectNdx = null;
        IntArray w2perfectNdx = null;
        double higestIndividualWordScore = 0.0;
        IntArray w1mNdx = new IntArray(size1);
        IntArray w2mNdx = new IntArray(size2);
        IntArray w1pNdx = new IntArray(size1);
        IntArray w2pNdx = new IntArray(size2);
        int bestAltWordMatchedCount = 0;
        int lastCol = -1;
        boolean swapped = false;
        for (int testCol = 0; testCol < size1; ++testCol) {
            w1mNdx.removeAll();
            w2mNdx.removeAll();
            w1pNdx.removeAll();
            w2pNdx.removeAll();
            lastCol = testCol;
            int altWordMatchedCount = 0;
            double score = 0.0;
            int startCol = 0;
            int endCol = size1;
            int row = 0;
            for (int col = testCol; row < size2 && col < size1; ++col, ++row) {
                if (col < lastCol) {
                    swapped = true;
                }
                lastCol = col;
                WordScore ws = matchMatrix[row][col];
                double s = ws != null ? ws.m_score : 0.0;
                int skipToCol = -1;
                if (s > 1.0E-4 && s < 1.0 && col < size1 - 1) {
                    int col1 = col;
                    while (++col1 < endCol) {
                        double s1;
                        WordScore ws1 = matchMatrix[row][col1];
                        double d = s1 = ws1 != null ? ws1.m_score : 0.0;
                        if (s1 < s) break;
                        if (!(s1 > s)) continue;
                        s = 0.0;
                        skipToCol = col1;
                        break;
                    }
                }
                if (s > 1.0E-4) {
                    score += s * ((double)candWords[row].m_weight * 0.01);
                    w1mNdx.add(col);
                    w2mNdx.add(row);
                    if (s >= 1.0) {
                        w1pNdx.add(col);
                        w2pNdx.add(row);
                    }
                    higestIndividualWordScore = s;
                    if (ws.m_matchedWithAlt) {
                        ++altWordMatchedCount;
                    }
                    if (col != size1 - 1) continue;
                    endCol = col;
                    col = startCol - 1;
                    continue;
                }
                int savedRow = row;
                int savedCol = col;
                startCol = col++;
                if (skipToCol > -1) {
                    col = skipToCol;
                }
                int matchedCol = endCol;
                while (col < endCol && row < size2) {
                    if (col < lastCol) {
                        swapped = true;
                    }
                    lastCol = col;
                    ws = matchMatrix[row][col];
                    double d = s = ws != null ? ws.m_score : 0.0;
                    if (s > 1.0E-4) {
                        score += s * ((double)candWords[row].m_weight * 0.01);
                        w1mNdx.add(col);
                        w2mNdx.add(row);
                        if (s >= 1.0) {
                            w1pNdx.add(col);
                            w2pNdx.add(row);
                        }
                        higestIndividualWordScore = s;
                        if (ws.m_matchedWithAlt) {
                            ++altWordMatchedCount;
                        }
                        if (col > savedCol) {
                            savedCol = col;
                        }
                        if (row > savedRow) {
                            savedRow = row;
                        }
                        if (matchedCol > col) {
                            matchedCol = col;
                        }
                        if (col == size1 - 1) {
                            endCol = col;
                            col = startCol - 1;
                        }
                    } else {
                        endCol = matchedCol == endCol ? col - 1 : matchedCol;
                        col = startCol - 1;
                        --row;
                    }
                    ++col;
                    ++row;
                }
                row = savedRow;
                col = savedCol;
            }
            if (swapped && score > highScore) {
                if (score > 0.5 && score < 1.0 && w1mNdx != null && w1mNdx.size() > 1) {
                    int start = w1mNdx.min();
                    int end = w1mNdx.max();
                    for (int wordNdx = start; wordNdx <= end; ++wordNdx) {
                        if (w1pNdx != null && w1pNdx.contains(wordNdx)) continue;
                        AddressWord word = inputWords[wordNdx];
                        if (AddressWord.isSignificantWord(word)) {
                            score -= 0.1;
                            continue;
                        }
                        if (CodedWord.isArticleWord(word.getAttributes())) continue;
                        score -= 0.05;
                    }
                }
                if (w1MatchedNdx == null) {
                    w1MatchedNdx = new IntArray(w1mNdx);
                } else {
                    w1MatchedNdx.replace(w1mNdx);
                }
                if (w2MatchedNdx == null) {
                    w2MatchedNdx = new IntArray(w2mNdx);
                } else {
                    w2MatchedNdx.replace(w2mNdx);
                }
                if (w1perfectNdx == null) {
                    w1perfectNdx = new IntArray(w1pNdx);
                } else {
                    w1perfectNdx.replace(w1pNdx);
                }
                if (w2perfectNdx == null) {
                    w2perfectNdx = new IntArray(w2pNdx);
                } else {
                    w2perfectNdx.replace(w2pNdx);
                }
                bestAltWordMatchedCount = altWordMatchedCount;
                highScore = score;
            }
            if (highScore >= 1.0) break;
        }
        FieldScoreEx fieldScore = null;
        if (w1MatchedNdx != null) {
            fieldScore = new FieldScoreEx();
            fieldScore.m_value = highScore;
            fieldScore.m_matchedInputWords = w1MatchedNdx;
            fieldScore.m_perfectInputWords = w1perfectNdx;
            fieldScore.m_matchedCandWords = w2MatchedNdx;
            fieldScore.m_perfectCandWords = w2perfectNdx;
            fieldScore.m_highestIndividualWordScore = higestIndividualWordScore;
            fieldScore.m_altMatchedCount = bestAltWordMatchedCount;
        }
        return fieldScore;
    }

    private static FieldScoreEx calculateScoreCaterForMissingCandidateWords(WordScore[][] matchMatrix, AddressWord[] inputWords, int size1, AddressWord[] candWords, int size2, double highScore) {
        IntArray w1MatchedNdx = null;
        IntArray w2MatchedNdx = null;
        IntArray w1perfectNdx = null;
        IntArray w2perfectNdx = null;
        double higestIndividualWordScore = 0.0;
        int bestAltWordMatchedCount = 0;
        IntArray w1mNdx = new IntArray(size1);
        IntArray w2mNdx = new IntArray(size2);
        IntArray w1pNdx = new IntArray(size1);
        IntArray w2pNdx = new IntArray(size2);
        block0: for (int testCol = 0; testCol < size1; ++testCol) {
            int startRow;
            int endCol = testCol - 1;
            int col = endCol + 1;
            for (int row = startRow = 0; row < size2; ++row) {
                double score = 0.0;
                w1mNdx.removeAll();
                w2mNdx.removeAll();
                w1pNdx.removeAll();
                w2pNdx.removeAll();
                int altWordMatchedCount = 0;
                WordScore ws = matchMatrix[row][col];
                int row1 = row;
                int col1 = col;
                if (ws == null || !(ws.m_score > 1.0E-4)) continue;
                block2: do {
                    WordScore ws1;
                    if (ws != null && ws.m_score > 1.0E-4) {
                        double s = ws.m_score;
                        boolean altWordMatched = false;
                        startRow = row;
                        s = ws.m_score;
                        altWordMatched = ws.m_matchedWithAlt;
                        score += s * ((double)candWords[row1].m_weight * 0.01);
                        w1mNdx.add(col1);
                        w2mNdx.add(row1);
                        if (s >= 1.0) {
                            w1pNdx.add(col1);
                            w2pNdx.add(row1);
                        }
                        if (s > higestIndividualWordScore) {
                            higestIndividualWordScore = s;
                        }
                        if (altWordMatched) {
                            ++altWordMatchedCount;
                        }
                        ++row1;
                    }
                    if (++col1 >= size1 || row1 >= size2 || (ws = matchMatrix[row1][col1]) == null || !(ws.m_score > 1.0E-4)) continue;
                    int col2 = col1 + 1;
                    while (col2 < size1 && (ws1 = matchMatrix[row1][col2]) != null && ws1.m_score > ws.m_score) {
                        if (row1 + 1 < size2) {
                            WordScore ws2 = matchMatrix[row1 + 1][col2];
                            if (ws2 != null && !(ws2.m_score < ws1.m_score)) continue block2;
                            ++col1;
                            ws = ws1;
                            continue block2;
                        }
                        ++col1;
                        ws = ws1;
                    }
                } while (col1 < size1 && row1 < size2);
                if (score > highScore) {
                    if (score > 0.2 && w1mNdx != null && w1mNdx.size() > 1) {
                        int start = w1mNdx.min();
                        int end = w1mNdx.max();
                        for (int wordNdx = start + 1; wordNdx < end; ++wordNdx) {
                            if (w1mNdx.contains(wordNdx)) continue;
                            AddressWord word = inputWords[wordNdx];
                            if (AddressWord.isSignificantWord(word)) {
                                score -= 0.1;
                                continue;
                            }
                            if (CodedWord.isArticleWord(word.getAttributes())) continue;
                            score -= 0.05;
                        }
                    }
                    if (score > highScore) {
                        if (w1MatchedNdx == null) {
                            w1MatchedNdx = new IntArray(w1mNdx);
                        } else {
                            w1MatchedNdx.replace(w1mNdx);
                        }
                        if (w2MatchedNdx == null) {
                            w2MatchedNdx = new IntArray(w2mNdx);
                        } else {
                            w2MatchedNdx.replace(w2mNdx);
                        }
                        if (w1perfectNdx == null) {
                            w1perfectNdx = new IntArray(w1pNdx);
                        } else {
                            w1perfectNdx.replace(w1pNdx);
                        }
                        if (w2perfectNdx == null) {
                            w2perfectNdx = new IntArray(w2pNdx);
                        } else {
                            w2perfectNdx.replace(w2pNdx);
                        }
                        bestAltWordMatchedCount = altWordMatchedCount;
                        highScore = score;
                    }
                }
                if (highScore >= 1.0) continue block0;
            }
        }
        FieldScoreEx fieldScore = null;
        if (w1MatchedNdx != null) {
            fieldScore = new FieldScoreEx();
            fieldScore.m_value = highScore;
            fieldScore.m_matchedInputWords = w1MatchedNdx;
            fieldScore.m_perfectInputWords = w1perfectNdx;
            fieldScore.m_matchedCandWords = w2MatchedNdx;
            fieldScore.m_perfectCandWords = w2perfectNdx;
            fieldScore.m_highestIndividualWordScore = higestIndividualWordScore;
            fieldScore.m_altMatchedCount = bestAltWordMatchedCount;
        }
        return fieldScore;
    }

    private static FieldScoreEx calculateScoreCaterForMissingInputWords(WordScore[][] matchMatrix, AddressWord[] inputWords, int size1, AddressWord[] candWords, int size2, double highScore) {
        IntArray w1MatchedNdx = null;
        IntArray w2MatchedNdx = null;
        IntArray w1perfectNdx = null;
        IntArray w2perfectNdx = null;
        double higestIndividualWordScore = 0.0;
        int testRow = 0;
        IntArray w1mNdx = new IntArray(size1);
        IntArray w2mNdx = new IntArray(size2);
        IntArray w1pNdx = new IntArray(size1);
        IntArray w2pNdx = new IntArray(size2);
        int bestAltMatchedWordCount = 0;
        int startRow = testRow;
        for (int testCol = 0; testCol < size1; ++testCol) {
            int endCol = testCol - 1;
            double score = 0.0;
            int altMatchedWordCount = 0;
            w1mNdx.removeAll();
            w2mNdx.removeAll();
            w1pNdx.removeAll();
            w2pNdx.removeAll();
            for (int row = startRow; row < size2; ++row) {
                double s = 0.0;
                double d = 0.0;
                int col = endCol + 1;
                boolean altMatched = false;
                if (col < size1) {
                    WordScore ws = matchMatrix[row][col];
                    if (ws != null) {
                        altMatched = ws.m_matchedWithAlt;
                        s = ws.m_score;
                    }
                    if (s < 1.0 && row < size2 - 1) {
                        for (int i = row + 1; i < size2; ++i) {
                            ws = matchMatrix[i][col];
                            double d2 = d = ws != null ? ws.m_score : 0.0;
                            if (d > 1.0E-4) break;
                        }
                    }
                    if (d > s) {
                        s = 0.0;
                        ++col;
                    } else {
                        endCol = col;
                    }
                }
                if (s > 1.0E-4) {
                    score += s * ((double)candWords[row].m_weight * 0.01);
                    w1mNdx.add(col);
                    w2mNdx.add(row);
                    if (s >= 1.0) {
                        w1pNdx.add(col);
                        w2pNdx.add(row);
                    }
                    if (s > higestIndividualWordScore) {
                        higestIndividualWordScore = s;
                    }
                    if (altMatched) {
                        ++altMatchedWordCount;
                    }
                }
                if (score >= 1.0) break;
            }
            if (score > highScore && score > highScore) {
                if (w1MatchedNdx == null) {
                    w1MatchedNdx = new IntArray(w1mNdx.size());
                }
                w1MatchedNdx.add(w1mNdx);
                if (w2MatchedNdx == null) {
                    w2MatchedNdx = new IntArray(w2mNdx.size());
                }
                w2MatchedNdx.add(w2mNdx);
                if (w1perfectNdx == null) {
                    w1perfectNdx = new IntArray(w1pNdx.size());
                }
                w1perfectNdx.add(w1pNdx);
                if (w2perfectNdx == null) {
                    w2perfectNdx = new IntArray(w2pNdx.size());
                }
                w2perfectNdx.add(w2pNdx);
                bestAltMatchedWordCount = altMatchedWordCount;
                highScore = score;
            }
            if (highScore >= 1.0) break;
        }
        FieldScoreEx fieldScore = null;
        if (w1MatchedNdx != null) {
            fieldScore = new FieldScoreEx();
            fieldScore.m_value = highScore;
            fieldScore.m_matchedInputWords = w1MatchedNdx;
            fieldScore.m_perfectInputWords = w1perfectNdx;
            fieldScore.m_matchedCandWords = w2MatchedNdx;
            fieldScore.m_perfectCandWords = w2perfectNdx;
            fieldScore.m_highestIndividualWordScore = higestIndividualWordScore;
            fieldScore.m_altMatchedCount = bestAltMatchedWordCount;
        }
        return fieldScore;
    }

    protected void calculateCombinedScoreFromMatrix(WordScore[][] matchMatrix, AddressWord[] inputWords, int size1, AddressWord[] candWords, int size2, FieldScore fieldScore, boolean considerSwap) {
        double checkScore;
        FieldScoreEx altFieldScore;
        double highScore = 0.0;
        int prefectCandWords = 0;
        FieldScoreEx fieldScoreEx = this.calculateScoreForWordsMatchedInOrder(matchMatrix, inputWords, size1, candWords, size2, 0.0);
        if (fieldScoreEx != null) {
            highScore = fieldScoreEx.m_value;
            prefectCandWords = IntArray.size(fieldScoreEx.m_perfectCandWords);
        }
        if (size2 > 1 && highScore < 1.0 && (altFieldScore = CGGEScorer.calculateScoreCaterForMissingInputWords(matchMatrix, inputWords, size1, candWords, size2, checkScore = highScore < 0.5 ? highScore * 1.1 : highScore + (1.0 - highScore) * 0.1)) != null && (IntArray.size(altFieldScore.m_perfectCandWords) > prefectCandWords || altFieldScore.m_value >= (1.0 - highScore) * 0.25)) {
            fieldScoreEx = altFieldScore;
            highScore = fieldScoreEx.m_value;
            prefectCandWords = IntArray.size(altFieldScore.m_perfectCandWords);
        }
        if (size2 > 1 && highScore < 1.0 && (altFieldScore = CGGEScorer.calculateScoreCaterForMissingCandidateWords(matchMatrix, inputWords, size1, candWords, size2, checkScore = highScore < 0.5 ? highScore * 1.1 : highScore + (1.0 - highScore) * 0.1)) != null && (IntArray.size(altFieldScore.m_perfectCandWords) > prefectCandWords || altFieldScore.m_value >= (1.0 - highScore) * 0.25)) {
            fieldScoreEx = altFieldScore;
            highScore = fieldScoreEx.m_value;
            prefectCandWords = IntArray.size(altFieldScore.m_perfectCandWords);
        }
        if (size2 > 1 && highScore < 1.0) {
            highScore = this.handleSwappedWordsScoring(highScore, matchMatrix, inputWords, size1, candWords, size2, fieldScoreEx, considerSwap);
        }
        if (fieldScoreEx != null && highScore > 0.0 && highScore < 1.0 && size1 > 1 && size2 > 1) {
            IntArray w2MatchedNdx = fieldScoreEx.m_matchedCandWords;
            IntArray w2perfectNdx = fieldScoreEx.m_perfectCandWords;
            double higestIndividualWordScore = fieldScoreEx.m_highestIndividualWordScore;
            int weightWordCount = 0;
            for (int i = 0; i < size2; ++i) {
                if (candWords[i].m_weight <= 0) continue;
                ++weightWordCount;
            }
            double matchedWordWeight = (w2MatchedNdx == null ? 0.0 : (double)w2MatchedNdx.size()) / (double)weightWordCount * 0.05;
            double perfectWordWeight = (w2perfectNdx == null ? 0.0 : (double)w2perfectNdx.size()) / (double)weightWordCount * 0.05;
            highScore *= 0.85;
            highScore += matchedWordWeight > 0.05 ? 0.05 : matchedWordWeight;
            highScore += perfectWordWeight > 0.05 ? 0.05 : perfectWordWeight;
            if (higestIndividualWordScore > 0.9) {
                highScore += 0.05;
            }
        }
        fieldScore.m_value = highScore;
        if (fieldScoreEx != null) {
            fieldScore.m_matchedInputWords = fieldScoreEx.m_matchedInputWords;
            fieldScore.m_perfectInputWords = fieldScoreEx.m_perfectInputWords;
            fieldScore.m_matchedCandWords = fieldScoreEx.m_matchedCandWords;
            fieldScore.m_perfectCandWords = fieldScoreEx.m_perfectCandWords;
            fieldScore.m_altMatchedCount = fieldScoreEx.m_altMatchedCount;
        } else {
            fieldScore.m_matchedInputWords = null;
            fieldScore.m_perfectInputWords = null;
            fieldScore.m_matchedCandWords = null;
            fieldScore.m_perfectCandWords = null;
        }
    }

    protected double handleSwappedWordsScoring(double highScore, WordScore[][] matchMatrix, AddressWord[] inputWords, int size1, AddressWord[] candWords, int size2, FieldScoreEx fieldScoreEx, boolean considerSwap) {
        double checkScore = highScore < 0.5 ? highScore * 1.1 : highScore + (1.0 - highScore) * 0.1;
        FieldScoreEx altFieldScore = CGGEScorer.calculateScoreCaterForSwappedWords(matchMatrix, inputWords, size1, candWords, size2, checkScore);
        if (altFieldScore != null) {
            fieldScoreEx.m_value = altFieldScore.m_value;
            fieldScoreEx.m_matchedInputWords = altFieldScore.m_matchedInputWords;
            fieldScoreEx.m_perfectInputWords = altFieldScore.m_perfectInputWords;
            fieldScoreEx.m_matchedCandWords = altFieldScore.m_matchedCandWords;
            fieldScoreEx.m_perfectCandWords = altFieldScore.m_perfectCandWords;
            fieldScoreEx.m_highestIndividualWordScore = altFieldScore.m_highestIndividualWordScore;
            fieldScoreEx.m_altMatchedCount = altFieldScore.m_altMatchedCount;
            highScore = fieldScoreEx.m_value;
        }
        return highScore;
    }

    protected void scoreAddressWordArraysForStreet(AddressWord[] inputWords, AddressWord[] candWords, FieldScore fieldScore) {
        int size2;
        fieldScore.m_inputWords = inputWords;
        fieldScore.m_candWords = candWords;
        int size1 = inputWords == null ? 0 : inputWords.length;
        int n = size2 = candWords == null ? 0 : candWords.length;
        if (size2 == 0 && size1 == 0) {
            fieldScore.m_value = 1.0;
        } else if (size2 != 0 && size1 != 0) {
            WordScore[][] matchMatrix = new WordScore[size2][size1];
            int tpos2 = -1;
            boolean candTypeFound = false;
            boolean inputTypeFound = false;
            for (int wordNdx2 = 0; wordNdx2 < size2; ++wordNdx2) {
                if (!CGGEScorer.isAThroughfareType(candWords[wordNdx2])) continue;
                tpos2 = wordNdx2;
                candTypeFound = true;
                int tpos1 = -1;
                for (int wordNdx1 = 0; wordNdx1 < size1; ++wordNdx1) {
                    AddressWord compareToWord;
                    int col;
                    AddressWord compareWord;
                    int row;
                    if (!CGGEScorer.isAThroughfareType(inputWords[wordNdx1])) continue;
                    inputTypeFound = true;
                    tpos1 = wordNdx1;
                    matchMatrix[tpos2][tpos1] = this.privateScoreAddressWords(inputWords[tpos1], candWords[tpos2]);
                    for (row = tpos2 - 1; row >= 0; --row) {
                        compareWord = candWords[row];
                        for (col = tpos1 - 1; col >= 0; --col) {
                            compareToWord = inputWords[col];
                            if (!this.canMatchWords(compareWord, compareToWord)) continue;
                            matchMatrix[row][col] = this.privateScoreAddressWords(compareToWord, compareWord);
                        }
                    }
                    for (row = tpos2 + 1; row < size2; ++row) {
                        compareWord = candWords[row];
                        for (col = tpos1 + 1; col < size1; ++col) {
                            compareToWord = inputWords[col];
                            if (!this.canMatchWords(compareWord, compareToWord)) continue;
                            matchMatrix[row][col] = this.privateScoreAddressWords(compareToWord, compareWord);
                        }
                    }
                    FieldScore score = new FieldScore();
                    this.calculateCombinedScoreFromMatrix(matchMatrix, inputWords, size1, candWords, size2, score, true);
                    if (score.compare(score, fieldScore) <= 0) continue;
                    fieldScore.m_value = score.m_value;
                    fieldScore.m_matchedInputWords = score.m_matchedInputWords;
                    fieldScore.m_perfectInputWords = score.m_perfectInputWords;
                    fieldScore.m_matchedCandWords = score.m_matchedCandWords;
                    fieldScore.m_perfectCandWords = score.m_perfectCandWords;
                    fieldScore.m_altMatchedCount = score.m_altMatchedCount;
                }
            }
            if (!candTypeFound || !inputTypeFound) {
                this.scoreAddressWordArraysGeneral(inputWords, candWords, fieldScore);
            }
        }
    }

    protected final void scoreAddressWordArraysGeneral(AddressWord[] inputWords, AddressWord[] candWords, FieldScore fieldScore) {
        int size2;
        fieldScore.m_inputWords = inputWords;
        fieldScore.m_candWords = candWords;
        if (DebugLevel.getDebugLevel((int)4) >= 3) {
            MMJLog.getLog().debug("CGGEScorer::scoreAddressWordArraysGeneral");
            if (inputWords != null) {
                MMJLog.getLog().debug("inputWords: ");
                for (AddressWord word : inputWords) {
                    MMJLog.getLog().debug("\t" + word.toString());
                }
            } else {
                MMJLog.getLog().debug("inputWords: none");
            }
            if (candWords != null) {
                MMJLog.getLog().debug("candWords: ");
                for (AddressWord word : candWords) {
                    MMJLog.getLog().debug("\t" + word.toString());
                }
            } else {
                MMJLog.getLog().debug("candWords: none");
            }
        }
        int size1 = inputWords == null ? 0 : inputWords.length;
        int n = size2 = candWords == null ? 0 : candWords.length;
        if (size2 == 0 && size1 == 0) {
            fieldScore.m_value = 1.0;
        } else if (size2 != 0 && size1 != 0) {
            WordScore[][] matchMatrix = new WordScore[size2][size1];
            for (int row = 0; row < size2; ++row) {
                AddressWord compareWord = candWords[row];
                for (int col = 0; col < size1; ++col) {
                    AddressWord compareToWord = inputWords[col];
                    if (!this.canMatchWords(compareWord, compareToWord)) continue;
                    matchMatrix[row][col] = this.privateScoreAddressWords(compareToWord, compareWord);
                }
            }
            this.calculateCombinedScoreFromMatrix(matchMatrix, inputWords, size1, candWords, size2, fieldScore, true);
            if (DebugLevel.getDebugLevel((int)4) >= 3) {
                MMJLog.getLog().debug("fieldScore: " + fieldScore);
            }
        }
    }

    private boolean isWordToRemove(AddressWord word) {
        if (word.m_weight != 0) {
            return false;
        }
        if (word.getCodedWord().getSoundex() == 0) {
            return !word.isNumeral();
        }
        return false;
    }

    private final AddressWord[] removeNonWeightedWords(AddressWord[] addrWords) {
        int count = addrWords == null ? 0 : addrWords.length;
        int removeCount = 0;
        for (int i = 0; i < count; ++i) {
            AddressWord addrWord = addrWords[i];
            if (!this.isWordToRemove(addrWord)) continue;
            ++removeCount;
        }
        if (removeCount > 0) {
            AddressWord[] newAddrWords = new AddressWord[count - removeCount];
            int added = 0;
            for (int i = 0; i < count; ++i) {
                AddressWord addrWord = addrWords[i];
                if (this.isWordToRemove(addrWord)) continue;
                AddressWord newWord = new AddressWord(addrWord);
                newAddrWords[added++] = newWord;
                newWord.setData(new Integer(i));
            }
            return newAddrWords;
        }
        return addrWords;
    }

    private static boolean isAThroughfareType(AddressWord word1) {
        return CodedWord.isThoroughfareTypeWord(word1.getAttributes());
    }

    @Override
    public double scoreNumber(String num1, String num2) {
        int n1 = 0;
        int n2 = 0;
        try {
            n1 = Integer.parseInt(num1);
            n2 = Integer.parseInt(num2);
        }
        catch (NumberFormatException ne) {
            return 0.0;
        }
        if (n1 == n2) {
            return 1.0;
        }
        return this.scoreNumber(n1, n2);
    }

    protected WordScore privateScoreAddressWords(AddressWord word1, AddressWord word2) {
        char[] key1 = word1.getNormalizedChars();
        char[] key2 = word2.getNormalizedChars();
        WordScore wordScore = new WordScore();
        double score = 0.0;
        if (key1 != null && key2 != null) {
            if (Arrays.equals(key1, key2)) {
                score = 1.0;
            } else {
                score = this.scoreKeys(key1, key2);
                if (word1.getSoundex() > 0 && word1.getSoundex() == word2.getSoundex()) {
                    score = 0.3 + score * 0.7;
                }
                if (score < 1.0) {
                    double altScore = 0.0;
                    if (word1.hasAlternates() && word1.isRelatedWord(word2) || word2.hasAlternates() && word2.isRelatedWord(word1)) {
                        altScore = 1.0;
                    }
                    if (altScore < 1.0) {
                        altScore = CGGEScorer.scoreNumerics(word1, word2);
                    }
                    if (altScore > score) {
                        score = altScore;
                        wordScore.m_matchedWithAlt = true;
                    }
                }
            }
        }
        wordScore.m_score = score;
        return wordScore;
    }

    @Override
    public double scoreAddressWords(AddressWord word1, AddressWord word2) {
        return this.privateScoreAddressWords((AddressWord)word1, (AddressWord)word2).m_score;
    }

    @Override
    public boolean doWordsMatch(AddressWord word1, AddressWord word2) {
        char[] key2;
        char[] key1 = word1.getNormalizedChars();
        if (key1 == (key2 = word2.getNormalizedChars())) {
            return true;
        }
        if (key1 != null && key2 != null) {
            if (Arrays.equals(key1, key2)) {
                return true;
            }
            if (word1.hasAlternates() && word1.isRelatedWord(word2) || word2.hasAlternates() && word2.isRelatedWord(word1)) {
                return true;
            }
            if (word1.isNumeral() && word2.isNumeral()) {
                try {
                    return word1.getNumberValue() == word2.getNumberValue();
                }
                catch (NumberFormatException ne) {
                    return false;
                }
            }
        }
        return false;
    }

    private static final double scoreNumerics(AddressWord word1, AddressWord word2) {
        if (word1.isNumeral() && word2.isNumeral()) {
            try {
                int n1 = word1.getNumberValue();
                int n2 = word2.getNumberValue();
                return CGGEScorer.privateScoreNumber(n1, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    @Override
    public void addWeights(AddressWord[] words) {
        int wordCount;
        int n = wordCount = words == null ? 0 : words.length;
        if (wordCount == 1) {
            words[0].m_weight = (byte)100;
        } else {
            double totLen = 0.0;
            for (int i = 0; i < wordCount; ++i) {
                int len;
                int n2 = len = words[i].getCodedWord().getChars() == null ? 0 : words[i].getCodedWord().getChars().length;
                if (len <= 0) continue;
                len = len <= 2 ? 2 : (len <= 6 ? 6 : 8);
                totLen += (double)len;
            }
            int total = 0;
            for (int i = 0; i < wordCount; ++i) {
                if (totLen > 0.0) {
                    int len;
                    int n3 = len = words[i].getCodedWord().getChars() == null ? 0 : words[i].getCodedWord().getChars().length;
                    if (len > 0) {
                        len = len <= 2 ? 2 : (len <= 6 ? 6 : 8);
                        int w = (int)((double)len / totLen * 100.0);
                        words[i].m_weight = (byte)w;
                        total += w;
                        continue;
                    }
                    words[i].m_weight = 0;
                    continue;
                }
                words[i].m_weight = 0;
            }
            if (total < 100) {
                int remaining = 100 - total;
                while (remaining > 0) {
                    int len;
                    int i;
                    for (i = 0; i < wordCount && remaining > 0; ++i) {
                        int n4 = len = words[i].getCodedWord().getChars() == null ? 0 : words[i].getCodedWord().getChars().length;
                        if (len <= 8) continue;
                        words[i].m_weight = (byte)(words[i].m_weight + 1);
                        --remaining;
                    }
                    i = 0;
                    while (i < wordCount & remaining > 0) {
                        int n5 = len = words[i].getCodedWord().getChars() == null ? 0 : words[i].getCodedWord().getChars().length;
                        if (len >= 6 && len <= 8) {
                            words[i].m_weight = (byte)(words[i].m_weight + 1);
                            --remaining;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < wordCount & remaining > 0) {
                        int n6 = len = words[i].getCodedWord().getChars() == null ? 0 : words[i].getCodedWord().getChars().length;
                        if (len >= 2 && len <= 6) {
                            words[i].m_weight = (byte)(words[i].m_weight + 1);
                            --remaining;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < wordCount & remaining > 0) {
                        int n7 = len = words[i].getCodedWord().getChars() == null ? 0 : words[i].getCodedWord().getChars().length;
                        if (len < 2) {
                            words[i].m_weight = (byte)(words[i].m_weight + 1);
                            --remaining;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    protected final double scoreWords(char[] chars1, char[] chars2) {
        return this.scoreWords(chars1, chars2, false);
    }

    protected final double scoreWords(char[] chars1, char[] chars2, boolean ignoreChecks) {
        if (!ignoreChecks) {
            if (chars1 == null && chars2 == null) {
                return 1.0;
            }
            if (chars1 == null || chars2 == null) {
                return 0.0;
            }
        }
        return this.scoreKeys(chars1, chars2);
    }

    private static int getFirstMissingChar(char[] chars1, char[] chars2, int size1, int size2) {
        if (size1 <= size2) {
            int j;
            int i = 0;
            for (j = 0; i < size1 && j < size2; ++i, ++j) {
                if (j >= size2 || chars1[i] == chars2[j]) continue;
                return j;
            }
            if ((i > size1 || i == size1 && j <= size2) && j < size2) {
                return j;
            }
        }
        return -1;
    }

    private static int getLastMissingChar(char[] chars1, char[] chars2, int size1, int size2) {
        int lastMissing = -1;
        if (size1 <= size2) {
            int j;
            int i = 0;
            for (j = 0; i < size1 && j < size2; ++i, ++j) {
                while (j < size2 && chars1[i] != chars2[j]) {
                    lastMissing = j++;
                }
            }
            if (i > size1 || i == size1 && j <= size2) {
                while (j < size2) {
                    lastMissing = j++;
                }
            }
        }
        return lastMissing;
    }

    private static final int getMissingCharCount(char[] chars1, char[] chars2, int size1, int size2) {
        int missing = 0;
        if (size1 <= size2) {
            int j;
            int i = 0;
            for (j = 0; i < size1 && j < size2; ++i, ++j) {
                while (j < size2 && chars1[i] != chars2[j]) {
                    ++j;
                    ++missing;
                }
            }
            if (i > size1 || i == size1 && j <= size2) {
                while (j < size2) {
                    ++missing;
                    ++j;
                }
            }
        }
        return missing;
    }

    @Override
    public boolean keyEquals(char[] key1, char[] key2) {
        return Arrays.equals(key1, key2);
    }

    @Override
    public double scoreKeys(char[] key1, char[] key2) {
        return CGGEScorer.privateScoreKeys(key1, key2);
    }

    private static final double privateScoreKeys(char[] key1, char[] key2) {
        int size1 = key1.length;
        int size2 = key2.length;
        int max = 0;
        int min = 0;
        if (size1 > size2) {
            min = key2.length;
            max = key1.length;
        } else {
            min = key1.length;
            max = key2.length;
        }
        if (min != max) {
            boolean b;
            int missingCharCount = size1 < size2 ? CGGEScorer.getMissingCharCount(key1, key2, size1, size2) : CGGEScorer.getMissingCharCount(key2, key1, size2, size1);
            boolean bl = b = missingCharCount <= max >> 1;
            if (!b) {
                boolean bl2 = b = size1 < size2 ? CGGEScorer.isProbableAbbreviationCase(key2, key1, size2, size1) : CGGEScorer.isProbableAbbreviationCase(key1, key2, size1, size2);
            }
            if (b) {
                int lastMissing;
                double score = 0.5;
                score += 0.3 * ((1.0 - (double)missingCharCount / (double)max) * 0.8 + (double)min / (double)max * 0.2);
                int firstMissing = size1 < size2 ? CGGEScorer.getFirstMissingChar(key1, key2, size1, size2) : CGGEScorer.getFirstMissingChar(key2, key1, size2, size1);
                int n = lastMissing = size1 < size2 ? CGGEScorer.getLastMissingChar(key1, key2, size1, size2) : CGGEScorer.getFirstMissingChar(key2, key1, size2, size1);
                if (lastMissing - firstMissing + 1 == missingCharCount) {
                    score += 0.15;
                    if (min > 1 && lastMissing == max - 1) {
                        score += 0.05;
                    }
                } else if (max - missingCharCount >= missingCharCount) {
                    score += 0.1;
                }
                return score;
            }
        }
        if (min == max) {
            if (Arrays.equals(key1, key2)) {
                return 1.0;
            }
            char[] key1Temp = CharArray.clone(key1);
            char[] key2Temp = CharArray.clone(key2);
            Arrays.sort(key1Temp);
            Arrays.sort(key2Temp);
            if (Arrays.equals(key1Temp, key2Temp)) {
                int nTransposed = 0;
                for (int i = 0; i < key1.length; ++i) {
                    if (key1[i] == key2[i]) continue;
                    ++nTransposed;
                }
                double score = 1.0;
                if ((double)nTransposed > (double)key1.length / 2.0) {
                    score = 0.85;
                }
                for (int i = 0; i < nTransposed / 2; ++i) {
                    score -= 0.03;
                }
                return score;
            }
            double charWeight = 1.0 / (double)max * 0.5;
            double weightToReduce = 0.0;
            int charactersDiff = 0;
            for (int i = 0; i < max; ++i) {
                char k1 = key1[i];
                char k2 = key2[i];
                if (k1 == k2) continue;
                weightToReduce += charWeight;
                ++charactersDiff;
            }
            if (charactersDiff <= max / 2) {
                return 1.0 - weightToReduce;
            }
        }
        int distance = CGGEScorer.LDScore(key1, key2);
        double score = (1.0 - (double)distance / (double)max) * 0.8 + (double)min / (double)max * 0.2;
        return score;
    }

    @Override
    public double scoreNumber(int num1, int num2) {
        return CGGEScorer.privateScoreNumber(num1, num2);
    }

    private static final double privateScoreNumber(int num1, int num2) {
        int delta = Math.abs(num1 - num2);
        if (delta < 100) {
            double score = 0.5 + 0.5 * ((double)(100 - delta) / 100.0);
            return score;
        }
        char[] digits1 = MMUtils.getDigits(num1);
        char[] digits2 = MMUtils.getDigits(num2);
        double score = 0.0;
        if (digits1 != null && digits2 != null) {
            score = 0.7 * CGGEScorer.privateScoreKeys(digits1, digits2);
            int s1 = digits1.length;
            int s2 = digits2.length;
            int m = Math.max(s1, s2);
            double t = 0.25;
            for (int i = 0; i < m; ++i) {
                double d;
                if (i < m - 1) {
                    t /= 2.0;
                }
                if ((d = (double)Math.abs((i < s1 ? digits1[i] : 48) - (i < s2 ? digits2[i] : 48))) > 0.0) {
                    score += t * ((10.0 - d) / 10.0);
                    continue;
                }
                score += t;
            }
        }
        return score;
    }

    private static final int LDScore(char[] chs1, char[] chs2) {
        int i;
        int n = chs1.length;
        int m = chs2.length;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = chs2[j - 1];
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = chs1[i - 1] == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        this.m_soundex = null;
        return true;
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    protected static class WordScore {
        double m_score = 0.0;
        boolean m_matchedWithAlt = false;

        WordScore() {
        }
    }

    protected static class FieldScoreEx
    extends FieldScore {
        double m_highestIndividualWordScore = 0.0;

        protected FieldScoreEx() {
        }
    }
}

