/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.scorer;

import com.mapinfo.mapmarker.cgge.address.AddressWord;

public class ScorerUtilities {
    static void redistributeWeight(AddressWord originalWord, AddressWord[] replacementWords) {
        int remaining = originalWord.m_weight;
        if (remaining != 0) {
            int totalSoundexWords = 0;
            int lastSoundexWord = -1;
            for (int j = 0; j < replacementWords.length; ++j) {
                if (replacementWords[j].getSoundex() == 0) continue;
                ++totalSoundexWords;
                lastSoundexWord = j;
            }
            if (totalSoundexWords > 0) {
                int perWordWeight = totalSoundexWords < remaining ? remaining / totalSoundexWords : remaining;
                for (int j = 0; j < replacementWords.length && remaining > 0; ++j) {
                    if (replacementWords[j].getSoundex() == 0) continue;
                    replacementWords[j].m_weight = (byte)perWordWeight;
                    remaining -= perWordWeight;
                }
                if (remaining > 0) {
                    replacementWords[lastSoundexWord].m_weight = (byte)(replacementWords[lastSoundexWord].m_weight + remaining);
                }
            }
        }
    }
}

