/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.soundex;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.soundex.CGGESoundexPropertiesLoader;
import com.mapinfo.mapmarker.cgge.soundex.CGGESoundexPropertiesLoaderFactory;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.soundex.ISettableCGGESoundex;
import com.mapinfo.mapmarker.cgge.soundex.KeyedPattern;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CGGESoundex
extends DatasetInfoComponent
implements ICGGESoundex,
ISettableCGGESoundex {
    private int m_maxSoundexLen;
    private Map<Character, Byte> m_soundexMap;
    private char[] m_soundexFilterChars;
    private LocalReplacementPair[] m_soundexReplacements;
    private LocalReplacementPair[] m_charReplacements;
    private String m_country;
    private String m_language;
    private Set<Byte> m_uniqueSounds;
    private short m_numeralSoundexLen = (short)3;

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    @Override
    public int getSoundex(String word) {
        if (word != null) {
            if (MMUtils.isNumber(word)) {
                try {
                    long n = Long.parseLong(word);
                    return (int)MMUtils.trimDigits(n, this.m_numeralSoundexLen);
                }
                catch (NumberFormatException n) {}
            } else {
                byte[] soundexBytes = this.getSoundexCodeAsByteArray(word, false);
                int sdx = 0;
                if (soundexBytes != null && soundexBytes.length > 0) {
                    sdx = soundexBytes[0];
                    for (int i = 1; i < soundexBytes.length; ++i) {
                        sdx = sdx * 10 + soundexBytes[i];
                    }
                }
                return sdx;
            }
        }
        return 0;
    }

    private char[] normalizeCharsForSoundex(String str) {
        char[] chars = this.normalizeChars(str);
        if (chars == null) {
            return null;
        }
        chars = this.applyLocalReplacementPairs(chars, this.m_soundexReplacements);
        chars = this.toUpperCase(chars);
        if (this.m_soundexFilterChars != null) {
            int len = chars.length;
            int keptCount = 0;
            for (int i = 0; i < len; ++i) {
                char c = chars[i];
                if (CharArray.indexOf(this.m_soundexFilterChars, c) <= -1) continue;
                chars[keptCount] = c;
                ++keptCount;
            }
            if (keptCount < len) {
                char[] filteredChars = new char[keptCount];
                CharArray.arraycopy(chars, 0, filteredChars, 0, keptCount);
                chars = filteredChars;
            }
        }
        return chars;
    }

    private final int getSound(char ch) {
        Byte b;
        if (this.m_soundexMap != null && (b = this.m_soundexMap.get(Character.valueOf(ch))) != null) {
            return b.byteValue();
        }
        return -1;
    }

    @Override
    public char[] normalizeChars(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return null;
        }
        char[] normalizedString = str.toCharArray();
        char[] normalizedChars = this.applyLocalReplacementPairs(normalizedString, this.m_charReplacements);
        normalizedChars = this.toUpperCase(normalizedChars);
        return normalizedChars;
    }

    private char[] applyLocalReplacementPairs(char[] chars, LocalReplacementPair[] kps) {
        if (kps != null && kps.length > 0) {
            int len = chars.length;
            int ndx = 0;
            LocalReplacementPair lastKp = null;
            while (ndx < len) {
                LocalReplacementPair kp = this.search(chars, kps, ndx);
                if (kp != null && (lastKp == null || kp.order > lastKp.order)) {
                    chars = this.replace(chars, kp.replacementChars, ndx, kp.toBeReplacedChars.length);
                    len = chars.length;
                    lastKp = kp;
                    continue;
                }
                lastKp = null;
                ++ndx;
            }
        }
        return chars;
    }

    private LocalReplacementPair search(char[] chars, LocalReplacementPair[] kps, int startNdx) {
        int charLen = chars.length;
        int kpsl = kps.length;
        char searchCh = chars[startNdx];
        int low = 0;
        int high = kpsl - 1;
        int kpNdx = -1;
        while (low <= high) {
            int mid = low + high >> 1;
            char midCh = kps[mid].toBeReplacedChars[0];
            int cmp = midCh - searchCh;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            kpNdx = mid;
            while (--mid >= 0 && kps[mid].toBeReplacedChars[0] == searchCh) {
                kpNdx = mid;
            }
            break block0;
        }
        if (kpNdx > -1) {
            while (kpNdx < kpsl) {
                int checked;
                LocalReplacementPair kp = kps[kpNdx];
                char[] searchChars = kp.toBeReplacedChars;
                if (searchChars[0] != chars[startNdx]) break;
                int checkNdx = startNdx + 1;
                for (checked = 1; checked < searchChars.length && checkNdx < charLen && chars[checkNdx] == searchChars[checked]; ++checked, ++checkNdx) {
                }
                if (checked == searchChars.length) {
                    return kp;
                }
                ++kpNdx;
            }
        }
        return null;
    }

    private char[] replace(char[] chars, char[] charsReplace, int offset, int n) {
        int newSize = 0;
        newSize = charsReplace.length == 0 ? chars.length - n : (n > charsReplace.length ? chars.length - (n - charsReplace.length) : chars.length + (charsReplace.length - n));
        char[] charsToRet = new char[newSize];
        if (offset > 0) {
            CharArray.arraycopy(chars, 0, charsToRet, 0, offset);
        }
        if (charsReplace.length == 0) {
            CharArray.arraycopy(chars, offset + n, charsToRet, offset, chars.length - (offset + n));
        } else {
            CharArray.arraycopy(charsReplace, 0, charsToRet, offset, charsReplace.length);
            CharArray.arraycopy(chars, offset + n, charsToRet, offset + charsReplace.length, chars.length - (offset + n));
        }
        return charsToRet;
    }

    private final byte[] getSoundexCodeAsByteArray(String str, boolean includeZeroSound) {
        if (str == null) {
            return null;
        }
        char[] chars = this.normalizeCharsForSoundex(str);
        if (chars == null || chars.length == 0) {
            return null;
        }
        byte[] soundexChars = new byte[this.m_maxSoundexLen];
        soundexChars[0] = (byte)chars[0];
        byte lastSound = (byte)this.getSound(chars[0]);
        int added = 1;
        for (int i = 1; i < chars.length; ++i) {
            byte sound = (byte)this.getSound(chars[i]);
            if (sound > -1 && (sound > 0 || includeZeroSound)) {
                if (lastSound != sound) {
                    soundexChars[added++] = sound;
                }
                if (added == this.m_maxSoundexLen) break;
            }
            lastSound = sound;
        }
        byte[] newSoundexChars = new byte[added];
        System.arraycopy(soundexChars, 0, newSoundexChars, 0, added);
        return newSoundexChars;
    }

    public final boolean isSameSoundexCode(char ch1, char ch2) {
        return this.getSound(ch1) == this.getSound(ch2);
    }

    @Override
    public final int[] getAlternateSoundexes(String str, int altMask) {
        int m;
        byte[] newSoundexChars;
        int i;
        int soundexCharsSize;
        byte[] soundexChars = this.getSoundexCodeAsByteArray(str, false);
        int n = soundexCharsSize = soundexChars == null ? 0 : soundexChars.length;
        if (soundexCharsSize < 2) {
            return null;
        }
        int[] altCodes = new int[100];
        int added = 0;
        StringBuffer buf = new StringBuffer(10);
        if ((altMask & 4) == 4) {
            if (soundexCharsSize == this.m_maxSoundexLen) {
                soundexCharsSize = this.m_maxSoundexLen - 1;
            }
            for (i = 1; i < soundexCharsSize + 1; ++i) {
                newSoundexChars = new byte[soundexCharsSize + 1];
                System.arraycopy(soundexChars, 0, newSoundexChars, 0, i);
                System.arraycopy(soundexChars, i, newSoundexChars, i + 1, soundexCharsSize - i);
                for (Byte newSound : this.m_uniqueSounds) {
                    if (newSound == 0) continue;
                    newSoundexChars[i] = newSound;
                    buf.delete(0, buf.length());
                    for (m = 0; m < newSoundexChars.length; ++m) {
                        buf.append(newSoundexChars[m]);
                    }
                    altCodes[added++] = Integer.parseInt(buf.toString());
                }
            }
        }
        if ((altMask & 2) == 2) {
            for (i = 1; i < soundexCharsSize; ++i) {
                newSoundexChars = new byte[soundexCharsSize - 1];
                System.arraycopy(soundexChars, 0, newSoundexChars, 0, i);
                if (i < soundexCharsSize - 1) {
                    System.arraycopy(soundexChars, i + 1, newSoundexChars, i, soundexCharsSize - (i + 1));
                }
                buf.delete(0, buf.length());
                for (int m2 = 0; m2 < newSoundexChars.length; ++m2) {
                    buf.append(newSoundexChars[m2]);
                }
                altCodes[added++] = Integer.parseInt(buf.toString());
            }
        }
        if ((altMask & 8) == 8) {
            for (i = 1; i < soundexCharsSize - 1; ++i) {
                newSoundexChars = new byte[soundexCharsSize];
                System.arraycopy(soundexChars, 0, newSoundexChars, 0, soundexCharsSize);
                byte ithChar = soundexChars[i];
                newSoundexChars[i] = newSoundexChars[i + 1];
                newSoundexChars[i + 1] = ithChar;
                buf.delete(0, buf.length());
                for (int m3 = 0; m3 < newSoundexChars.length; ++m3) {
                    buf.append(newSoundexChars[m3]);
                }
                altCodes[added++] = Integer.parseInt(buf.toString());
            }
        }
        if ((altMask & 0x10) == 16) {
            soundexChars = this.getSoundexCodeAsByteArray(str, true);
            soundexCharsSize = soundexChars == null ? 0 : soundexChars.length;
            for (i = 1; i < soundexCharsSize; ++i) {
                for (Byte newSound : this.m_uniqueSounds) {
                    if (newSound <= 0) continue;
                    byte[] newSoundexChars2 = new byte[soundexCharsSize];
                    System.arraycopy(soundexChars, 0, newSoundexChars2, 0, soundexCharsSize);
                    if (newSound == 0 || i > 1 && newSound == newSoundexChars2[i - 1] || i < soundexCharsSize - 1 && newSound == newSoundexChars2[i + 1] || newSoundexChars2[i] == newSound) continue;
                    newSoundexChars2[i] = newSound;
                    buf.delete(0, buf.length());
                    for (m = 0; m < newSoundexChars2.length; ++m) {
                        if (newSoundexChars2[m] <= 0) continue;
                        buf.append(newSoundexChars2[m]);
                    }
                    altCodes[added++] = Integer.parseInt(buf.toString());
                }
            }
        }
        if (added > 0) {
            int[] newCodes = new int[added];
            IntArray.arraycopy(altCodes, 0, newCodes, 0, added);
            return IntArray.removeDuplicates(newCodes);
        }
        return null;
    }

    @Override
    public boolean startsWithSoundex(int soundex1, int soundex2) {
        return MMUtils.startsWith(soundex1, soundex2);
    }

    @Override
    public final int addSoundex(int soundex1, int soundex2) {
        int newSoundex = soundex1;
        int sndx1Len = MMUtils.getNumberOfDigits(soundex1);
        byte lastSound = 0;
        if (sndx1Len > 2) {
            lastSound = (byte)(soundex1 % 10);
        } else if (sndx1Len == 2) {
            lastSound = this.getSoundOfFirstCharacter(soundex1);
        }
        int sndx2Len = MMUtils.getNumberOfDigits(soundex2);
        if (sndx2Len >= 2) {
            byte sound = this.getSoundOfFirstCharacter(soundex2);
            if (sound > 0 && sound != lastSound) {
                newSoundex *= 10;
                newSoundex += sound;
                lastSound = sound;
            }
            char[] digits = MMUtils.getDigits(soundex2);
            for (int i = 2; i < sndx2Len; ++i) {
                sound = (byte)(digits[i] - 48);
                if (sound <= 0 || lastSound == sound) continue;
                newSoundex *= 10;
                newSoundex += sound;
                lastSound = sound;
            }
        } else {
            newSoundex *= 10;
            newSoundex += soundex2;
        }
        return newSoundex;
    }

    private final byte getSoundOfFirstCharacter(int soundex) {
        int sndxLen = MMUtils.getNumberOfDigits(soundex);
        if (sndxLen > 2) {
            char firstChar = (char)((double)soundex / Math.pow(10.0, sndxLen - 2));
            return (byte)this.getSound(firstChar);
        }
        if (sndxLen == 2) {
            return (byte)this.getSound((char)soundex);
        }
        return (byte)soundex;
    }

    @Override
    public void setSoundexMap(Map<Character, Byte> soundexMapping) {
        this.m_soundexMap = soundexMapping;
    }

    @Override
    public void setUniqueSounds(Set<Byte> uniqueSounds) {
        this.m_uniqueSounds = uniqueSounds;
    }

    @Override
    public void setMaxSoundexLen(int maxSoundexLen) {
        this.m_maxSoundexLen = maxSoundexLen;
    }

    @Override
    public void setCharReplacements(List<KeyedPattern> charReplacements) {
        ArrayList<LocalReplacementPair> temp = new ArrayList<LocalReplacementPair>();
        Iterator<KeyedPattern> it = charReplacements.iterator();
        while (it.hasNext()) {
            this.createLocalReplacementPairsFromKeyedPattern(temp, it.next());
        }
        Collections.sort(temp);
        this.m_charReplacements = new LocalReplacementPair[temp.size()];
        temp.toArray(this.m_charReplacements);
    }

    @Override
    public void setSoundexReplacements(List<KeyedPattern> soundexReplacements) {
        Iterator<KeyedPattern> it = soundexReplacements.iterator();
        this.m_soundexReplacements = new LocalReplacementPair[soundexReplacements.size()];
        int i = 0;
        while (it.hasNext()) {
            KeyedPattern kp = it.next();
            char[] replacement = kp.getKey().toCharArray();
            char[] toBeReplaced = kp.getRegex().toCharArray();
            if (Arrays.equals(toBeReplaced, replacement)) continue;
            this.m_soundexReplacements[i] = new LocalReplacementPair(replacement, toBeReplaced, i);
            ++i;
        }
        Arrays.sort(this.m_soundexReplacements);
    }

    private void createLocalReplacementPairsFromKeyedPattern(List<LocalReplacementPair> list, KeyedPattern kp) {
        char[] replacement = kp.getKey().toCharArray();
        String replacementTokens = kp.getRegex();
        if (replacementTokens.indexOf(124) > 0) {
            StringTokenizer st = new StringTokenizer(replacementTokens, "|()+");
            while (st.hasMoreTokens()) {
                list.add(new LocalReplacementPair(replacement, st.nextToken().toCharArray(), list.size()));
            }
        } else {
            char[] toBeReplaced = replacementTokens.toCharArray();
            if (Arrays.equals(toBeReplaced, replacement)) {
                return;
            }
            LocalReplacementPair lkp = new LocalReplacementPair(replacement, toBeReplaced, list.size());
            list.add(lkp);
        }
    }

    @Override
    public void setNumeralSoundexLen(short numeralSoundexLen) {
        this.m_numeralSoundexLen = numeralSoundexLen;
    }

    @Override
    public void setSoundexFilterPattern(Pattern soundexFilterPattern) {
        String regex = soundexFilterPattern.toString();
        if (regex != null) {
            regex = regex.replace("[^", "");
            regex = regex.replace("]", "");
            this.m_soundexFilterChars = regex.toCharArray();
        }
    }

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        String baseName = "/com/mapinfo/mapmarker/" + country + "/config/" + country + "_Soundex";
        CGGESoundexPropertiesLoader loader = CGGESoundexPropertiesLoaderFactory.getInstance(baseName, language);
        try {
            loader.init(country, language, this, this.getConfiguration(this.m_country, this.m_language, "_Soundex"));
        }
        catch (CGGEInternalException e1) {
            throw new CGGERuntimeException(e1);
        }
        return true;
    }

    private char[] toUpperCase(char[] chars) {
        int len;
        int n = len = chars == null ? 0 : chars.length;
        if (len > 0) {
            char[] newChars = new char[len];
            for (int i = 0; i < len; ++i) {
                newChars[i] = Character.toUpperCase(chars[i]);
            }
            return newChars;
        }
        return chars;
    }

    public boolean isSupportedCharacter(char ch) {
        return this.getSound(ch) >= 0 || this.getSound(this.normalizeChar(ch)) >= 0;
    }

    private char normalizeChar(char ch) {
        for (LocalReplacementPair pair : this.m_charReplacements) {
            if (pair.toBeReplacedChars.length != 1 || pair.toBeReplacedChars[0] != ch || pair.replacementChars.length != 1) continue;
            return pair.replacementChars[0];
        }
        return ch;
    }

    private class LocalReplacementPair
    implements Comparable<LocalReplacementPair> {
        public char[] toBeReplacedChars;
        public char[] replacementChars;
        int order;

        public LocalReplacementPair(char[] replacement, char[] toReplace, int order) {
            this.toBeReplacedChars = toReplace;
            this.replacementChars = replacement;
            this.order = order;
        }

        @Override
        public int compareTo(LocalReplacementPair o) {
            int len2;
            int comp = 0;
            int len1 = this.toBeReplacedChars != null ? this.toBeReplacedChars.length : 0;
            int n = len2 = o.toBeReplacedChars != null ? o.toBeReplacedChars.length : 0;
            if (len1 > 0 && len2 > 0) {
                comp = this.toBeReplacedChars[0] - o.toBeReplacedChars[0];
                if (comp == 0) {
                    comp = this.order - o.order;
                }
            } else {
                comp = len1 - len2;
            }
            return comp;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\"");
            sb.append(this.toBeReplacedChars);
            sb.append("\"-->\"");
            sb.append(this.replacementChars);
            sb.append("\"");
            return sb.toString();
        }
    }
}

