/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.soundex;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundexLoader;
import com.mapinfo.mapmarker.cgge.soundex.ISettableCGGESoundex;
import com.mapinfo.mapmarker.cgge.soundex.KeyedPattern;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

class CGGESoundexPropertiesLoader
implements ICGGESoundexLoader {
    public static final String KEY_SOUNDEX_CHARS = "soundex_chars";
    public static final String KEY_SOUNDEX_VALUES = "soundex_values";
    public static final String KEY_SOUNDEX_REPLACE = "soundex_replace_";
    public static final String KEY_SOUNDEX_IGNORE_CHARS = "soundex_ignore_chars";
    public static final String KEY_SOUNDEX_MAX_LENGTH = "soundex_max_length";
    public static final String KEY_CHARS_REPLACE = "chars_replace";
    public static final String KEY_NUMERAL_SOUNDEX_LENGTH = "soundex_numeral_length";
    public static final String KEY_UPDATED_PROPERTY_BEHAVIOR = "updated_property_behavior";
    private int DEFAULT_SOUNDEX_LEN = 8;
    private String m_propertiesFileName;

    public CGGESoundexPropertiesLoader(String fileName) {
        this.m_propertiesFileName = fileName;
    }

    @Override
    public void init(String country, String language, ISettableCGGESoundex mySoundex, Properties prop) throws CGGEInternalException {
        String str;
        String soundexChars = prop.getProperty(KEY_SOUNDEX_CHARS);
        String soundexValues = prop.getProperty(KEY_SOUNDEX_VALUES);
        if (soundexChars != null && soundexValues != null) {
            StringTokenizer stChars = new StringTokenizer(soundexChars, " ,");
            StringTokenizer stValues = new StringTokenizer(soundexValues, " ,");
            if (stChars.countTokens() != stValues.countTokens()) {
                throw new CGGEInternalException("Soundex characters and sounds do not contain same number of items");
            }
            HashMap<Character, Byte> soundexMap = new HashMap<Character, Byte>();
            HashSet<Byte> uniqueSounds = new HashSet<Byte>();
            while (stChars.hasMoreTokens()) {
                Byte value = Byte.valueOf(stValues.nextToken());
                uniqueSounds.add(value);
                soundexMap.put(Character.valueOf(stChars.nextToken().charAt(0)), value);
            }
            mySoundex.setSoundexMap(Collections.unmodifiableMap(soundexMap));
            mySoundex.setUniqueSounds(Collections.unmodifiableSet(uniqueSounds));
            StringBuilder keys = new StringBuilder(soundexMap.size() + 3);
            keys.append("[^");
            for (Character c : soundexMap.keySet()) {
                keys.append(c);
            }
            keys.append("]");
            mySoundex.setSoundexFilterPattern(Pattern.compile(keys.toString()));
        }
        if (StringUtilities.isEmpty((String)(str = prop.getProperty(KEY_SOUNDEX_MAX_LENGTH)))) {
            mySoundex.setMaxSoundexLen(this.DEFAULT_SOUNDEX_LEN);
        } else {
            try {
                mySoundex.setMaxSoundexLen(Integer.parseInt(str));
            }
            catch (NumberFormatException ne) {
                mySoundex.setMaxSoundexLen(this.DEFAULT_SOUNDEX_LEN);
            }
        }
        mySoundex.setNumeralSoundexLen(PropertiesUtil.getShortPropertyValue(prop, KEY_NUMERAL_SOUNDEX_LENGTH, (short)3));
        List<KeyedPattern> charReplacements = new ArrayList<KeyedPattern>();
        List<KeyedPattern> soundexReplacements = new ArrayList<KeyedPattern>();
        for (String key : this.sortInitialPropertyKeys(prop)) {
            String value;
            if (key.startsWith(KEY_SOUNDEX_REPLACE)) {
                value = prop.getProperty(key);
                this.addReplaceItem(key, value, soundexReplacements);
                continue;
            }
            if (!key.startsWith(KEY_CHARS_REPLACE)) continue;
            value = prop.getProperty(key);
            this.addReplaceItem(key, value, charReplacements);
        }
        charReplacements = this.sortFinalPropertyList(charReplacements);
        soundexReplacements = this.sortFinalPropertyList(soundexReplacements);
        mySoundex.setCharReplacements(Collections.unmodifiableList(charReplacements));
        mySoundex.setSoundexReplacements(Collections.unmodifiableList(soundexReplacements));
    }

    protected void addReplaceItem(String key, String value, List<KeyedPattern> items) {
        StringTokenizer st = new StringTokenizer(value, ",");
        int tokenCount = st.countTokens();
        if (value.startsWith(",")) {
            Pattern pattern = this.buildPattern(st);
            items.add(new KeyedPattern("", pattern));
        } else if (tokenCount > 1) {
            String replaceToString = st.nextToken();
            Pattern pattern = this.buildPattern(st);
            items.add(new KeyedPattern(replaceToString, pattern));
        }
    }

    protected Pattern buildPattern(StringTokenizer regexTokens) {
        boolean bMultiTokens;
        StringBuilder sb = new StringBuilder();
        int maxTokenLen = 0;
        boolean bl = bMultiTokens = regexTokens.countTokens() > 1;
        while (regexTokens.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            String tok = regexTokens.nextToken().trim();
            if (bMultiTokens) {
                maxTokenLen = Math.max(maxTokenLen, tok.length());
            }
            sb.append(tok);
        }
        if (maxTokenLen > 1) {
            sb.insert(0, "(");
            sb.append(")+");
        }
        return Pattern.compile(sb.toString());
    }

    protected List<String> sortInitialPropertyKeys(Properties props) {
        if (props == null) {
            return null;
        }
        Set<Object> keySet = props.keySet();
        Object[] tempKeys = new String[keySet.size()];
        keySet.toArray(tempKeys);
        Arrays.sort(tempKeys);
        return Arrays.asList(tempKeys);
    }

    protected List<KeyedPattern> sortFinalPropertyList(List<KeyedPattern> list) {
        return list;
    }
}

