/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import com.mapinfo.mapmarker.cgge.utils.BitArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BloomFilter {
    private BitArray m_bloomBits;
    private int m_size;
    private int m_sizePerHash;
    private IBloomHash[] m_hashes;

    public BloomFilter(int m) {
        if (m < 0) {
            throw new NegativeArraySizeException("Size must be greater than 0 or equal to zero. Specified size is " + m);
        }
        this.m_size = m;
        this.m_bloomBits = new BitArray(this.m_size);
        this.m_hashes = new IBloomHash[]{new JenkinsHash(), new FastHash(), new FNVHash()};
        this.m_sizePerHash = this.m_size > this.m_hashes.length ? this.m_size / this.m_hashes.length : this.m_size;
    }

    public void addKey(long key) {
        int hashNdx = 0;
        for (IBloomHash hash : this.m_hashes) {
            long h = hash.getHash(key);
            int n = this.getIndex(h, hashNdx++);
            this.m_bloomBits.setBit(n);
        }
    }

    private int getIndex(long hashkey, int hashNdx) {
        int max = this.m_sizePerHash;
        if (hashNdx + 1 == this.m_hashes.length && this.m_sizePerHash < this.m_size) {
            max += this.m_size % this.m_sizePerHash;
        }
        int n = (int)(Math.abs(hashkey) % (long)max);
        return hashNdx * this.m_sizePerHash + n;
    }

    public boolean isAvailable(long key) {
        int hashNdx = 0;
        for (IBloomHash hash : this.m_hashes) {
            long h = hash.getHash(key);
            int n = this.getIndex(h, hashNdx++);
            if (this.m_bloomBits.isSet(n)) continue;
            return false;
        }
        return true;
    }

    public int getSize() {
        return this.m_size;
    }

    public void write(DataOutput out) throws IOException {
        this.m_bloomBits.write(out);
    }

    public void read(DataInput in) throws IOException {
        this.m_bloomBits.read(in);
    }

    private class FastHash
    implements IBloomHash {
        private final long PRIME = 31L;

        private FastHash() {
        }

        @Override
        public long getHash(long value) {
            long n1 = (value & 0xFFFFL) * 31L;
            long n2 = (value >> 16) * 31L;
            return n1 ^ n2;
        }
    }

    private static class JenkinsHash
    implements IBloomHash {
        private JenkinsHash() {
        }

        @Override
        public long getHash(long value) {
            long hash = 0L;
            int i = 0;
            int shift = 0;
            while (i < 4) {
                int key = (int)(value >>> shift & 0xFFL);
                hash += (long)key;
                hash += hash << 10;
                hash ^= hash >>> 6;
                ++i;
                shift += 8;
            }
            hash += hash << 3;
            hash ^= hash >>> 11;
            hash += hash << 15;
            return hash >>> 32 ^ hash & 0xFFFFFFL;
        }
    }

    private static class FNVHash
    implements IBloomHash {
        private final int FNV_PRIME = 16777619;
        private final long FNV_BASE = 2166136261L;

        private FNVHash() {
        }

        @Override
        public long getHash(long value) {
            long hash = 2166136261L;
            int i = 0;
            int shift = 0;
            while (i < 4) {
                hash ^= value >>> shift & 0xFFL;
                hash *= 16777619L;
                ++i;
                shift += 8;
            }
            return hash >>> 32 ^ hash & 0xFFFFFFL;
        }
    }

    private static interface IBloomHash {
        public long getHash(long var1);
    }
}

