/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.convertor.ICGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.List;

public class CandidateS3Determinator {
    private CandidateS3Determinator() {
    }

    public static int getPointCount(IDataManager dataManager, InternalRangeAddress internalRangeAddress) throws DataFetchException {
        List<DirectPosition> geom;
        if (!internalRangeAddress.arePointsAssigned()) {
            internalRangeAddress.setPoints(dataManager.getGeometry(internalRangeAddress));
        }
        if ((geom = internalRangeAddress.getPoints()) != null) {
            return geom.size();
        }
        return 0;
    }

    public static boolean isS3(IDataManager dm, InternalScoringAddress scoringAddress) throws DataFetchException {
        if (scoringAddress.getS3CheckedStatus()) {
            return scoringAddress.isS3();
        }
        scoringAddress.setS3CheckedStatus(true);
        if (scoringAddress.getDataSetInfo().getGeocodeType() != 1) {
            return false;
        }
        if (scoringAddress.getRangeCount() == 0) {
            return true;
        }
        InternalScoringRange internalScoringRange = scoringAddress.getRangeAt(0);
        AddressNumberScore score = (AddressNumberScore)internalScoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        int points = CandidateS3Determinator.getPointCount(dm, internalScoringRange.getRange());
        if (points == 0) {
            return true;
        }
        if (points > 1) {
            return false;
        }
        if (CandidateS3Determinator.goodSingleRangeS8(scoringAddress, points)) {
            scoringAddress.setIsS8(true);
            return false;
        }
        if (score == null || score.getInputAddressNumber() == null) {
            InternalScoringRange matchedRange = scoringAddress.getMatchedRange();
            if (matchedRange != null) {
                scoringAddress.setIsS8(true);
            }
            return matchedRange == null;
        }
        if (scoringAddress.getMatchedRange() != null) {
            scoringAddress.setIsS8(true);
            return false;
        }
        boolean hasMatchedAddressNumber = false;
        if (scoringAddress.getRangeCount() > 0) {
            CGGEHandler handler = CGGEHandler.getInstance(scoringAddress.getDataSetInfo(), scoringAddress.getCountry(), scoringAddress.getLanguage());
            ICGGECandidateConvertor convertor = handler.getCandidateConvertor();
            boolean bl = hasMatchedAddressNumber = convertor.getMatchedAddressNumberS3(internalScoringRange, score.getInputAddressNumber(), score) != null;
        }
        if (!hasMatchedAddressNumber) {
            return true;
        }
        return CandidateS3Determinator.isS3WithAdjustedHouse(score, scoringAddress);
    }

    protected static boolean isS3WithAdjustedHouse(AddressNumberScore score, InternalScoringAddress scoringAddress) {
        boolean exceedsAcceptableHnrOffset;
        boolean bl = exceedsAcceptableHnrOffset = score.getOffset() > score.getMaxAddressNumberOffset();
        if (exceedsAcceptableHnrOffset && CandidateS3Determinator.hasMatchingStreetField(scoringAddress)) {
            int[] hn_index = score.getInputAddressNumber().getPositionInInputStreet();
            int firstStreetWordpos = scoringAddress.getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_matchedInputWords.getFirst();
            if (hn_index != null && hn_index.length > 0 && hn_index[0] + 1 != firstStreetWordpos) {
                exceedsAcceptableHnrOffset = false;
            }
        }
        if (!exceedsAcceptableHnrOffset) {
            scoringAddress.setIsS8(true);
        }
        return exceedsAcceptableHnrOffset;
    }

    private static boolean hasMatchingStreetField(InternalScoringAddress scoringAddress) {
        FieldScore score = scoringAddress.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        return score != null && IntArray.size(score.m_matchedInputWords) > 0;
    }

    private static boolean goodSingleRangeS8(InternalScoringAddress scorAddr, int numPts) {
        if (numPts == 1 && scorAddr.getRangeCount() == 1) {
            boolean hasNoPC;
            boolean hasPCwithGoodScore = scorAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE) != null && scorAddr.getFieldScore((FieldType)FieldType.POST_CODE_FIELD_TYPE).m_value >= 0.9;
            boolean bl = hasNoPC = scorAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE) == null && (scorAddr.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE) != null || scorAddr.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE) != null);
            if (hasPCwithGoodScore || hasNoPC) {
                return true;
            }
        }
        return false;
    }
}

