/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import java.util.Arrays;

public final class CharArray
implements CharSequence {
    private int m_initialCapacity;
    private int m_size;
    private int m_capacity;
    private char[] m_buf;
    private static int CALL_NATIVE_LIMIT = 13;

    public CharArray() {
        this.m_capacity = this.m_initialCapacity = 10;
        this.m_size = 0;
    }

    public CharArray(int initialCapacity) {
        this.m_initialCapacity = initialCapacity;
        this.m_capacity = initialCapacity;
        this.m_size = 0;
    }

    public CharArray(char[] array) {
        if (array != null) {
            this.m_initialCapacity = this.m_capacity = (this.m_size = array.length);
            this.m_buf = new char[this.m_capacity];
            for (int i = 0; i < this.m_size; ++i) {
                this.m_buf[i] = array[i];
            }
        } else {
            this.m_capacity = 10;
            this.m_size = 0;
        }
    }

    public static final void arraycopy(char[] src, int srcPos, char[] dest, int destPos, int length) {
        if (length < CALL_NATIVE_LIMIT && src != dest) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos + i];
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static final char[] clone(char[] src) {
        int l = src.length;
        if (l < CALL_NATIVE_LIMIT) {
            char[] srcCopy = new char[l];
            while (--l >= 0) {
                srcCopy[l] = src[l];
            }
            return srcCopy;
        }
        return (char[])src.clone();
    }

    private void ensureCapacity(int extras) {
        int sizeNeeded = this.m_size + extras;
        if (sizeNeeded > this.m_capacity) {
            int incrementSize = this.m_initialCapacity;
            this.m_capacity += incrementSize;
            if (sizeNeeded > this.m_capacity) {
                this.m_capacity = sizeNeeded;
            }
            char[] newBuf = new char[this.m_capacity];
            if (this.m_size > 0) {
                CharArray.arraycopy(this.m_buf, 0, newBuf, 0, this.m_size);
            }
            this.m_buf = newBuf;
        } else if (this.m_buf == null) {
            this.m_buf = new char[this.m_capacity];
        }
    }

    public final void add(char[] array) {
        if (array != null && array.length > 0) {
            this.ensureCapacity(array.length);
            CharArray.arraycopy(array, 0, this.m_buf, this.m_size, array.length);
            this.m_size += array.length;
        }
    }

    public final void add(char value) {
        this.ensureCapacity(1);
        this.m_buf[this.m_size] = value;
        ++this.m_size;
    }

    private final void rangeCheck(int ndx) {
        if (ndx < 0 || ndx >= this.m_size) {
            throw new IndexOutOfBoundsException("Size=" + this.m_size + " attempted=" + ndx);
        }
    }

    public char[] getInternalBuffer() {
        return this.m_buf;
    }

    public final char[] asArray() {
        if (this.m_size > 0) {
            if (this.m_capacity > this.m_size) {
                char[] newBuf = new char[this.m_size];
                CharArray.arraycopy(this.m_buf, 0, newBuf, 0, this.m_size);
                return newBuf;
            }
            return CharArray.clone(this.m_buf);
        }
        return null;
    }

    public static final boolean startsWith(char[] chars1, char[] chars2) {
        int len2;
        int len1 = chars1 == null ? 0 : chars1.length;
        int n = len2 = chars2 == null ? 0 : chars2.length;
        if (len2 == len1) {
            return Arrays.equals(chars1, chars2);
        }
        if (len2 > 0 && len2 < len1) {
            for (int charNdx = 0; charNdx < len2; ++charNdx) {
                if (chars1[charNdx] == chars2[charNdx]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int length() {
        return this.m_size;
    }

    @Override
    public char charAt(int index) {
        this.rangeCheck(index);
        return this.m_buf[index];
    }

    @Override
    public String toString() {
        return new String(this.asArray());
    }

    public static int indexOf(char[] charsToSearch, char search) {
        int len = charsToSearch == null ? 0 : charsToSearch.length;
        return CharArray.indexOfUpTo(charsToSearch, search, len);
    }

    public static int indexOfUpTo(char[] charsToSearch, char search, int endPos) {
        int len = charsToSearch.length;
        if (endPos < 1 || endPos > len) {
            endPos = len;
        }
        for (int i = 0; i < endPos; ++i) {
            if (charsToSearch[i] != search) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] charsToSearch, char[] charSearch) {
        return CharArray.indexOf(charsToSearch, charSearch, 0);
    }

    public static int indexOf(char[] charsToSearch, char[] charSearch, int pos) {
        int len2;
        int len1 = charsToSearch == null ? 0 : charsToSearch.length;
        int n = len2 = charSearch == null ? 0 : charSearch.length;
        if (len2 <= len1 && len1 != 0 && len2 != 0) {
            int startIndex = -1;
            while (true) {
                if (pos < len1) {
                    if (charsToSearch[pos] == charSearch[0] && (startIndex = pos) + len2 <= len1) {
                        boolean allCharMatched = true;
                        for (int j = 1; j < len2; ++j) {
                            if (charSearch[j] == charsToSearch[startIndex + j]) continue;
                            allCharMatched = false;
                        }
                        if (allCharMatched) {
                            return startIndex;
                        }
                    }
                    ++pos;
                    continue;
                }
                if (pos >= len1) break;
            }
        }
        return -1;
    }

    public static char[] subArray(char[] chars, int startPos) {
        return CharArray.subArray(chars, startPos, chars.length - startPos);
    }

    public static char[] subArray(char[] chars, int startPos, int len) {
        char[] subChars = null;
        if (startPos < 0 || startPos >= chars.length || len < 0 || startPos + len > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        subChars = new char[len];
        CharArray.arraycopy(chars, startPos, subChars, 0, len);
        return subChars;
    }

    public static char[] splitAtAnyDelim(char[] array, char[] delims, boolean includeDelim) {
        int delimPos = array.length;
        for (char delim : delims) {
            int pos1 = CharArray.indexOfUpTo(array, delim, delimPos);
            if (pos1 <= -1) continue;
            delimPos = pos1;
        }
        if (delimPos < array.length && delimPos > 0) {
            return CharArray.subArray(array, 0, includeDelim ? delimPos + 1 : delimPos);
        }
        return null;
    }

    public static char[] splitAtDelim(char[] array, char delim, boolean includeDelim) {
        int delimPos = CharArray.indexOf(array, delim);
        if (delimPos > 0) {
            return CharArray.subArray(array, 0, includeDelim ? delimPos + 1 : delimPos);
        }
        return null;
    }

    public static char[] splitAtChars(char[] array, char[] subarray, boolean includeSubArray) {
        int delimPos = CharArray.indexOf(array, subarray);
        if (delimPos > 0) {
            return CharArray.subArray(array, 0, includeSubArray ? delimPos + subarray.length : delimPos);
        }
        return null;
    }

    public static char[] splitAtAnyChars(char[] array, char[][] subArrays, boolean includeSubArray) {
        int delimPos = array.length;
        char[] matchedSubArray = null;
        for (char[] subarray : subArrays) {
            int pos = CharArray.indexOf(array, subarray);
            if (pos <= -1 || pos >= delimPos) continue;
            delimPos = pos;
            matchedSubArray = subarray;
        }
        if (matchedSubArray != null && delimPos > 0) {
            return CharArray.subArray(array, 0, includeSubArray ? delimPos + matchedSubArray.length : delimPos);
        }
        return null;
    }

    public static char[] addArrays(char[] ... charArrays) {
        int totalLen = 0;
        for (char[] chars : charArrays) {
            totalLen += chars.length;
        }
        CharArray newChars = new CharArray(totalLen);
        for (char[] chars : charArrays) {
            newChars.add(chars);
        }
        return newChars.getInternalBuffer();
    }

    public static char[] addArrays(char[] array1, char[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        char[] combinedArray = new char[len1 + len2];
        System.arraycopy(array1, 0, combinedArray, 0, len1);
        System.arraycopy(array2, 0, combinedArray, len1, len2);
        return combinedArray;
    }

    public static final boolean endsWith(char[] chars1, char[] chars2) {
        int len2;
        int len1 = chars1 == null ? 0 : chars1.length;
        int n = len2 = chars2 == null ? 0 : chars2.length;
        if (len2 == len1) {
            return Arrays.equals(chars1, chars2);
        }
        if (len2 > 0 && len2 < len1) {
            for (int i = 1; i <= len2; ++i) {
                if (chars1[len1 - i] == chars2[len2 - i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.rangeCheck(start);
        this.rangeCheck(end - 1);
        char[] subChars = CharArray.subArray(this.m_buf, start, end - start);
        return new CharArray(subChars);
    }

    public static int hash(char[] chars) {
        return CharArray.hash(chars, chars.length);
    }

    private static int hash(char[] chars, int len) {
        int hash = 0;
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + chars[i];
        }
        return hash;
    }

    public int hashCode() {
        return CharArray.hash(this.m_buf, this.m_size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CharArray) {
            CharArray other = (CharArray)obj;
            int len2 = other.m_size;
            if (len2 == this.m_size) {
                char[] buf2 = other.m_buf;
                for (int i = 0; i < len2; ++i) {
                    if (this.m_buf[i] == buf2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

