/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class IntArray
implements Iterable<Integer> {
    private int m_size;
    private int m_capacity;
    private int[] m_buf;
    private static int CALL_NATIVE_LIMIT = 13;
    private boolean m_sorted;

    public IntArray() {
        this.m_capacity = 10;
        this.m_size = 0;
        this.m_sorted = false;
    }

    public IntArray(int initialCapacity, int value) {
        this.m_size = this.m_capacity = initialCapacity;
        this.setAll(value);
    }

    public IntArray(int initialCapacity) {
        this.m_capacity = initialCapacity;
        this.m_size = 0;
        this.m_sorted = false;
    }

    public IntArray(List<Integer> list) {
        int listSize;
        this.m_capacity = listSize = list.size();
        this.m_size = listSize;
        this.m_sorted = false;
        if (listSize > 0) {
            this.m_buf = new int[this.m_capacity];
            int added = 0;
            for (int i : list) {
                this.m_buf[added++] = i;
            }
        }
    }

    public static IntArray wrap(int[] array) {
        if (array != null) {
            IntArray newArray = new IntArray(array.length);
            newArray.m_buf = array;
            newArray.m_size = array.length;
            return newArray;
        }
        return null;
    }

    public IntArray(IntArray array) {
        this();
        if (array == null) {
            throw new NullPointerException();
        }
        this.m_size = array.size();
        if (this.m_size > 0) {
            this.ensureCapacity(this.m_size);
            IntArray.arraycopy(array.m_buf, 0, this.m_buf, 0, this.m_size);
            this.m_sorted = array.m_sorted;
        }
    }

    public IntArray(int[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        this.m_capacity = this.m_size = array.length;
        this.ensureCapacity(0);
        IntArray.arraycopy(array, 0, this.m_buf, 0, this.m_size);
        this.m_sorted = false;
    }

    public void sort() {
        if (this.m_size > 0) {
            Arrays.sort(this.m_buf, 0, this.m_size);
        }
        this.m_sorted = true;
    }

    public static final void arraycopy(int[] src, int srcPos, int[] dest, int destPos, int length) {
        if (length < CALL_NATIVE_LIMIT && src != dest) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos + i];
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static final int[] clone(int[] src) {
        int l = src.length;
        if (l < CALL_NATIVE_LIMIT) {
            int[] srcCopy = new int[l];
            while (--l >= 0) {
                srcCopy[l] = src[l];
            }
            return srcCopy;
        }
        return (int[])src.clone();
    }

    public final void insert(int ndx, int value) {
        this.ensureCapacity(1);
        IntArray.arraycopy(this.m_buf, ndx, this.m_buf, ndx + 1, this.m_size - ndx);
        this.m_buf[ndx] = value;
        ++this.m_size;
        this.m_sorted = false;
    }

    private final void ensureCapacity(int extras) {
        if (this.m_buf == null) {
            if (extras > this.m_capacity) {
                this.m_capacity = extras;
            }
            this.m_buf = new int[this.m_capacity];
        } else {
            int sizeNeeded = this.m_size + extras;
            if (sizeNeeded > this.m_capacity || this.m_buf == null) {
                this.m_capacity <<= 1;
                if (sizeNeeded > this.m_capacity) {
                    this.m_capacity = sizeNeeded;
                }
                int[] newBuf = new int[this.m_capacity];
                if (this.m_size > 0 && this.m_buf != null) {
                    IntArray.arraycopy(this.m_buf, 0, newBuf, 0, this.m_size);
                }
                this.m_buf = newBuf;
            }
        }
    }

    public static int[] removeDuplicates(int[] array) {
        if (array == null || array.length < 1) {
            return array;
        }
        IntArray retArray = new IntArray(array.length);
        Arrays.sort(array);
        int lastvalue = array[0];
        retArray.ensureCapacity(0);
        retArray.m_buf[retArray.m_size++] = lastvalue;
        for (int i = 1; i < array.length; ++i) {
            int value = array[i];
            if (value == lastvalue) continue;
            retArray.m_buf[retArray.m_size++] = value;
            lastvalue = value;
        }
        return retArray.asArray();
    }

    public int getLast() {
        if (this.m_size < 1) {
            throw new IndexOutOfBoundsException("Size=" + this.m_size);
        }
        return this.m_buf[this.m_size - 1];
    }

    public int getFirst() {
        if (this.m_size < 1) {
            throw new IndexOutOfBoundsException("Size=" + this.m_size);
        }
        return this.m_buf[0];
    }

    public void removeDuplicates() {
        if (this.m_size > 1) {
            this.sort();
            int lastValue = this.m_buf[0];
            for (int i = 1; i < this.m_size; ++i) {
                if (this.m_buf[i] == lastValue) {
                    --this.m_size;
                    IntArray.arraycopy(this.m_buf, i + 1, this.m_buf, i, this.m_size - i);
                    --i;
                    continue;
                }
                lastValue = this.m_buf[i];
            }
        }
        this.m_sorted = true;
    }

    public static IntArray removeDuplicates(IntArray array) {
        if (array == null || array.m_size < 1) {
            return array;
        }
        IntArray retArray = new IntArray(array.m_size);
        int[] arrayBuf = array.asArray();
        Arrays.sort(arrayBuf);
        int lastvalue = arrayBuf[0];
        retArray.ensureCapacity(0);
        retArray.m_buf[retArray.m_size++] = lastvalue;
        for (int i = 1; i < arrayBuf.length; ++i) {
            int value = arrayBuf[i];
            if (value == lastvalue) continue;
            retArray.m_buf[retArray.m_size++] = value;
            lastvalue = value;
        }
        return retArray;
    }

    public void add(IntArray array, boolean noDuplicates) {
        if (noDuplicates) {
            if (array != null && array.m_size > 0) {
                int initialSize = this.m_size;
                int[] values = null;
                if (initialSize > 0) {
                    values = this.asArray();
                    Arrays.sort(values);
                }
                for (int i = 0; i < array.m_size; ++i) {
                    int ndx;
                    int value = array.m_buf[i];
                    int n = ndx = initialSize > 0 ? Arrays.binarySearch(values, array.m_buf[i]) : -1;
                    if (ndx >= 0) continue;
                    boolean found = false;
                    for (int j = initialSize; j < this.m_size; ++j) {
                        if (this.m_buf[j] != value) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.add(value);
                }
            }
        } else {
            this.add(array);
        }
    }

    public void add(IntArray array) {
        if (array != null && array.m_size > 0) {
            this.ensureCapacity(array.m_size);
            IntArray.arraycopy(array.m_buf, 0, this.m_buf, this.m_size, array.m_size);
            this.m_size += array.m_size;
        }
    }

    public void replace(IntArray array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array.m_size > 0) {
            this.ensureCapacity(array.m_size);
            IntArray.arraycopy(array.m_buf, 0, this.m_buf, 0, array.m_size);
            this.m_size = array.m_size;
        } else {
            this.m_size = 0;
        }
    }

    public void set(int ndx, int value) {
        this.rangeCheck(ndx);
        this.m_buf[ndx] = value;
        this.m_sorted = false;
    }

    public void removeAt(int ndx) {
        this.rangeCheck(ndx);
        if (ndx < this.m_size && --this.m_size > 0) {
            IntArray.arraycopy(this.m_buf, ndx + 1, this.m_buf, ndx, this.m_size - ndx);
        }
    }

    public void setAll(int value) {
        this.ensureCapacity(0);
        Arrays.fill(this.m_buf, value);
        this.m_sorted = false;
        this.m_size = this.m_capacity;
    }

    public final void trimToSize() {
        if (this.m_size < this.m_capacity) {
            int[] newBuf = new int[this.m_size];
            IntArray.arraycopy(this.m_buf, 0, newBuf, 0, this.m_size);
            this.m_buf = newBuf;
            this.m_capacity = this.m_size;
        }
    }

    public final void add(int[] array) {
        if (array != null && array.length > 0) {
            this.ensureCapacity(array.length);
            IntArray.arraycopy(array, 0, this.m_buf, this.m_size, array.length);
            this.m_size += array.length;
            this.m_sorted = false;
        }
    }

    public final void add(int value) {
        this.ensureCapacity(1);
        this.m_buf[this.m_size] = value;
        ++this.m_size;
        this.m_sorted = false;
    }

    public boolean add(Integer e) {
        this.add((int)e);
        return true;
    }

    private final void rangeCheck(int ndx) {
        if (ndx < 0 || ndx >= this.m_size) {
            throw new IndexOutOfBoundsException("Size=" + this.m_size + " attempted=" + ndx);
        }
    }

    public static IntArray getCommonItems(IntArray array1, IntArray array2) {
        if (array1 == null || array1.m_size == 0 || array2 == null || array2.m_size == 0) {
            return null;
        }
        if (array2.m_size > array1.m_size) {
            IntArray temp = array1;
            array1 = array2;
            array2 = temp;
        }
        int[] arr1 = array1.asArray();
        Arrays.sort(arr1);
        IntArray intArray = new IntArray(array1.m_size);
        for (int i = 0; i < array2.m_size; ++i) {
            int value = array2.m_buf[i];
            if (Arrays.binarySearch(arr1, value) < 0) continue;
            intArray.add(value);
        }
        return intArray.m_size > 0 ? intArray : null;
    }

    public static int[] getCommonItems(int[] array1, int[] array2) {
        if (array1 != null && array2 != null) {
            if (array2.length > array1.length) {
                int[] temp = array1;
                array1 = array2;
                array2 = temp;
            }
            Arrays.sort(array1);
            IntArray intArray = null;
            for (int i = 0; i < array2.length; ++i) {
                int value = array2[i];
                if (Arrays.binarySearch(array1, value) < 0) continue;
                if (intArray == null) {
                    intArray = new IntArray(array1.length);
                }
                intArray.add(value);
            }
            if (intArray != null) {
                return intArray.asArray();
            }
        }
        return null;
    }

    public static boolean containCommonItems(int[] array1, int[] array2) {
        if (array1 != null && array2 != null) {
            if (array2.length > array1.length) {
                int[] temp = array1;
                array1 = array2;
                array2 = temp;
            }
            Arrays.sort(array1);
            for (int i = 0; i < array2.length; ++i) {
                int value = array2[i];
                if (Arrays.binarySearch(array1, value) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containCommonItems(IntArray array1, IntArray array2) {
        if (array1 != null && array2 != null) {
            for (int i = 0; i < array1.m_size; ++i) {
                if (!array2.contains(array1.m_buf[i])) continue;
                return true;
            }
        }
        return false;
    }

    public int get(int ndx) {
        this.rangeCheck(ndx);
        return this.m_buf[ndx];
    }

    public int[] asArray() {
        if (this.m_size > 0) {
            if (this.m_capacity > this.m_size) {
                int[] newBuf = new int[this.m_size];
                IntArray.arraycopy(this.m_buf, 0, newBuf, 0, this.m_size);
                return newBuf;
            }
            return IntArray.clone(this.m_buf);
        }
        return null;
    }

    public final int size() {
        return this.m_size;
    }

    public final boolean isEmpty() {
        return this.m_size == 0;
    }

    public final int indexOf(int value) {
        if (this.m_sorted && this.m_size > 1) {
            int start = 0;
            int end = this.m_size - 1;
            while (start <= end) {
                int mid = start + end >> 1;
                int midVal = this.m_buf[mid];
                if (midVal > value) {
                    end = mid - 1;
                    continue;
                }
                if (midVal < value) {
                    start = mid + 1;
                    continue;
                }
                return mid;
            }
        } else {
            int ndx = this.m_size;
            while (ndx > 0) {
                if (this.m_buf[--ndx] != value) continue;
                return ndx;
            }
        }
        return -1;
    }

    public void read(DataInput in) throws IOException {
        int s = in.readInt();
        this.ensureCapacity(s);
        this.m_size = 0;
        for (int i = 0; i < s; ++i) {
            this.m_buf[i] = in.readInt();
            ++this.m_size;
        }
    }

    public void read(ByteBuffer byteBuf) throws IOException {
        int s = byteBuf.getInt();
        this.ensureCapacity(s);
        this.m_size = 0;
        for (int i = 0; i < s; ++i) {
            this.m_buf[i] = byteBuf.getInt();
            ++this.m_size;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.m_size);
        for (int i = 0; i < this.m_size; ++i) {
            out.writeInt(this.m_buf[i]);
        }
    }

    public void writeInts(DataOutput out) throws IOException {
        for (int i = 0; i < this.m_size; ++i) {
            out.writeInt(this.m_buf[i]);
        }
    }

    public final boolean containsAll(int[] array) {
        for (int i : array) {
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean contains(int value) {
        if (this.m_sorted && this.m_size > 1) {
            int start = 0;
            int end = this.m_size - 1;
            while (start <= end) {
                int mid = start + end >> 1;
                int midVal = this.m_buf[mid];
                if (midVal > value) {
                    end = mid - 1;
                    continue;
                }
                if (midVal < value) {
                    start = mid + 1;
                    continue;
                }
                return true;
            }
            return false;
        }
        int ndx = this.m_size;
        while (ndx > 0) {
            if (this.m_buf[--ndx] != value) continue;
            return true;
        }
        return false;
    }

    public final void removeAll() {
        this.m_size = 0;
    }

    public static final int[] removeItems(int[] arr1, int[] arr2) {
        int removeCount;
        int n = removeCount = arr2 != null ? arr2.length : 0;
        if (arr1 != null && arr1.length > 0 && removeCount > 0) {
            IntArray a = IntArray.wrap(arr1);
            a.sort();
            int prevSize = a.size();
            for (int i = 0; i < removeCount; ++i) {
                int ndx = a.indexOf(arr2[i]);
                while (ndx > -1) {
                    a.removeAt(ndx);
                    ndx = a.indexOf(arr2[i]);
                }
            }
            if (a.size() == prevSize) {
                return a.m_buf;
            }
            return a.asArray();
        }
        return arr1;
    }

    public final int min() {
        int min = 0;
        if (this.m_size > 0) {
            min = this.m_buf[0];
            for (int i = 1; i < this.m_size; ++i) {
                int n = this.m_buf[i];
                if (min <= n) continue;
                min = n;
            }
        } else {
            throw new IndexOutOfBoundsException("Size=" + this.m_size);
        }
        return min;
    }

    public final int max() {
        int max = 0;
        if (this.m_size > 0) {
            max = this.m_buf[0];
            for (int i = 1; i < this.m_size; ++i) {
                int n = this.m_buf[i];
                if (max >= n) continue;
                max = n;
            }
        } else {
            throw new IndexOutOfBoundsException("Size=" + this.m_size);
        }
        return max;
    }

    public static final int size(IntArray a) {
        return a == null ? 0 : a.m_size;
    }

    public String toString() {
        if (this.m_size > 0) {
            StringBuilder strbuf = new StringBuilder(50);
            for (int i = 0; i < this.m_size; ++i) {
                strbuf.append(this.m_buf[i]);
                strbuf.append(',');
            }
            strbuf.deleteCharAt(strbuf.length() - 1);
            return strbuf.toString();
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntArray) {
            IntArray other = (IntArray)obj;
            if (this.m_size == other.m_size) {
                if (this.m_size > 0) {
                    for (int i = 0; i < this.m_size; ++i) {
                        if (this.m_buf[i] == other.m_buf[i]) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int value = 17;
        for (int i = 0; i < this.m_size; ++i) {
            value = 31 * value + this.m_buf[i];
        }
        return value;
    }

    @Override
    public Iterator<Integer> iterator() {
        final int[] array = this.m_buf;
        final int size = this.m_size;
        return new Iterator<Integer>(){
            private int m_curr = 0;

            @Override
            public boolean hasNext() {
                return size > this.m_curr;
            }

            @Override
            public Integer next() {
                return array[this.m_curr++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List<Integer> asList() {
        final IntArray array = this;
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return array.get(index);
            }

            @Override
            public int size() {
                return array.size();
            }
        };
    }

    public static List<Integer> asList(final int ... array) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return array[index];
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static int[] asArray(List<Integer> list) {
        int c = list.size();
        int[] array = new int[c];
        for (int i = 0; i < c; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }
}

