/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils;

public final class RomanNumeral {
    private static RomanLetter[] m_numerals = new RomanLetter[]{new RomanLetter('I', 1), new RomanLetter('V', 5), new RomanLetter('X', 10), new RomanLetter('L', 50), new RomanLetter('C', 100), new RomanLetter('D', 500), new RomanLetter('M', 1000)};

    public static int getNumber(String romanNumeral) {
        String str;
        int len;
        int n = len = romanNumeral == null ? 0 : romanNumeral.length();
        if (len > 0 && RomanNumeral.isValidRomanNumeral(str = romanNumeral.toUpperCase())) {
            int num = 0;
            int prev = 0;
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                RomanLetter romanLetter = RomanNumeral.getRomanLetter(ch);
                if (prev == 0) {
                    num += romanLetter.m_number;
                } else if (romanLetter.m_number <= prev) {
                    num += romanLetter.m_number;
                } else if ((prev == 1 || prev % 10 == 0) && romanLetter.m_number <= prev * 10) {
                    num -= prev;
                    num += romanLetter.m_number - prev;
                } else {
                    return 0;
                }
                prev = romanLetter.m_number;
            }
            return num;
        }
        return 0;
    }

    public static boolean probableRomanNumeral(String str) {
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (RomanNumeral.isRomanLetter(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidRomanNumeral(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (RomanNumeral.isRomanLetter(str.charAt(i))) continue;
            return false;
        }
        char[] charsToCheck = new char[]{'V', 'L', 'D'};
        for (int i = 0; i < charsToCheck.length; ++i) {
            char ch = charsToCheck[i];
            int ndx = -1;
            ndx = str.indexOf(ch);
            if (ndx <= -1 || str.lastIndexOf(ch) == ndx) continue;
            return false;
        }
        int sameCharCount = 0;
        char lastChar = '\u0000';
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch != lastChar) {
                sameCharCount = 1;
                lastChar = ch;
            } else {
                ++sameCharCount;
            }
            if (sameCharCount <= 3) continue;
            return false;
        }
        return true;
    }

    private static RomanLetter getRomanLetter(char ch) {
        int n = m_numerals.length;
        for (int i = 0; i < n; ++i) {
            if (RomanNumeral.m_numerals[i].m_romanCharacter != ch) continue;
            return m_numerals[i];
        }
        return null;
    }

    private static boolean isRomanLetter(char ch) {
        return RomanNumeral.getRomanLetter(ch) != null;
    }

    private static final class RomanLetter {
        char m_romanCharacter;
        int m_number;

        RomanLetter(char romanNumeral, int value) {
            this.m_romanCharacter = romanNumeral;
            this.m_number = value;
        }
    }
}

