/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.compress;

import com.mapinfo.mapmarker.cgge.utils.compress.CompTree;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CompHeader {
    private Map<Character, Number> m_charMap = new LinkedHashMap<Character, Number>(50);

    public void processString(String str) {
        int n = str == null ? 0 : str.length();
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(str.charAt(i));
            AtomicInteger count = (AtomicInteger)this.m_charMap.get(ch);
            if (count == null) {
                count = new AtomicInteger(0);
                this.m_charMap.put(ch, count);
            }
            count.incrementAndGet();
        }
    }

    public void write(DataOutput out) throws IOException {
        int n = this.m_charMap.size();
        out.writeInt(n);
        for (Map.Entry<Character, Number> en : this.m_charMap.entrySet()) {
            out.writeChar(en.getKey().charValue());
            out.writeInt(en.getValue().intValue());
        }
    }

    public void read(DataInput in) throws IOException {
        this.m_charMap.clear();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            char ch = in.readChar();
            int count = in.readInt();
            this.m_charMap.put(Character.valueOf(ch), new AtomicInteger(count));
        }
    }

    protected CompTree getCompressionTree() {
        return CompTree.create(this.m_charMap);
    }

    public int size() {
        return this.m_charMap.size();
    }

    public Map<Character, Number> getCharacterFrequencyMap() {
        return this.m_charMap;
    }
}

