/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.index;

import com.mapinfo.mapmarker.cgge.utils.index.BTreeInternalNode;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeLeafNode;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeNode;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeNodeEntry;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class BTree<K, V>
implements Map<K, V> {
    public static final int DEFAULT_BUCKET_SIZE = 100;
    private int m_order;
    private int m_size;
    private BTreeNode<K> m_rootNode;
    private Comparator<K> m_comparator;

    public BTree() {
        this(100);
    }

    public BTree(int order) {
        this.m_order = order;
    }

    @Override
    public V put(K key, V value) {
        int ndx;
        BTreeLeafNode<K> node = this.findLeafNode(key);
        if (node != null && (ndx = node.indexOf(key)) > -1) {
            return (V)node.replaceValue(ndx, value);
        }
        this.put_NoDuplicateCheck(key, value);
        return null;
    }

    protected void put_NoDuplicateCheck(K key, V value) {
        BTreeNode<K> newNode;
        BTreeNode<K> rootNode = this.getRootNode();
        if (rootNode == null) {
            rootNode = this.getNewLeafNodeInstance();
            this.setRootNode(rootNode);
        }
        if ((newNode = rootNode.add(key, value)) != null) {
            BTreeInternalNode<K> newRoot = this.getNewInternalNodeInstance();
            newRoot.add(newNode.floorKey(), rootNode);
            newRoot.setRightChild(0, newNode);
            this.setRootNode(newRoot);
        }
        ++this.m_size;
    }

    protected BTreeLeafNode<K> getNewLeafNodeInstance() {
        return new BTreeLeafNode(this);
    }

    protected BTreeInternalNode<K> getNewInternalNodeInstance() {
        return new BTreeInternalNode(this);
    }

    @Override
    public int size() {
        return this.m_size;
    }

    @Override
    public V get(Object key) {
        Object k = key;
        BTreeLeafNode<Object> node = this.findLeafNode(k);
        return (V)(node == null ? null : ((BTreeNode)node).findValue(k));
    }

    private BTreeLeafNode<K> findLeafNode(K key) {
        BTreeNode<K> root = this.getRootNode();
        if (root != null) {
            if (root instanceof BTreeInternalNode) {
                return (BTreeLeafNode)((BTreeInternalNode)root).findLeafNode(key);
            }
            return (BTreeLeafNode)root;
        }
        return null;
    }

    protected void setRootNode(BTreeNode<K> root) {
        this.m_rootNode = root;
    }

    protected BTreeNode<K> getRootNode() {
        return this.m_rootNode;
    }

    protected Comparator<? super K> getComparator() {
        if (this.m_comparator == null) {
            this.m_comparator = new Comparator<K>(){

                @Override
                public int compare(K o1, K o2) {
                    Comparable c1 = (Comparable)o1;
                    return c1.compareTo(o2);
                }
            };
        }
        return this.m_comparator;
    }

    protected int getOrder() {
        return this.m_order;
    }

    @Override
    public boolean isEmpty() {
        return this.m_size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        Object k = key;
        BTreeLeafNode<Object> node = this.findLeafNode(k);
        if (node != null) {
            return ((BTreeNode)node).indexOf(k) > -1;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.size() > 0) {
            EntrySet entrySet = new EntrySet(this);
            Iterator it = entrySet.iterator();
            while (it.hasNext()) {
                if (!BTree.valueEquals(it.next().getValue(), value)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean valueEquals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 != null && value2 != null) {
            return value1.equals(value2);
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (!m.isEmpty()) {
            for (Map.Entry<K, V> en : m.entrySet()) {
                this.put(en.getKey(), en.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.setRootNode(null);
        this.m_size = 0;
    }

    @Override
    public Set<K> keySet() {
        return this.size() > 0 ? new KeySet(this) : null;
    }

    @Override
    public Collection<V> values() {
        return this.size() > 0 ? new Values(this) : null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this);
    }

    private BTreeLeafNode<K> findLeftMostLeafNode() {
        BTreeNode leftMostNode = null;
        if (this.size() > 0) {
            leftMostNode = this.getRootNode();
            while (!leftMostNode.isLeafNode()) {
                leftMostNode = (BTreeNode)((BTreeInternalNode)leftMostNode).getLeftChild(0);
            }
        }
        return (BTreeLeafNode)leftMostNode;
    }

    public BTreeNode<K> getNewNodeInstance(boolean leafNode) {
        if (leafNode) {
            return this.getNewLeafNodeInstance();
        }
        return this.getNewInternalNodeInstance();
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final BTree<K, V> m_tree;

        EntrySet(BTree<K, V> tree) {
            this.m_tree = tree;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                BTreeLeafNode<K> m_curNode;
                Iterator<BTreeNodeEntry<K, V>> m_curIterator;
                Map.Entry<K, V> m_nextItem;
                {
                    this.m_curNode = BTree.this.findLeftMostLeafNode();
                    this.m_curIterator = null;
                    this.m_nextItem = this.nextItem();
                }

                private Iterator<BTreeNodeEntry<K, V>> nextIterator() {
                    if (this.m_curNode != null) {
                        BTreeLeafNode curNode = this.m_curNode;
                        this.m_curNode = this.m_curNode.getNextNode();
                        return curNode.iterator();
                    }
                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.m_nextItem != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.m_nextItem != null) {
                        Map.Entry current = this.m_nextItem;
                        this.m_nextItem = this.nextItem();
                        return current;
                    }
                    throw new NoSuchElementException();
                }

                private Map.Entry<K, V> nextItem() {
                    Map.Entry nextItem = null;
                    if (this.m_curIterator != null && this.m_curIterator.hasNext()) {
                        nextItem = this.m_curIterator.next();
                    } else {
                        this.m_curIterator = this.nextIterator();
                        if (this.m_curIterator != null) {
                            return this.nextItem();
                        }
                    }
                    return nextItem;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.m_tree.size();
        }
    }

    class KeySet
    extends AbstractSet<K> {
        final Iterator<Map.Entry<K, V>> m_entrySetIt;
        final int m_size;

        KeySet(BTree<K, V> tree) {
            this.m_entrySetIt = BTree.this.entrySet().iterator();
            this.m_size = tree.size();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return KeySet.this.m_entrySetIt.hasNext();
                }

                @Override
                public K next() {
                    return KeySet.this.m_entrySetIt.next().getKey();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.m_size;
        }
    }

    class Values
    extends AbstractCollection<V> {
        final Iterator<Map.Entry<K, V>> m_entrySetIt;
        final int m_size;

        Values(BTree<K, V> tree) {
            this.m_entrySetIt = BTree.this.entrySet().iterator();
            this.m_size = tree.size();
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return Values.this.m_entrySetIt.hasNext();
                }

                @Override
                public V next() {
                    return Values.this.m_entrySetIt.next().getValue();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.m_size;
        }
    }
}

