/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.index;

import com.mapinfo.mapmarker.cgge.utils.ArrayUtils;
import com.mapinfo.mapmarker.cgge.utils.index.BTree;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeNode;
import com.mapinfo.mapmarker.cgge.utils.index.IBTreeNode;
import java.util.Comparator;

public class BTreeInternalNode<K>
extends BTreeNode<K> {
    protected <V> BTreeInternalNode(BTree<K, V> tree) {
        super(false, tree);
    }

    protected BTreeInternalNode(BTreeInternalNode<K> copy) {
        super(copy);
    }

    @Override
    protected BTreeNode<K> add(K key, Object value) {
        BTreeNode<K> childNode = this.getChildNode(key, this.getTree().getComparator());
        if (childNode == null) {
            return super.add(key, value);
        }
        BTreeNode<K> newRightChild = childNode.add(key, value);
        if (newRightChild != null) {
            K newKey = newRightChild.floorKey();
            BTreeInternalNode newRightNode = (BTreeInternalNode)super.add(newKey, childNode);
            this.setRightChildAfterSplit(newKey, newRightNode, newRightChild);
            return newRightNode;
        }
        return null;
    }

    protected void setRightChildAfterSplit(K key, BTreeInternalNode<K> newRightNode, IBTreeNode<K> newRightChild) {
        BTreeInternalNode<K> nodeToAdd = this;
        int ndx = this.indexOf(key);
        if (ndx < 0 && newRightNode != null) {
            ndx = newRightNode.indexOf(key);
            nodeToAdd = newRightNode;
        }
        nodeToAdd.setRightChild(ndx, newRightChild);
    }

    protected BTreeNode<K> getChildNode(K key, Comparator<? super K> comparator) {
        Object[] keys = this.getKeys();
        int size = this.size();
        if (size > 0) {
            int n = ArrayUtils.insertPos_withoutChecks(keys, key, comparator, 0, size);
            return this.getChildNode(key, keys, comparator, n, size);
        }
        return null;
    }

    protected IBTreeNode<K> findLeafNode(K key) {
        return this.findLeafNodeInternal(key, this.getTree().getComparator());
    }

    protected BTreeNode<K> findLeafNodeInternal(K key, Comparator<? super K> comp) {
        int size;
        int n;
        Object[] keys = this.getKeys();
        BTreeNode<K> childNode = this.getChildNode(key, keys, comp, n = ArrayUtils.insertPos_withoutChecks(keys, key, comp, 0, size = this.size()), size);
        if (childNode != null && !childNode.isLeafNode()) {
            childNode = ((BTreeInternalNode)childNode).findLeafNodeInternal(key, comp);
        }
        return childNode;
    }

    protected BTreeNode<K> getChildNode(K search, K[] keys, Comparator<? super K> comp, int keyNdx, int size) {
        if (keyNdx == size) {
            return (BTreeNode)this.getRightChild(keyNdx - 1);
        }
        int c = comp.compare(keys[keyNdx], search);
        return (BTreeNode)(c > 0 ? this.getLeftChild(keyNdx) : this.getRightChild(keyNdx));
    }

    protected void setRightChild(int ndx, Object rightChild) {
        this.getValues()[ndx + 1] = rightChild;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.size() > 0) {
            sb.append("::Right-");
            BTreeNode value = (BTreeNode)this.getValues()[this.size()];
            if (value != null) {
                sb.append(value.toString());
            }
        }
        return sb.toString();
    }

    protected Object getLeftChild(int ndx) {
        return this.getValues()[ndx];
    }

    protected Object getRightChild(int ndx) {
        return this.getValues()[ndx + 1];
    }
}

