/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.index;

import com.mapinfo.mapmarker.cgge.utils.index.BTreeInternalNode;
import com.mapinfo.mapmarker.cgge.utils.index.BTreeNode;
import com.mapinfo.mapmarker.cgge.utils.index.DiskBTree;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskNode;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskTreeKey;
import com.mapinfo.mapmarker.cgge.utils.index.InternalBTreeException;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;

public class DiskInternalNode<K, V>
extends BTreeInternalNode<K>
implements IDiskNode<K> {
    private DiskBTree m_tree;
    private boolean m_modified;
    private long m_offset;

    protected DiskInternalNode(BTreeInternalNode<K> copy) {
        super(copy);
        this.m_modified = true;
    }

    protected <K extends IDiskTreeKey, V extends IDataItem> DiskInternalNode(DiskBTree tree) {
        super(tree);
        this.m_tree = tree;
        this.setModified(true);
    }

    @Override
    public Object replaceValue(int ndx, Object value) {
        this.setModified(true);
        return super.replaceValue(ndx, value);
    }

    @Override
    protected BTreeNode<K> add(K key, Object value) {
        int savedSize = this.size();
        DiskInternalNode newNode = (DiskInternalNode)super.add(key, value);
        if (savedSize != this.size()) {
            this.setModified(true);
        }
        return newNode;
    }

    @Override
    protected void setRightChild(int ndx, Object rightChild) {
        this.setModified(true);
        super.setRightChild(ndx, rightChild);
    }

    @Override
    protected Object getLeftChild(int ndx) {
        Object child = this.getChild(super.getLeftChild(ndx));
        if (this.m_tree.getMode() == IOUtil.IO_MODE.READ_WRITE) {
            this.getValues()[ndx] = child;
        }
        return child;
    }

    @Override
    protected Object getRightChild(int ndx) {
        Object child = this.getChild(super.getRightChild(ndx));
        if (this.m_tree.getMode() == IOUtil.IO_MODE.READ_WRITE) {
            this.getValues()[ndx + 1] = child;
        }
        return child;
    }

    protected Object getChild(Object child) {
        if (child instanceof BTreeNode) {
            return child;
        }
        return this.getChild((Long)child);
    }

    private Object getChild(Long offset) {
        try {
            return this.m_tree.getNodeAt(offset);
        }
        catch (Exception e) {
            throw new InternalBTreeException(e);
        }
    }

    @Override
    public void setModified(boolean b) {
        this.m_modified = b;
    }

    @Override
    public boolean modified() {
        return this.m_modified;
    }

    @Override
    public long getOffset() {
        return this.m_offset;
    }

    @Override
    public void setOffset(long offset) {
        this.m_offset = offset;
    }
}

