/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.index;

import com.mapinfo.mapmarker.cgge.utils.index.BTreeNode;
import com.mapinfo.mapmarker.cgge.utils.index.DiskBTree;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskNode;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskTreeKey;
import com.mapinfo.mapmarker.cgge.utils.index.InternalBTreeException;
import com.mapinfo.mapmarker.cgge.utils.io.DummyDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import java.io.IOException;

public class DiskNodeIOHandler {
    private ICGGEDataStream m_dataAccess;
    private boolean m_temp;
    private DiskBTree m_tree;
    public static int m_diskFetches = 0;
    public static int m_nodesWritten = 0;

    public DiskNodeIOHandler(DiskBTree tree, ICGGEDataStream dataAccess, boolean temp) {
        this.m_dataAccess = dataAccess;
        this.m_temp = temp;
        this.m_tree = tree;
    }

    public IDiskNode<IDiskTreeKey> getNodeAt(long offset) throws IOException {
        return this.read(offset);
    }

    protected boolean writeNodeUpdates(IDiskNode<IDiskTreeKey> node) throws Exception {
        int childCount = node.size();
        boolean updated = node.modified();
        if (!node.isLeafNode()) {
            for (int i = 0; i <= childCount; ++i) {
                IDiskNode<IDiskTreeKey> nextNode;
                IDiskNode<IDiskTreeKey> childNode = this.getNodeFromPointer(node.getValue(i), false);
                if (childNode == null) continue;
                if (i < childCount && (nextNode = this.getNodeFromPointer(node.getValue(i + 1), false)) != null && nextNode.getOffset() <= 0L && this.writeNodeUpdates(nextNode)) {
                    updated = true;
                }
                if (this.writeNodeUpdates(childNode)) {
                    updated = true;
                }
                node.replaceValue(i, childNode.getOffset());
            }
        } else {
            IDiskNode<IDiskTreeKey> nextNode = this.getNodeFromPointer(node.getValue(childCount), false);
            if (nextNode != null && nextNode.getOffset() <= 0L && this.writeNodeUpdates(nextNode)) {
                updated = true;
            }
        }
        updated = updated ? this.writeUpdatedNode(node) : false;
        return updated;
    }

    private IDiskNode<IDiskTreeKey> getNodeFromPointer(Object v, boolean fetch) throws Exception {
        if (v instanceof IDiskNode) {
            return (IDiskNode)v;
        }
        if (fetch) {
            return this.getNodeAt((Long)v);
        }
        return null;
    }

    protected boolean writeUpdatedNode(IDiskNode<IDiskTreeKey> node) throws IOException {
        long savedOffset = node.getOffset();
        this.write(node);
        node.setModified(false);
        return node.getOffset() != savedOffset;
    }

    private IDiskNode<IDiskTreeKey> read(long offset) throws IOException {
        if (this.m_temp) {
            this.moveToTempPosition(offset);
        } else {
            this.m_dataAccess.seek(offset);
        }
        IDiskNode<IDiskTreeKey> node = null;
        node = this.m_temp ? this.readTemp(this.m_dataAccess) : this.readData(this.m_dataAccess);
        node.setModified(false);
        return node;
    }

    public void write(IDiskNode<IDiskTreeKey> node) throws IOException {
        ++m_nodesWritten;
        if (this.m_temp) {
            this.writeTemp(node);
        } else {
            long offset = this.m_dataAccess.offset();
            this.writeData(node, this.m_dataAccess);
            node.setOffset(offset);
        }
    }

    protected IDiskNode<IDiskTreeKey> readData(ICGGEDataInput in) throws IOException {
        boolean isLeaf = in.readBoolean();
        IDiskNode node = (IDiskNode)((Object)(isLeaf ? this.m_tree.getNewLeafNodeInstance() : this.m_tree.getNewInternalNodeInstance()));
        int s = in.readVUnsignedInt();
        int max = this.m_tree.getOrder();
        IDiskTreeKey[] keys = new IDiskTreeKey[max + 1];
        Object[] values = new Object[max + 1];
        IDiskTreeKey keyType = this.m_tree.getKeyType();
        IDataItem valueType = node.isLeafNode() ? this.m_tree.getValueType() : null;
        for (int i = 0; i < s; ++i) {
            IDiskTreeKey k = null;
            try {
                k = (IDiskTreeKey)keyType.getNewInstance();
            }
            catch (Exception e) {
                throw new InternalBTreeException(e);
            }
            k.read(in);
            keys[i] = k;
            if (valueType != null) {
                Object v;
                try {
                    v = valueType.getNewInstance();
                }
                catch (Exception e) {
                    throw new InternalBTreeException(e);
                }
                v.read(in);
                values[i] = v;
                continue;
            }
            values[i] = in.readVUnsignedLong();
        }
        long offset = in.readVUnsignedLong();
        if (offset > 0L) {
            values[s] = offset;
        }
        node.setKeyValues(keys, values, s);
        return node;
    }

    private int calculateBlockSize(IDiskNode<?> node) throws IOException {
        DummyDataOutput dataOut = new DummyDataOutput();
        this.writeData(node, dataOut);
        return dataOut.getOffset();
    }

    private void appendNew(IDiskNode<?> node) throws IOException {
        long offset = this.m_dataAccess.seekEnd();
        int blockSize = this.calculateBlockSize(node);
        this.appendNew(node, blockSize);
        node.setOffset(offset);
    }

    private void appendNew(IDiskNode<?> node, int blockSize) throws IOException {
        this.m_dataAccess.writeBoolean(true);
        int newBlockSize = this.calculateBlockSize(node, blockSize);
        this.m_dataAccess.writeVUnsignedInt(newBlockSize);
        this.writeData(node, this.m_dataAccess);
        int fillSize = newBlockSize - blockSize;
        if (fillSize > 0) {
            this.m_dataAccess.write(new byte[fillSize]);
        }
    }

    private int calculateBlockSize(IDiskNode<?> node, int blockSize) {
        int s = node.size();
        int max = this.m_tree.getOrder();
        int newBlockSize = blockSize;
        if (s < max || node.isLeafNode()) {
            int avg = blockSize / s;
            int inc = (int)((double)avg * 1.25 * (double)(1 + (max - s)));
            newBlockSize = blockSize + inc;
        }
        return newBlockSize;
    }

    private void writeData(IDiskNode<?> node, ICGGEDataOutput out) throws IOException {
        out.writeBoolean(node.isLeafNode());
        int s = node.size();
        out.writeVUnsignedInt(s);
        boolean leafNode = node.isLeafNode();
        for (int i = 0; i < s; ++i) {
            ((IDiskTreeKey)node.getKey(i)).write(out);
            if (leafNode) {
                ((IDataItem)node.getValue(i)).write(out);
                continue;
            }
            Object obj = node.getValue(i);
            if (obj instanceof IDiskNode) {
                out.writeVUnsignedLong(node.getOffset());
                continue;
            }
            out.writeVUnsignedLong((Long)obj);
        }
        Object lastValue = node.getValue(s);
        if (lastValue != null) {
            if (lastValue instanceof BTreeNode) {
                out.writeVUnsignedLong(((IDiskNode)lastValue).getOffset());
            } else {
                out.writeVUnsignedLong((Long)lastValue);
            }
        } else {
            out.writeVUnsignedLong(0L);
        }
    }

    private boolean writeTemp(IDiskNode<IDiskTreeKey> node) throws IOException {
        long offset = node.getOffset();
        boolean offsetChanged = true;
        if (offset > 0L) {
            int dataSize;
            offset = this.moveToTempPosition(offset);
            int chunkSize = this.calculateBlockSize(node);
            if (chunkSize > (dataSize = this.m_dataAccess.readVUnsignedInt())) {
                long endPos = this.m_dataAccess.seekEnd();
                this.m_dataAccess.seek(offset - 1L);
                this.m_dataAccess.writeBoolean(false);
                this.m_dataAccess.writeVUnsignedLong(endPos);
                this.m_dataAccess.seekEnd();
                this.appendNew(node, chunkSize);
            } else {
                this.writeData(node, this.m_dataAccess);
                offsetChanged = false;
            }
        } else {
            this.appendNew(node);
        }
        return offsetChanged;
    }

    private long moveToTempPosition(long offset) throws IOException {
        this.m_dataAccess.seek(offset);
        boolean hasData = this.m_dataAccess.readBoolean();
        if (!hasData) {
            return this.moveToTempPosition(this.m_dataAccess.readVUnsignedLong());
        }
        return this.m_dataAccess.offset();
    }

    public IDiskNode<IDiskTreeKey> readTemp(ICGGEDataInput in) throws IOException {
        in.readVUnsignedInt();
        return this.readData(in);
    }

    protected ICGGEDataStream getDataAccess() {
        return this.m_dataAccess;
    }

    public void flush() throws IOException {
        this.m_dataAccess.flush();
    }
}

