/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.io;

import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class BufferedDataStream
implements ICGGEDataStream {
    private static int DEFAULT_BUFFER_SIZE = 8192;
    private IOUtil.IO_MODE m_mode;
    private RandomAccessFile m_file;
    private int m_capacity;
    private boolean m_modified;
    private ByteBuffer m_buf;
    private long m_offset;
    private int m_limit;
    private int m_position;
    private byte[] m_array;
    private long fileLen;

    public BufferedDataStream(File file) throws IOException {
        this(file, IOUtil.IO_MODE.READ_ONLY);
    }

    public BufferedDataStream(File file, IOUtil.IO_MODE mode) throws IOException {
        this(file, mode, DEFAULT_BUFFER_SIZE);
    }

    protected BufferedDataStream(File file, IOUtil.IO_MODE mode, int bufSize) throws IOException {
        if (bufSize < 0) {
            throw new IllegalArgumentException();
        }
        this.m_capacity = bufSize;
        this.m_mode = mode;
        this.m_offset = 0L;
        this.m_position = 0;
        this.initialise(file, mode);
    }

    RandomAccessFile initialiseFile(File file, IOUtil.IO_MODE mode) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = mode == IOUtil.IO_MODE.READ_ONLY ? new RandomAccessFile(file, "r") : new RandomAccessFile(file, "rw");
        return randomAccessFile;
    }

    void initialise(File file, IOUtil.IO_MODE mode) throws IOException {
        this.setFile(this.initialiseFile(file, mode));
        this.readIntoBuffer(this.m_capacity);
        this.m_modified = false;
        this.fileLen = this.getInternalFileLen();
    }

    long getInternalFileLen() throws IOException {
        return this.getFile() == null ? 0L : this.getFile().length();
    }

    void setFile(RandomAccessFile file) {
        this.m_file = file;
    }

    int getCapacity() {
        return this.m_capacity;
    }

    void setOffset(long offset) {
        this.m_offset = offset;
    }

    final void ensureRead(int len) throws IOException {
        if (this.remaining() < len) {
            this.seekInternal(this.m_offset + (long)this.getPosition(), len > this.m_capacity ? len : this.m_capacity);
            if (this.remaining() < len) {
                throw new IOException("End of file reached");
            }
        }
    }

    private final int remaining() {
        return this.m_limit - this.getPosition();
    }

    void readIntoBuffer(int bufferSize) throws IOException {
        this.m_buf = this.initNewBuffer(bufferSize);
        this.setLimit(this.m_buf.limit());
        this.m_buf.limit(this.m_buf.capacity());
        this.m_buf.mark();
        this.m_buf.rewind();
        this.m_array = this.getInternalArray(this.m_buf);
    }

    ByteBuffer initNewBuffer(int bufferSize) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(bufferSize);
        int limit = this.getFile().getChannel().read(buf);
        if (limit < 0) {
            limit = 0;
        }
        buf.limit(limit);
        buf.rewind();
        return buf;
    }

    byte[] getInternalArray(ByteBuffer buf) {
        return null;
    }

    private final void seekInternal(long pos, int readSize) throws IOException {
        this.flush();
        this.internalSeek(pos);
        this.m_offset = pos;
        this.setPosition(0);
        this.readIntoBuffer(readSize);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.inBuffer(pos)) {
            this.setPosition((int)(pos - this.m_offset));
        } else {
            this.seekInternal(pos, this.m_capacity);
        }
    }

    private final boolean inBuffer(long filePos) {
        long relativePos = filePos - this.m_offset;
        return relativePos >= 0L && relativePos < (long)this.m_capacity;
    }

    @Override
    public long seekEnd() throws IOException {
        long endPos = this.endOffset();
        this.seek(endPos);
        return endPos;
    }

    public long endOffset() throws IOException {
        long maxBufferOffset;
        long endPos = this.getFileLength();
        if (endPos < (maxBufferOffset = this.m_offset + (long)this.m_limit)) {
            endPos = maxBufferOffset;
        }
        return endPos;
    }

    long getFileLength() throws IOException {
        return this.fileLen;
    }

    @Override
    public final void flush() throws IOException {
        if (this.m_modified) {
            int savedLimit = this.m_buf.limit();
            this.m_buf.limit(this.m_limit);
            this.m_buf.position(0);
            this.internalSeek(this.m_offset);
            this.internalFlush(this.m_buf);
            this.m_buf.limit(savedLimit);
        }
        this.m_modified = false;
    }

    void internalSeek(long offset) throws IOException {
        this.getFile().seek(offset);
    }

    void internalFlush(ByteBuffer buf) throws IOException {
        RandomAccessFile file = this.getFile();
        file.getChannel().write(this.m_buf);
        this.fileLen = file.length();
    }

    void ensureWrite(int len) throws IOException {
        int newPositionAfterWrite;
        if (this.m_mode != IOUtil.IO_MODE.READ_WRITE) {
            throw new IOException("Cannot write into read only file");
        }
        int remaining = this.m_capacity - this.getPosition();
        if (remaining < len) {
            this.seekInternal(this.m_offset + (long)this.getPosition(), len > this.m_capacity ? len : this.m_capacity);
        }
        if ((newPositionAfterWrite = this.getPosition() + len) > this.m_limit) {
            this.m_limit = newPositionAfterWrite;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureWrite(len);
        for (int i = 0; i < len; ++i) {
            this.put(b[i]);
        }
        this.m_modified = true;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureWrite(1);
        this.put((byte)(v ? 1 : 0));
        this.m_modified = true;
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureWrite(1);
        this.put((byte)v);
        this.m_modified = true;
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureWrite(2);
        this.put((byte)(v >> 8));
        this.put((byte)v);
        this.m_modified = true;
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensureWrite(2);
        this.put((byte)(v >> 8));
        this.put((byte)v);
        this.m_modified = true;
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureWrite(4);
        this.put((byte)(v >> 24));
        this.put((byte)(v >> 16));
        this.put((byte)(v >> 8));
        this.put((byte)v);
        this.m_modified = true;
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureWrite(8);
        this.put((byte)(v >> 56));
        this.put((byte)(v >> 48));
        this.put((byte)(v >> 40));
        this.put((byte)(v >> 32));
        this.put((byte)(v >> 24));
        this.put((byte)(v >> 16));
        this.put((byte)(v >> 8));
        this.put((byte)v);
        this.m_modified = true;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        int i = Float.floatToIntBits(v);
        this.writeInt(i);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        long l = Double.doubleToLongBits(v);
        this.writeLong(l);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        char[] chars;
        this.ensureWrite(s.length());
        for (char ch : chars = s.toCharArray()) {
            this.put((byte)ch);
        }
        this.m_modified = true;
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] chars;
        this.ensureWrite(s.length() * 2);
        for (char ch : chars = s.toCharArray()) {
            this.writeChar(ch);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        out.writeUTF(s);
        this.write(byteStream.toByteArray());
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.internalClose();
    }

    void internalClose() throws IOException {
        this.getFile().close();
    }

    @Override
    public long offset() {
        return this.m_offset + (long)this.getPosition();
    }

    public IOUtil.IO_MODE getMode() {
        return this.m_mode;
    }

    private final byte get() {
        return this.m_array == null ? this.m_buf.get() : this.m_array[this.m_position++];
    }

    private final void put(byte b) {
        if (this.m_array == null) {
            this.m_buf.put(b);
        } else {
            this.m_array[this.m_position++] = b;
        }
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.ensureRead(len);
        if (this.m_array != null) {
            System.arraycopy(this.m_array, this.m_position, b, off, len);
            this.m_position += len;
        } else {
            this.m_buf.get(b, off, len);
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        this.ensureRead(n);
        this.setPosition(this.getPosition() + n);
        return n;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        this.ensureRead(1);
        return this.get() == 1;
    }

    @Override
    public final byte readByte() throws IOException {
        this.ensureRead(1);
        return this.get();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        this.ensureRead(1);
        return this.get() & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        this.ensureRead(2);
        return (short)(this.get() << 8 | this.get() & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final char readChar() throws IOException {
        this.ensureRead(2);
        return (char)(this.get() << 8 | this.get() & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.ensureRead(4);
        return this.readIntInternal();
    }

    private final int readIntInternal() throws IOException {
        if (this.m_array != null) {
            return (this.m_array[this.m_position++] & 0xFF) << 24 | (this.m_array[this.m_position++] & 0xFF) << 16 | (this.m_array[this.m_position++] & 0xFF) << 8 | (this.m_array[this.m_position++] & 0xFF) << 0;
        }
        return this.m_buf.getInt();
    }

    @Override
    public final long readLong() throws IOException {
        this.ensureRead(8);
        return ((long)this.get() & 0xFFL) << 56 | ((long)this.get() & 0xFFL) << 48 | ((long)this.get() & 0xFFL) << 40 | ((long)this.get() & 0xFFL) << 32 | ((long)this.get() & 0xFFL) << 24 | ((long)this.get() & 0xFFL) << 16 | ((long)this.get() & 0xFFL) << 8 | ((long)this.get() & 0xFFL) << 0;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void writeVUnsignedInt(int v) throws IOException {
        byte[] bytes = IOUtil.toVBytes(v);
        this.write(bytes);
    }

    @Override
    public void writeVUnsignedLong(long v) throws IOException {
        byte[] bytes = IOUtil.toVBytes(v);
        this.write(bytes);
    }

    @Override
    public final int readVUnsignedInt() throws IOException {
        boolean useDirect = this.remaining() > 3;
        return this.readVUnsignedInt(useDirect);
    }

    private final int readVUnsignedInt(boolean useDirect) throws IOException {
        int number = 0;
        byte b = 0;
        int shiftDigits = 0;
        do {
            b = useDirect ? this.get() : this.readByte();
            number |= (b & 0x7F) << shiftDigits;
        } while ((b & 0x80) == 128 && (shiftDigits += 7) < 28);
        return number;
    }

    @Override
    public final long readVUnsignedLong() throws IOException {
        long number = 0L;
        long b = 0L;
        int shiftDigits = 0;
        boolean useDirect = this.remaining() >= 8;
        do {
            b = useDirect ? (long)this.get() : (long)this.readByte();
            number |= (b & 0x7FL) << shiftDigits;
        } while ((b & 0x80L) == 128L && (shiftDigits += 7) < 56);
        return number;
    }

    @Override
    public void readInts(int[] array) throws IOException {
        int c = array.length;
        this.ensureRead(4 * c);
        for (int i = 0; i < c; ++i) {
            array[i] = this.readIntInternal();
        }
    }

    @Override
    public void readUnsignedShorts(int[] array) throws IOException {
        int c = array.length;
        this.ensureRead(2 * c);
        for (int i = 0; i < c; ++i) {
            array[i] = (this.get() << 8 | this.get() & 0xFF) & 0xFFFF;
        }
    }

    @Override
    public void readUnsignedBytes(int[] array) throws IOException {
        int c = array.length;
        this.ensureRead(1 * c);
        for (int i = 0; i < c; ++i) {
            array[i] = this.get() & 0xFF;
        }
    }

    public boolean isEOF() throws IOException {
        return this.offset() >= this.getFileLength();
    }

    RandomAccessFile getFile() {
        return this.m_file;
    }

    int getPosition() {
        if (this.m_array == null) {
            return this.m_buf == null ? 0 : this.m_buf.position();
        }
        return this.m_position;
    }

    void setPosition(int position) {
        if (this.m_array == null) {
            this.m_buf.position(position);
        }
        this.m_position = position;
    }

    ByteBuffer getBuf() {
        return this.m_buf;
    }

    void setBuf(ByteBuffer buf) {
        this.m_buf = buf;
    }

    int getLimit() {
        return this.m_limit;
    }

    void setLimit(int limit) {
        this.m_limit = limit;
    }

    @Override
    public void readVUnsignedInts(int[] array) throws IOException {
        int len = array.length;
        this.ensureRead(len * 1);
        for (int i = 0; i < len; ++i) {
            array[i] = this.readVUnsignedInt();
        }
    }

    @Override
    public void readVUnsignedLongs(int[] array) throws IOException {
        int len = array.length;
        this.ensureRead(len * 1);
        for (int i = 0; i < len; ++i) {
            array[i] = (int)this.readVUnsignedLong();
        }
    }
}

