/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.io;

import com.mapinfo.mapmarker.cgge.utils.io.FileHandler;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;

public class ByteArrayDataInputStream
implements ICGGEDataInputStream {
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    private FileHandler m_fileHandler;
    private int m_capacity = 8192;
    private long m_offset;
    private int m_position;
    private byte[] m_bb;

    ByteArrayDataInputStream() {
    }

    public ByteArrayDataInputStream(FileHandler fileHandler) throws IOException {
        this(fileHandler, 8192);
    }

    public ByteArrayDataInputStream(ByteArrayDataInputStream anotherStream, long offset) {
        this.copy(anotherStream, offset);
    }

    void copy(ByteArrayDataInputStream anotherStream, long offset) {
        this.m_offset = anotherStream.m_offset;
        this.m_position = (int)(offset - this.m_offset);
        this.m_bb = anotherStream.m_bb;
        this.m_capacity = anotherStream.m_capacity;
        this.m_fileHandler = anotherStream.m_fileHandler;
    }

    public ByteArrayDataInputStream(ByteArrayDataInputStream anotherStream) {
        this(anotherStream, anotherStream.m_offset);
    }

    public ByteArrayDataInputStream(FileHandler fileHandler, long offset) throws IOException {
        this(fileHandler, 8192, offset);
    }

    protected ByteArrayDataInputStream(FileHandler fileHandler, int bufSize) throws IOException {
        this(fileHandler, bufSize, 0L);
    }

    protected ByteArrayDataInputStream(FileHandler fileHandler, int bufSize, long offset) throws IOException {
        this.init(fileHandler, bufSize, offset);
    }

    void init(FileHandler fileHandler, int bufSize, long offset) throws IOException {
        if (bufSize < 0) {
            throw new IllegalArgumentException();
        }
        this.m_capacity = bufSize;
        this.m_offset = offset;
        this.m_position = 0;
        this.m_fileHandler = fileHandler;
        this.readIntoBuffer(this.m_offset, this.m_capacity);
    }

    final void ensureRead(int len) throws IOException {
        int remaining;
        if (this.remaining() < len && (remaining = this.seekInternal(this.m_offset + (long)this.m_position, len > this.m_capacity ? len : this.m_capacity)) < len) {
            throw new IOException("End of file reached");
        }
    }

    private final int remaining() {
        return this.m_bb.length - this.m_position;
    }

    int readIntoBuffer(long offset, int bufferSize) throws IOException {
        byte[] bytes = new byte[bufferSize];
        int limit = this.m_fileHandler.readBytes(offset, bytes);
        if (limit < bufferSize) {
            bytes = Arrays.copyOf(bytes, limit);
        }
        this.m_bb = bytes;
        return limit;
    }

    private final int seekInternal(long pos, int readSize) throws IOException {
        this.m_offset = pos;
        this.m_position = 0;
        return this.readIntoBuffer(pos, readSize);
    }

    int seekInternal(long pos) throws IOException {
        this.m_offset = pos;
        this.m_position = 0;
        return this.readIntoBuffer(pos, this.m_capacity);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.inBuffer(pos)) {
            this.m_position = (int)(pos - this.m_offset);
        } else {
            this.seekInternal(pos, this.m_capacity);
        }
    }

    final boolean inBuffer(long filePos) {
        long relativePos = filePos - this.m_offset;
        return relativePos >= 0L && relativePos < (long)this.m_bb.length;
    }

    @Override
    public long seekEnd() throws IOException {
        long endPos;
        this.m_offset = endPos = this.getFileLength();
        this.m_position = 0;
        this.m_bb = new byte[0];
        return endPos;
    }

    long getFileLength() throws IOException {
        return this.m_fileHandler.fileLength();
    }

    @Override
    public void close() throws IOException {
        this.m_fileHandler.close();
    }

    @Override
    public long offset() {
        return this.m_offset + (long)this.m_position;
    }

    private final byte get() {
        return this.m_bb[this.m_position++];
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.ensureRead(len);
        System.arraycopy(this.m_bb, this.m_position, b, off, len);
        this.m_position += len;
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        this.ensureRead(n);
        this.m_position += n;
        return n;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        this.ensureRead(1);
        return this.get() == 1;
    }

    @Override
    public final byte readByte() throws IOException {
        this.ensureRead(1);
        return this.get();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        this.ensureRead(1);
        return this.get() & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        this.ensureRead(2);
        return (short)(this.get() << 8 | this.get() & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.ensureRead(2);
        return (this.get() << 8 | this.get() & 0xFF) & 0xFFFF;
    }

    @Override
    public final char readChar() throws IOException {
        this.ensureRead(2);
        return (char)(this.get() << 8 | this.get() & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.ensureRead(4);
        return (this.m_bb[this.m_position++] & 0xFF) << 24 | (this.m_bb[this.m_position++] & 0xFF) << 16 | (this.m_bb[this.m_position++] & 0xFF) << 8 | (this.m_bb[this.m_position++] & 0xFF) << 0;
    }

    private int readIntInternal() throws IOException {
        return (this.m_bb[this.m_position++] & 0xFF) << 24 | (this.m_bb[this.m_position++] & 0xFF) << 16 | (this.m_bb[this.m_position++] & 0xFF) << 8 | (this.m_bb[this.m_position++] & 0xFF) << 0;
    }

    @Override
    public final long readLong() throws IOException {
        this.ensureRead(8);
        return ((long)this.m_bb[this.m_position++] & 0xFFL) << 56 | ((long)this.m_bb[this.m_position++] & 0xFFL) << 48 | ((long)this.m_bb[this.m_position++] & 0xFFL) << 40 | ((long)this.m_bb[this.m_position++] & 0xFFL) << 32 | ((long)this.m_bb[this.m_position++] & 0xFFL) << 24 | ((long)this.m_bb[this.m_position++] & 0xFFL) << 16 | ((long)this.m_bb[this.m_position++] & 0xFFL) << 8 | ((long)this.m_bb[this.m_position++] & 0xFFL) << 0;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final int readVUnsignedInt() throws IOException {
        boolean directReading = this.remaining() > 3;
        int number = 0;
        byte b = 0;
        int shiftDigits = 0;
        do {
            b = directReading ? this.m_bb[this.m_position++] : this.readByte();
            number |= (b & 0x7F) << shiftDigits;
        } while ((shiftDigits += 7) < 28 && (b & 0x80) != 0);
        return number;
    }

    @Override
    public final long readVUnsignedLong() throws IOException {
        boolean directReading = this.remaining() > 7;
        long number = 0L;
        long b = 0L;
        int shiftDigits = 0;
        do {
            b = directReading ? (long)this.m_bb[this.m_position++] : (long)this.readByte();
            number |= (b & 0x7FL) << shiftDigits;
        } while ((shiftDigits += 7) < 56 && (b & 0x80L) != 0L);
        return number;
    }

    @Override
    public void readInts(int[] array) throws IOException {
        int c = array.length;
        this.ensureRead(4 * c);
        for (int i = 0; i < c; ++i) {
            array[i] = this.readIntInternal();
        }
    }

    @Override
    public void readUnsignedShorts(int[] array) throws IOException {
        int c = array.length;
        this.ensureRead(2 * c);
        for (int i = 0; i < c; ++i) {
            array[i] = (this.get() << 8 | this.get() & 0xFF) & 0xFFFF;
        }
    }

    @Override
    public void readUnsignedBytes(int[] array) throws IOException {
        int c = array.length;
        this.ensureRead(1 * c);
        for (int i = 0; i < c; ++i) {
            array[i] = this.get() & 0xFF;
        }
    }

    @Override
    public void readVUnsignedInts(int[] array) throws IOException {
        int len = array.length;
        this.ensureRead(len * 1);
        for (int i = 0; i < len; ++i) {
            array[i] = this.readVUnsignedInt();
        }
    }

    @Override
    public void readVUnsignedLongs(int[] array) throws IOException {
        int len = array.length;
        this.ensureRead(len * 1);
        for (int i = 0; i < len; ++i) {
            array[i] = (int)this.readVUnsignedLong();
        }
    }
}

