/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.io;

import com.mapinfo.mapmarker.cgge.utils.compress.StringCompressor;
import com.mapinfo.mapmarker.cgge.utils.io.BufferedDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.ByteArrayDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ByteArrayDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.CompressedDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.CompressedInputDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.ConcurrentDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.FileHandler;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEConcurrentDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import com.mapinfo.mapmarker.cgge.utils.io.MemoryMappedDataStream;
import java.io.File;
import java.io.IOException;

public class DataStreamFactory {
    public static int DEFAULT_MEMORY_MAP_SIZE = 0xA00000;

    public static ICGGEDataStream getDataStream(String filePath) throws IOException {
        return DataStreamFactory.getDataStream(filePath, IOUtil.IO_MODE.READ_ONLY, false);
    }

    public static ICGGEDataStream getCompressedDataStream(String filePath, IOUtil.IO_MODE mode, StringCompressor compressor) throws IOException {
        if (compressor == null) {
            throw new NullPointerException();
        }
        CompressedDataStream dataStream = new CompressedDataStream(new File(filePath), mode);
        dataStream.setCompressor(compressor);
        return dataStream;
    }

    public static ICGGEDataInputStream getCompressedDataInputStream(String filePath, StringCompressor compressor, int bufSize) throws IOException {
        if (compressor == null) {
            throw new NullPointerException();
        }
        FileHandler fileHandler = new FileHandler(new File(filePath));
        return new CompressedInputDataStream(fileHandler, compressor, bufSize);
    }

    public static ICGGEDataStream getCompressedDataStream(String filePath, IOUtil.IO_MODE mode, StringCompressor compressor, int bufSize) throws IOException {
        if (compressor == null) {
            throw new NullPointerException();
        }
        CompressedDataStream dataStream = new CompressedDataStream(new File(filePath), mode, bufSize);
        dataStream.setCompressor(compressor);
        return dataStream;
    }

    public static ICGGEDataStream getDataStream(String filePath, IOUtil.IO_MODE mode, boolean memoryMapped) throws IOException {
        return DataStreamFactory.getDataStream(new File(filePath), mode, memoryMapped);
    }

    public static ICGGEDataStream getDataStream(File file, IOUtil.IO_MODE mode, boolean memoryMapped) throws IOException {
        if (memoryMapped) {
            return new MemoryMappedDataStream(file, DEFAULT_MEMORY_MAP_SIZE);
        }
        return new BufferedDataStream(file, mode);
    }

    public static ICGGEDataStream getDataStream(File file, IOUtil.IO_MODE mode, boolean memoryMapped, int memoryMapSize) throws IOException {
        if (memoryMapped) {
            return new MemoryMappedDataStream(file, memoryMapSize);
        }
        return new BufferedDataStream(file, mode);
    }

    public static ICGGEDataStream getDataStream() throws IOException {
        return new ByteArrayDataStream(IOUtil.IO_MODE.READ_WRITE);
    }

    public static ByteArrayDataStream getByteArrayDataStream() throws IOException {
        return new ByteArrayDataStream(IOUtil.IO_MODE.READ_WRITE);
    }

    public static ICGGEDataInputStream getInputDataStream(String filePath) throws IOException {
        return DataStreamFactory.getInputDataStream(new File(filePath));
    }

    public static ICGGEDataInputStream getInputDataStream(File file) throws IOException {
        FileHandler fileHandler = new FileHandler(file);
        return new ByteArrayDataInputStream(fileHandler);
    }

    public static ICGGEConcurrentDataInputStream getConcurrentDataInputStream(String filePath) throws IOException {
        return new ConcurrentDataInputStream(new File(filePath));
    }

    public static ICGGEConcurrentDataInputStream getConcurrentDataInputStream(String filePath, int bufferSize, int numberOfCachedBuffers) throws IOException {
        return new ConcurrentDataInputStream(new File(filePath), bufferSize, numberOfCachedBuffers);
    }

    public static ICGGEDataInputStream getInputDataStream(byte[] bytes) throws IOException {
        return new ByteArrayDataStream(bytes, 0L);
    }
}

