/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.io;

import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public final class IOUtil {
    private static final int DATA_TYPE_EMPTY = 0;
    private static final int DATA_TYPE_BYTE = 1;
    private static final int DATA_TYPE_SHORT = 2;
    private static final int DATA_TYPE_INTEGER = 3;
    private static final int DATA_TYPE_LONG = 4;
    private static final int DATA_TYPE_CHAR = 5;
    private static final int DATA_TYPE_STRING = 6;
    private static final int DATA_TYPE_NIBBLE = 7;

    private IOUtil() {
    }

    public static final void writeSignedVLong(long v, DataOutput out) throws IllegalArgumentException, IOException {
        IOUtil.writeVUnsignedNumber(out, IOUtil.encodeSignedLong(v));
    }

    private static final long encodeSignedLong(long v) {
        return v << 1 ^ v >> 63;
    }

    private static final long decodeSignedLong(long v) {
        return (v & 1L) == 1L ? -(v >> 1) - 1L : v >> 1;
    }

    public static final long readSignedVLong(DataInput in) throws IOException {
        return IOUtil.decodeSignedLong(IOUtil.readVUnsignedNumber(in));
    }

    public static final void writeSignedVLongs(long[] values, DataOutput out) throws IllegalArgumentException, IOException {
        int len = values.length;
        IOUtil.writeVUnsignedNumber(out, len);
        for (int i = 0; i < len; ++i) {
            IOUtil.writeSignedVLong(values[i], out);
        }
    }

    public static final long[] readSignedVLongs(DataInput in) throws IOException {
        int len = (int)IOUtil.readVUnsignedNumber(in);
        long[] values = new long[len];
        for (int i = 0; i < len; ++i) {
            values[i] = IOUtil.readSignedVLong(in);
        }
        return values;
    }

    public static final long readVUnsignedNumber(DataInput in) throws IOException {
        long number = 0L;
        long b = 0L;
        int shiftDigits = 0;
        do {
            b = in.readByte();
            number |= (b & 0x7FL) << shiftDigits;
        } while ((b & 0x80L) == 128L && (shiftDigits += 7) < 56);
        return number;
    }

    public static final void writeVUnsignedNumber(DataOutput out, long number) throws IOException {
        byte[] bytes = IOUtil.toVBytes(number);
        out.write(bytes);
    }

    public static final byte[] toVBytes(int number) {
        if (number < 0 || number > ICGGEDataOutput.VUNSIGNED_INT_MAXVALUE) {
            throw new IllegalArgumentException();
        }
        return IOUtil.toVBytes(new byte[4], number);
    }

    public static final byte[] toVBytes(long number) {
        if (number < 0L || number > ICGGEDataOutput.VUNSIGNED_LONG_MAXVALUE) {
            throw new IllegalArgumentException();
        }
        return IOUtil.toVBytes(new byte[8], number);
    }

    private static final byte[] toVBytes(byte[] bytes, long number) {
        int added = 0;
        do {
            int b = (int)(number & 0x7FL);
            if ((number >>= 7) > 0L) {
                b |= 0x80;
            }
            bytes[added] = (byte)b;
            ++added;
        } while (number > 0L);
        if (added < 8) {
            return Arrays.copyOf(bytes, added);
        }
        return bytes;
    }

    public static void encodeAndWrite(String str, DataOutput out) throws IOException {
        int type = IOUtil.getBestPossibleType(str);
        if (type == 7) {
            type = Byte.parseByte(str) << 4 | type;
            out.write(type);
        } else {
            out.write(type);
            switch (type) {
                case 1: {
                    out.write(Byte.parseByte(str));
                    break;
                }
                case 2: {
                    out.writeShort(Short.parseShort(str));
                    break;
                }
                case 3: {
                    out.writeInt(Integer.parseInt(str));
                    break;
                }
                case 4: {
                    out.writeLong(Long.parseLong(str));
                    break;
                }
                case 5: {
                    out.writeChar(str.charAt(0));
                    break;
                }
                case 6: {
                    out.writeUTF(str);
                }
            }
        }
    }

    public static String readAndDecode(DataInput in) throws IOException {
        int type = in.readUnsignedByte();
        switch (type & 0xF) {
            case 7: {
                return Integer.toString(type >> 4 & 0xF);
            }
            case 1: {
                return Byte.toString(in.readByte());
            }
            case 2: {
                return Short.toString(in.readShort());
            }
            case 3: {
                return Integer.toString(in.readInt());
            }
            case 4: {
                return Long.toString(in.readLong());
            }
            case 5: {
                return "" + in.readChar();
            }
            case 6: {
                return in.readUTF();
            }
        }
        return "";
    }

    private static int getBestPossibleType(String str) {
        if (MMUtils.isEmpty(str)) {
            return 0;
        }
        try {
            long v = Long.parseLong(str);
            if (str.equals(Long.toString(v))) {
                if (v > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
                    return 4;
                }
                if (v > 32767L || v < -32768L) {
                    return 3;
                }
                if (v > 127L || v < -128L) {
                    return 2;
                }
                if (v >= 0L && v <= 15L) {
                    return 7;
                }
                return 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return str.length() == 1 ? 5 : 6;
    }

    public static enum IO_MODE {
        INVALID,
        READ_ONLY,
        READ_WRITE;

    }
}

