/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.utils.io;

import com.mapinfo.mapmarker.cgge.utils.io.BufferedDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MemoryMappedDataStream
extends BufferedDataStream {
    public MemoryMappedDataStream(File file, int bufSize) throws IOException {
        super(file, IOUtil.IO_MODE.READ_ONLY, bufSize);
    }

    public MemoryMappedDataStream(File file, IOUtil.IO_MODE mode, int bufSize) throws IOException {
        super(file, mode, bufSize);
    }

    @Override
    ByteBuffer initNewBuffer(int bufferSize) throws IOException {
        RandomAccessFile file = this.getFile();
        int mapSize = this.getMapSize(file);
        MappedByteBuffer map = file.getChannel().map(this.getMapMode(), file.getFilePointer(), mapSize);
        map.limit(mapSize);
        return map;
    }

    private int getMapSize(RandomAccessFile file) throws IOException {
        long remaining;
        int mapSize = this.getCapacity();
        if (this.getMode() == IOUtil.IO_MODE.READ_ONLY && (remaining = file.length() - file.getFilePointer()) < (long)mapSize) {
            mapSize = (int)remaining;
        }
        return mapSize;
    }

    private FileChannel.MapMode getMapMode() {
        IOUtil.IO_MODE mode = this.getMode();
        switch (mode) {
            case READ_WRITE: {
                return FileChannel.MapMode.READ_WRITE;
            }
        }
        return FileChannel.MapMode.READ_ONLY;
    }
}

