/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.oracle;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSource;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDataSource
extends JDBCDataSource {
    public static Logger logger = LoggerFactory.getLogger(OracleDataSource.class);

    public OracleDataSource(Properties properties) {
        super(properties);
    }

    protected OracleConnection getConnection(String url, String user, String password) throws SQLException, DataSourceException {
        int i;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException CNFEx) {
            throw new DataSourceException(11, (Throwable)CNFEx);
        }
        int iterations = 1;
        SQLException SQLEx = null;
        OracleConnection conn = null;
        for (i = 0; i < iterations && conn == null; ++i) {
            try {
                conn = (OracleConnection)DriverManager.getConnection(url, user, password);
                continue;
            }
            catch (SQLException SQLEx1) {
                if (SQLEx == null) {
                    SQLEx = SQLEx1;
                }
                conn = null;
            }
        }
        if (conn == null) {
            throw SQLEx;
        }
        if (i > 1) {
            logger.error("OracleDataSource -- Able to get connection after " + (i + 1) + " attempts");
        }
        return conn;
    }
}

