/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.dp.builder;

import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.builder.AbstractDataBuilder;
import com.mapinfo.mapmarker.autosuggest.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBRDataBuilder
extends DataBuilder {
    static final Logger logger = LoggerFactory.getLogger(GBRDataBuilder.class);

    @Override
    protected void addWord(Map<String, AddressPtrMap> wordMap, String str, int fieldType, AddressPtr addrPtr) {
        String stdStr;
        super.addWord(wordMap, str, fieldType, addrPtr);
        str = StringNormalizer.normalise(str);
        if (!MMUtils.isEmpty((String)str) && !MMUtils.isEmpty((String)(stdStr = this.getAltKeyGenerator().standardise(str, fieldType))) && fieldType == 15) {
            AddressPtr addressPtrCpy = addrPtr.copy();
            String postCodeWithoutSpace = stdStr.replaceAll("\\s+", "");
            this.addWord0(wordMap, postCodeWithoutSpace, fieldType, addressPtrCpy);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            logger.debug("XXX_DataBuilder.properties file was not specified as arg[0]");
            System.exit(1);
        }
        GBRDataBuilder builder = new GBRDataBuilder();
        try {
            Properties prop = builder.initProperties(args);
            String dataName = AbstractDataBuilder.getRequiredPropertyValue(prop, "dataName");
            String outPath = AbstractDataBuilder.getRequiredPropertyValue(prop, "outputPath");
            builder.createDictionary(dataName, outPath, prop);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

