/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.IAddressPtrFilter;
import com.mapinfo.mapmarker.autosuggest.dp.NumberRangeHasher;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;

public class AddrNumHashFilter
implements IAddressPtrFilter {
    private NumberRangeHasher m_numberRangeHasher = new NumberRangeHasher();
    private int m_addrNum;
    private byte m_addrNumHash;

    public AddrNumHashFilter(int addrNum) {
        this.m_addrNum = addrNum;
        this.m_addrNumHash = this.m_numberRangeHasher.hash(new NumberRange(addrNum, addrNum));
    }

    @Override
    public boolean allowAddressPtr(AddressPtr addrPtr) {
        byte rangeHash = addrPtr.getAreaAddrNumberRangeHash();
        return this.m_numberRangeHasher.intersects(rangeHash, this.m_addrNumHash);
    }

    public int getAddressNumber() {
        return this.m_addrNum;
    }
}

