/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.TokenStandardiser;
import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleUnit;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressFieldPrefixMatcher {
    private static final Logger LOG = LoggerFactory.getLogger((String)AddressFieldPrefixMatcher.class.getName());
    private final List<Integer> m_allowedFields;
    private final List<Integer> m_ignoreFields;
    private final String m_matchSubString;
    private final String[] m_matchAltWords;
    private final TokenStandardiser m_tokenStandardiser;

    public AddressFieldPrefixMatcher(List<Integer> allowedFields, List<Integer> ignoredFields, String matchSubString) {
        this(allowedFields, ignoredFields, matchSubString, null, null);
    }

    public AddressFieldPrefixMatcher(List<Integer> allowedFields, List<Integer> ignoredFields, String matchSubString, String[] matchAltWords, TokenStandardiser tokenStandardiser) {
        this.m_allowedFields = allowedFields;
        this.m_ignoreFields = ignoredFields;
        this.m_matchSubString = matchSubString;
        this.m_tokenStandardiser = tokenStandardiser;
        this.m_matchAltWords = matchAltWords;
    }

    List<Integer> getAllowedFields() {
        return this.m_allowedFields;
    }

    List<Integer> getIgnoredFields() {
        return this.m_ignoreFields;
    }

    public int getPrefixLength() {
        return this.m_matchSubString.length();
    }

    public FieldMatchInfo getMatchedFieldInfo(SimpleAddress addr, int matchStartNdx) {
        FieldMatchInfo fieldMatchInfo;
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("getMatchedFieldInfo(");
            if (addr == null) {
                sb.append("null");
            } else if (addr.getFields() != null) {
                ArrayList<Integer> l = new ArrayList<Integer>(addr.getFields().keySet());
                Collections.sort(l);
                sb.append(Arrays.toString(l.toArray()));
            } else {
                sb.append("?");
            }
            sb.append(")");
            LOG.debug(sb.toString());
        }
        if ((fieldMatchInfo = this.getMatchedFieldInfo(matchStartNdx, addr)) == null) {
            fieldMatchInfo = this.getMatchedFieldInfoFromMatchingRangeOrUnit(addr.getRanges(), matchStartNdx);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("getMatchedFieldInfo(");
            if (addr == null) {
                sb.append("null");
            } else if (addr.getFields() != null) {
                ArrayList<Integer> l = new ArrayList<Integer>(addr.getFields().keySet());
                Collections.sort(l);
                sb.append(Arrays.toString(l.toArray()));
            } else {
                sb.append("?");
            }
            sb.append("): found ");
            if (fieldMatchInfo == null) {
                sb.append("null");
            } else {
                sb.append(fieldMatchInfo.getMatchedString());
            }
            LOG.debug(sb.toString());
        }
        return fieldMatchInfo;
    }

    private FieldMatchInfo getMatchedFieldInfoFromMatchingRangeOrUnit(List<SimpleRange> rangeList, int matchStartNdx) {
        FieldMatchInfo fieldMatchInfo = null;
        if (rangeList != null) {
            for (SimpleRange simpleRange : rangeList) {
                SimpleUnit simpleUnit;
                List<SimpleUnit> simpleUnits;
                if (fieldMatchInfo != null) break;
                fieldMatchInfo = this.getMatchedFieldInfo(matchStartNdx, simpleRange);
                if (fieldMatchInfo != null || (simpleUnits = simpleRange.getUnits()) == null) continue;
                Iterator<SimpleUnit> iterator = simpleUnits.iterator();
                while (iterator.hasNext() && (fieldMatchInfo = this.getMatchedFieldInfo(matchStartNdx, simpleUnit = iterator.next())) == null) {
                }
            }
        }
        return fieldMatchInfo;
    }

    private FieldMatchInfo getMatchedFieldInfo(int matchStartNdx, InternalSimpleAddress internalSimpleAddress) {
        Map<Integer, List<String>> fieldMap;
        FieldMatchInfo fieldMatchInfo = null;
        if (internalSimpleAddress != null && (fieldMap = internalSimpleAddress.getFields()) != null) {
            for (Map.Entry<Integer, List<String>> fieldEn : fieldMap.entrySet()) {
                int matchedFieldValueNdx;
                Integer fieldID = fieldEn.getKey();
                if (!this.canMatchField(fieldID) || (matchedFieldValueNdx = this.getMatchingPrefixFieldNdx(fieldEn.getValue(), this.m_matchSubString, this.m_matchAltWords)) <= -1) continue;
                fieldMatchInfo = new FieldMatchInfo(fieldID, this.m_matchSubString, matchStartNdx, matchedFieldValueNdx);
                break;
            }
        }
        return fieldMatchInfo;
    }

    private int getMatchingPrefixFieldNdx(List<String> fieldValues, String prefix, String[] altWords) {
        if (fieldValues != null) {
            int n = fieldValues.size();
            for (int i = 0; i < n; ++i) {
                String fv = this.getNormalizedFieldValue(fieldValues.get(i));
                if (fv == null) continue;
                if (this.fieldMatchPrefix(fv, prefix, altWords)) {
                    return i;
                }
                if (this.m_tokenStandardiser == null || !this.fieldMatchPrefix(fv = this.m_tokenStandardiser.standardiseWord(fv.toUpperCase(), null), prefix, altWords)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean fieldMatchPrefix(String fieldValue, String prefix, String[] altWords) {
        if (this.startsWith(fieldValue, prefix, false)) {
            return true;
        }
        if (altWords != null) {
            for (String altWord : altWords) {
                if (!this.startsWith(fieldValue, altWord, true)) continue;
                return true;
            }
        }
        return false;
    }

    public int getMatchingPrefixFieldNdx(List<String> fieldValues, String prefix, boolean matchFully) {
        if (LOG.isDebugEnabled() && fieldValues != null) {
            LOG.debug(String.format("getMatchingPrefixFieldNdx(%s, '%s')", Arrays.toString(fieldValues.toArray()), prefix));
        }
        int n = fieldValues.size();
        int index = -1;
        for (int i = 0; i < n; ++i) {
            boolean matched;
            String fv = this.getNormalizedFieldValue(fieldValues.get(i));
            if (fv == null) continue;
            boolean bl = matched = matchFully ? prefix.equals(fv) : fv.startsWith(prefix);
            if (!matched && this.m_tokenStandardiser != null) {
                fv = this.m_tokenStandardiser.standardiseString(fv);
                boolean bl2 = matched = matchFully ? prefix.equals(fv) : fv.startsWith(prefix);
            }
            if (!matched) continue;
            index = i;
            break;
        }
        if (LOG.isDebugEnabled() && fieldValues != null) {
            LOG.debug(String.format("getMatchingPrefixFieldNdx(%s, '%s'): %d", Arrays.toString(fieldValues.toArray()), prefix, index));
        }
        return index;
    }

    private boolean startsWith(String str, String prefix, boolean matchWholeWord) {
        int unmatchedLen;
        int prefixLen = prefix.length();
        int strLen = str.length();
        if (str.length() >= unmatchedLen) {
            int checkNdx;
            for (unmatchedLen = prefixLen; unmatchedLen > 0 && Character.toUpperCase(str.charAt(checkNdx = unmatchedLen - 1)) == prefix.charAt(checkNdx); --unmatchedLen) {
            }
        }
        if (matchWholeWord && unmatchedLen == 0) {
            return strLen > prefixLen ? str.charAt(prefixLen) == ' ' : true;
        }
        return unmatchedLen == 0;
    }

    private boolean canMatchField(Integer fieldID) {
        if (!ListUtils.isEmpty(this.m_allowedFields) && !this.m_allowedFields.contains(fieldID)) {
            return false;
        }
        return ListUtils.isEmpty(this.m_ignoreFields) || !this.m_ignoreFields.contains(fieldID);
    }

    private String getNormalizedFieldValue(String fv) {
        return fv == null ? null : StringNormalizer.normalise(fv);
    }
}

