/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddrNumHashFilter;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.IAddressFilter;
import com.mapinfo.mapmarker.autosuggest.RangeFilter;
import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AddressFilter
implements IAddressFilter {
    private static final int MATCH_ALL_AVAILABLE_FIELDS = -1;
    private AddressSearchInternalResult m_addrSearchInternalResult;
    private AddressMetaData m_metaData;
    private boolean m_groupAreaCands = false;
    private RangeFilter m_rangeFilter = null;
    private SearchResult m_searchResult;
    private HNRObject m_hnrObj;
    private int m_matchedFieldID;

    public AddressFilter(AddressSearchInternalResult addrSearchInternalResult, AddressMetaData metaData) {
        this.m_addrSearchInternalResult = addrSearchInternalResult;
        this.m_metaData = metaData;
    }

    @Override
    public boolean acceptAddress(SimpleAddress addr) {
        Rectangle bounds = this.getSearchBounds();
        if (bounds != null) {
            return this.inSearchBounds(addr, bounds);
        }
        return true;
    }

    boolean inSearchBounds(SimpleAddress addr, Rectangle bounds) {
        double[] points = addr.getGeomtry();
        if (points != null) {
            return this.inSearchBounds(points, bounds);
        }
        Rectangle addrBounds = addr.getBounds();
        if (addrBounds != null) {
            return bounds.intersects(addrBounds);
        }
        double[] centroid = addr.getCentroid();
        if (centroid != null) {
            return bounds.pointInRect(centroid[0], centroid[1]);
        }
        return true;
    }

    public Rectangle getSearchBounds() {
        return this.m_searchResult.getSearchRequest().getSearchBounds();
    }

    private boolean inSearchBounds(double[] points, Rectangle bounds) {
        int nPoints = points == null ? 0 : points.length / 2;
        for (int i = 0; i < nPoints; ++i) {
            if (!bounds.pointInRect(points[i], points[i + 1])) continue;
            return true;
        }
        return false;
    }

    private void setRangeFilter(HNRObject hnrObj, AddressSearchInternalResult addrSearchInternalResult) {
        AddressSearchInternalResult realInternalResult = addrSearchInternalResult.getRealResult();
        SearchResult sr = realInternalResult.getSearchResult();
        RangeFilter rangeFilter = new RangeFilter(realInternalResult.getMatchedFieldType(), sr.getWord(), hnrObj == null ? -1 : hnrObj.m_hnr, this.getAddressMetaData());
        rangeFilter.setAcceptonlyHNRInRange(!addrSearchInternalResult.isFallbackResult());
        this.setRangeFilter(rangeFilter);
    }

    @Override
    public void setRangeFilter(RangeFilter rangeFilter) {
        this.m_rangeFilter = rangeFilter;
    }

    @Override
    public RangeFilter getRangeFilter() {
        return this.m_rangeFilter;
    }

    @Override
    public SearchResult getSearchResult() {
        return this.m_searchResult;
    }

    boolean matchedOnAreaFieldsOnly(AddressSearchInternalResult searchResult, AddressMetaData addrMetaData) {
        List<Integer> matchedFieldTypes = searchResult.getMatchedFieldTypes();
        for (Integer field : matchedFieldTypes) {
            if (addrMetaData.isAreaField(field)) continue;
            return false;
        }
        return true;
    }

    boolean initFilter(boolean singleCandOnAreaOnlyMatch) {
        AddressSearchInternalResult realInternalResult = this.m_addrSearchInternalResult.getRealResult();
        if (realInternalResult != null) {
            this.setMatchedFieldID(realInternalResult.getSearchedField());
            SearchResult searchResult = realInternalResult.getSearchResult();
            this.setSearchResult(searchResult);
            HNRObject hnrObject = null;
            if (singleCandOnAreaOnlyMatch && this.matchedOnAreaFieldsOnly(this.m_addrSearchInternalResult, this.m_metaData)) {
                this.m_groupAreaCands = true;
                if (!this.m_addrSearchInternalResult.isPsuedoResult()) {
                    this.groupResultByArea(searchResult, this.m_addrSearchInternalResult.getMatchedFieldType());
                }
            } else {
                this.m_groupAreaCands = singleCandOnAreaOnlyMatch;
                hnrObject = this.makeHNRObj(this.m_addrSearchInternalResult);
                this.setHNRObject(hnrObject);
            }
            this.setRangeFilter(hnrObject, this.m_addrSearchInternalResult);
            return true;
        }
        return false;
    }

    void setMatchedFieldID(int matchedFieldType) {
        this.m_matchedFieldID = matchedFieldType;
    }

    @Override
    public int getMatchedFieldID() {
        return this.m_matchedFieldID;
    }

    @Override
    public boolean filterSearchResultForDistanceBand(int minDistance, int maxDistance, SearchAreas searchAreas) {
        if (searchAreas != null && maxDistance > minDistance) {
            SearchResult searchResult = null;
            searchResult = this.getSearchResult();
            AddressPtrMap addrPtrMap = this.filterAddressPtrsOutSideSearchBounds(searchAreas, searchResult.getAddressPtrMap(), this.getMatchedFieldID());
            searchResult = addrPtrMap == null ? null : searchResult.copy(addrPtrMap);
            this.setSearchResult(searchResult);
            return true;
        }
        return false;
    }

    private AddressPtrMap filterAddressPtrsOutSideSearchBounds(SearchAreas searchAreas, AddressPtrMap addrPtrMap, int matchField) {
        AddressPtrMap retainedMap = new AddressPtrMap();
        if (matchField == -1) {
            for (Map.Entry<Integer, List<AddressPtr>> en : addrPtrMap.getEntrySet()) {
                List<AddressPtr> retainedList = searchAreas.retainAvailableAreas((Collection<AddressPtr>)en.getValue());
                if (retainedList.isEmpty()) continue;
                retainedMap.addAll(en.getKey(), retainedList);
            }
        } else {
            List<AddressPtr> retainedList;
            List<AddressPtr> addrPtrList = addrPtrMap.find(matchField);
            if (addrPtrList != null && !(retainedList = searchAreas.retainAvailableAreas(addrPtrList)).isEmpty()) {
                retainedMap.addAll(matchField, retainedList);
            }
        }
        return retainedMap.size() == 0 ? null : retainedMap;
    }

    @Override
    public boolean filterAddressPtrsForMatchingRange() {
        RangeFilter rangeFilter = this.getRangeFilter();
        if (rangeFilter != null && rangeFilter.isAcceptOnlyHNRInRange()) {
            AddrNumHashFilter addrNumFilter = this.getAddressNumberHashFilter(rangeFilter.getHNR());
            SearchResult searchResult = this.getSearchResult();
            AddressPtrMap filteredAddrPtrMap = this.filterForAddressesWithMatchingRanges(searchResult.getAddressPtrMap(), this.getMatchedFieldID(), addrNumFilter);
            searchResult = filteredAddrPtrMap == null ? null : searchResult.copy(filteredAddrPtrMap);
            this.setSearchResult(searchResult);
            return searchResult != null;
        }
        return true;
    }

    AddrNumHashFilter getAddressNumberHashFilter(int addrNum) {
        return new AddrNumHashFilter(addrNum);
    }

    private AddressPtrMap filterForAddressesWithMatchingRanges(AddressPtrMap addrPtrMap, int fieldID, AddrNumHashFilter addrNumFilter) {
        AddressPtrMap filteredMap = new AddressPtrMap();
        if (fieldID > -1) {
            List<AddressPtr> filteredAddrPtr = this.filterList(addrPtrMap, fieldID, addrNumFilter);
            if (filteredAddrPtr != null) {
                filteredMap.addAll(fieldID, filteredAddrPtr);
            }
        } else {
            for (int currFieldID : addrPtrMap.getFields()) {
                List<AddressPtr> filteredAddrPtr = this.filterList(addrPtrMap, currFieldID, addrNumFilter);
                if (filteredAddrPtr == null) continue;
                filteredMap.addAll(currFieldID, filteredAddrPtr);
            }
        }
        return filteredMap.size() > 0 ? filteredMap : null;
    }

    private List<AddressPtr> filterList(AddressPtrMap addrPtrMap, int fieldID, AddrNumHashFilter addrNumFilter) {
        List<AddressPtr> currentList = addrPtrMap.find(fieldID);
        if (currentList != null) {
            ArrayList<AddressPtr> newList = new ArrayList<AddressPtr>(currentList.size());
            for (AddressPtr addrPtr : currentList) {
                if (!addrNumFilter.allowAddressPtr(addrPtr)) continue;
                newList.add(addrPtr);
            }
            return newList.isEmpty() ? null : newList;
        }
        return null;
    }

    void setSearchResult(SearchResult searchResult) {
        this.m_searchResult = searchResult;
    }

    void setHNRObject(HNRObject hnrObject) {
        this.m_hnrObj = hnrObject;
    }

    @Override
    public String getHNRString() {
        return this.m_hnrObj == null ? null : this.m_hnrObj.m_hnrStr;
    }

    void groupResultByArea(SearchResult searchResult, int fieldID) {
        List<AddressPtr> addrPtrList = searchResult.getAddressPtrMap().find(fieldID);
        int c = addrPtrList.size();
        for (int i = 0; i < c; ++i) {
            AddressPtr addrPtr = addrPtrList.get(i);
            AddressPtr addrPtrCopy = new AddressPtr(addrPtr.getAreaID());
            addrPtrCopy.addAddressID(addrPtr.getFirstAddressID());
            addrPtrList.set(i, addrPtrCopy);
        }
    }

    HNRObject makeHNRObj(AddressSearchInternalResult addrSearchRes) {
        HNRObject hnrObj = null;
        String hnrStr = addrSearchRes.getHnr();
        if (hnrStr != null) {
            int hnr = 0;
            String prefix = MMUtils.getStartingNumberPart((String)hnrStr);
            if (prefix != null) {
                hnr = Integer.parseInt(prefix);
            }
            hnrObj = new HNRObject(hnrStr, hnr);
        }
        return hnrObj;
    }

    @Override
    public AddressMetaData getAddressMetaData() {
        return this.m_metaData;
    }

    @Override
    public boolean groupAreaRecords() {
        return this.m_groupAreaCands;
    }

    @Override
    public boolean hasPossibleResults() {
        return this.getSearchResult() != null;
    }

    static class HNRObject {
        final String m_hnrStr;
        final int m_hnr;

        HNRObject(String hnrStr, int hnr) {
            this.m_hnrStr = hnrStr;
            this.m_hnr = hnr;
        }
    }
}

