/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressSearchHandler;
import com.mapinfo.mapmarker.autosuggest.SearchInput;
import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.utils.LinkedTailItem;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class AddressSearchInternalResult
extends LinkedTailItem
implements Comparable<AddressSearchInternalResult> {
    protected static final Integer HNR_FIELD = FieldType.ADDRESS_NUMBER_FIELD_TYPE.getKey();
    protected static final Integer STREET_FIELD = FieldType.STREET_NAME_FIELD_TYPE.getKey();
    private final int m_searchWordEnd;
    private final int m_searchWordLen;
    private final int m_matchedField;
    private final SearchResult m_result;
    private final SearchInput m_searchInput;
    private boolean m_fallBackResult;
    private int m_searchedFieldID;
    private int m_matchWeight = -1;

    AddressSearchInternalResult(int searchEnd, SearchResult searchResult, int fieldID, int searchWordLen, SearchInput searchInput) {
        super(null);
        this.m_searchWordEnd = searchEnd;
        this.m_result = searchResult;
        this.m_searchWordLen = searchWordLen;
        this.m_searchedFieldID = this.m_matchedField = fieldID;
        this.m_fallBackResult = false;
        this.m_searchInput = searchInput;
        this.m_matchWeight = -1;
    }

    AddressSearchInternalResult copy() {
        return this.copy(this.m_result);
    }

    AddressSearchInternalResult copy(SearchResult searchResult) {
        if (this.isHNRMatchResult()) {
            return AddressSearchInternalResult.getHNRResultInstance(this.getSearchWordEnd(), this.getHnr(), this.getPreviousResult(), this.getSearchInput());
        }
        if (this.isPsuedoResult()) {
            return AddressSearchInternalResult.getPsuedoResultInstance(this.getSearchWords(), this.getSearchWordEnd(), searchResult, this.getPreviousResult(), this.getSearchInput());
        }
        AddressSearchInternalResult copy = new AddressSearchInternalResult(this.m_searchWordEnd, searchResult, this.m_matchedField, this.m_searchWordLen, this.m_searchInput);
        copy.setPrevious(this.getPreviousResult());
        copy.m_fallBackResult = this.isFallbackResult();
        return copy;
    }

    static AddressSearchInternalResult getHNRResultInstance(int searchEnd, String hnr, AddressSearchInternalResult prevSearchResult, SearchInput searchInput) {
        if (searchInput == null) {
            throw new NullPointerException();
        }
        return new HNRResult(searchEnd, hnr, prevSearchResult, searchInput);
    }

    static AddressSearchInternalResult getExtendedHNRResultInstance(int searchEnd, String hnr, AddressSearchInternalResult prevSearchResult, SearchInput searchInput) {
        if (searchInput == null) {
            throw new NullPointerException();
        }
        return new HNRResult(searchEnd, hnr, prevSearchResult, searchInput, true);
    }

    static AddressSearchInternalResult getPsuedoResultInstance(String[] searchWords, int searchEnd, SearchResult searchResult, AddressSearchInternalResult prevSearchResult, SearchInput searchInput) {
        PsuedoResult psuedoResult = new PsuedoResult(searchEnd, searchResult, -1, searchResult.getWord().length(), searchWords, searchInput);
        psuedoResult.setPrevious(prevSearchResult);
        return psuedoResult;
    }

    public void setPrevious(AddressSearchInternalResult previous) {
        super.setPrevious(previous);
        if (previous != null) {
            this.setFallbackResult(previous.isFallbackResult());
        }
        this.m_matchWeight = -1;
    }

    int getWordMatchLen() {
        return this.m_searchWordLen;
    }

    int getMatchWeight() {
        if (this.m_matchWeight == -1) {
            this.calculateAndSetMatchWeight();
        }
        return this.m_matchWeight;
    }

    List<AddressPtr> getAddressPtrs() {
        return this.isPsuedoResult() ? null : this.m_result.getAddressPtrMap().find(this.m_searchedFieldID);
    }

    AddressSearchInternalResult getPreviousResult() {
        return (AddressSearchInternalResult)this.previous();
    }

    int getSearchWordEnd() {
        return this.m_searchWordEnd;
    }

    SearchResult getSearchResult() {
        return this.m_result;
    }

    int getMatchedFieldType() {
        return this.m_matchedField;
    }

    List<Integer> getMatchedFieldTypes() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (AddressSearchInternalResult current = this; current != null; current = current.getPreviousResult()) {
            if (current.isPsuedoResult()) continue;
            types.add(current.getMatchedFieldType());
        }
        return types;
    }

    boolean containsFieldMatch(int fieldID) {
        for (AddressSearchInternalResult current = this; current != null; current = current.getPreviousResult()) {
            if (current.getMatchedFieldType() != fieldID) continue;
            return true;
        }
        return false;
    }

    boolean isPsuedoResult() {
        return false;
    }

    boolean isHNRMatchResult() {
        return false;
    }

    boolean isExtendedHNRMatchResult() {
        return false;
    }

    boolean hasNonHNRMatch() {
        return this.getNonHNRResult() != null;
    }

    AddressSearchInternalResult getNonHNRResult() {
        for (AddressSearchInternalResult current = this; current != null; current = (AddressSearchInternalResult)current.previous()) {
            if (current.isHNRMatchResult()) continue;
            return current;
        }
        return null;
    }

    boolean hasHNRMatch() {
        for (AddressSearchInternalResult current = this; current != null; current = (AddressSearchInternalResult)current.previous()) {
            if (!current.isHNRMatchResult()) continue;
            return true;
        }
        return false;
    }

    String getHnr() {
        for (AddressSearchInternalResult current = this; current != null; current = (AddressSearchInternalResult)current.previous()) {
            if (!current.isHNRMatchResult()) continue;
            return current.getHnr();
        }
        return null;
    }

    int getMatchedLen() {
        int prevMatchEnd = AddressSearchHandler.calculateLastSearchWordEnd(this.getPreviousResult(), this.getSearchInput());
        return this.getSearchWordEnd() - prevMatchEnd;
    }

    void setFilterList(SearchRequest sr) {
        if (this.isHNRMatchResult()) {
            AddressSearchInternalResult previous = (AddressSearchInternalResult)this.previous();
            if (previous != null) {
                previous.setFilterList(sr);
            }
            if (!this.containsFieldMatch(STREET_FIELD)) {
                sr.setAllowedTypes(Arrays.asList(STREET_FIELD));
            }
        } else {
            List<Integer> ignoreList = this.getMatchedFieldTypes();
            List<Integer> currIgnoreList = sr.getIgnoreTypes();
            if (currIgnoreList != null) {
                ignoreList.addAll(currIgnoreList);
            }
            sr.setIgnoreTypes(ignoreList);
            sr.appendAllowedAddressPtrList(this.getAddressPtrs());
        }
    }

    int countProbableResults() {
        int probableAddressCount = 0;
        List<AddressPtr> addrPtrs = this.getAddressPtrs();
        if (addrPtrs != null) {
            for (AddressPtr addrPtr : addrPtrs) {
                probableAddressCount += addrPtr.getAddressIDCount();
            }
        }
        return probableAddressCount;
    }

    boolean hasMoreResultsThanMinimum(int min) {
        int probableAddressCount = 0;
        List<AddressPtr> addrPtrs = this.getAddressPtrs();
        if (addrPtrs != null) {
            for (AddressPtr addrPtr : addrPtrs) {
                if ((probableAddressCount += addrPtr.getAddressIDCount()) <= min) continue;
                return true;
            }
        }
        return false;
    }

    String[] getSearchWords() {
        return null;
    }

    boolean hasMoreAddress() {
        SearchResult sr = this.getRealResult().getSearchResult();
        return !ListUtils.isEmpty(sr.getAddressPtrMap().find(this.m_matchedField));
    }

    AddressSearchInternalResult getRealResult() {
        AddressSearchInternalResult result = this;
        if (result.isPsuedoResult()) {
            result = this.getPreviousResult();
        }
        return result.getNonHNRResult();
    }

    boolean isFallbackResult() {
        return this.m_fallBackResult;
    }

    void setFallbackResult(boolean fallback) {
        this.m_fallBackResult = fallback;
    }

    void setSearchedField(int searchedFieldID) {
        this.m_searchedFieldID = searchedFieldID;
    }

    int getSearchedField() {
        return this.m_searchedFieldID;
    }

    String getMatchedString() {
        return this.m_result == null ? null : this.m_result.getWord();
    }

    private void calculateAndSetMatchWeight() {
        AddressSearchInternalResult previous = this.getPreviousResult();
        int currWeight = this.getInternalMatchWeight();
        if (previous != null) {
            int previousWeight = previous.getMatchWeight();
            if (previousWeight == 100 && currWeight == 100) {
                this.m_matchWeight = 100;
            } else {
                int totalMatchLen = this.getSearchWordEnd();
                int previousMatchLen = this.getPreviousResult().getSearchWordEnd();
                int combinedScore = previousWeight * previousMatchLen + currWeight * (totalMatchLen - previousMatchLen);
                this.m_matchWeight = combinedScore / totalMatchLen;
            }
        } else {
            this.m_matchWeight = currWeight;
        }
    }

    int getInternalMatchWeight() {
        return this.m_result == null ? 0 : this.m_result.getMatchWeight();
    }

    public boolean isFullInputMatch() {
        return this.m_result != null && this.m_result.isFullInputMatch();
    }

    public SearchInput getSearchInput() {
        return this.m_searchInput;
    }

    @Override
    public int compareTo(AddressSearchInternalResult o) {
        boolean isFullMatch = this.isFullInputMatch();
        if (isFullMatch == o.isFullInputMatch()) {
            boolean isHnrResult;
            int c = this.getMatchWeight() - o.getMatchWeight();
            if (c == 0) {
                c = this.compareExtendedHNR(o);
            }
            if (c == 0) {
                c = this.compareMatchedWordLen(o);
            }
            if (c == 0 && (isHnrResult = this.isHNRMatchResult()) != o.isHNRMatchResult()) {
                return isHnrResult ? 1 : -1;
            }
            return c;
        }
        if (isFullMatch) {
            return 1;
        }
        return -1;
    }

    private int compareExtendedHNR(AddressSearchInternalResult o) {
        boolean otherIsExtHnrMatch;
        boolean isExtHnrMatch = this.isExtendedHNRMatchResult();
        if (isExtHnrMatch != (otherIsExtHnrMatch = o.isExtendedHNRMatchResult())) {
            int prevC = 0;
            AddressSearchInternalResult p1 = this.getPreviousResult();
            AddressSearchInternalResult p2 = o.getPreviousResult();
            if (p1 != null && p2 != null) {
                prevC = p1.compareTo(p2);
            }
            if (isExtHnrMatch && prevC <= 0) {
                return -1;
            }
            if (otherIsExtHnrMatch && prevC >= 0) {
                return 1;
            }
        }
        return 0;
    }

    private int compareMatchedWordLen(AddressSearchInternalResult o) {
        SearchInput searchInput = this.getSearchInput();
        if (!searchInput.isSameInputField(o.getSearchInput())) {
            if (searchInput.isMainFieldInput()) {
                return 1;
            }
            return -1;
        }
        return this.getSearchWordEnd() - o.getSearchWordEnd();
    }

    public String toString() {
        return String.format("AddressSearchInternalResult(result: %s, searchedField: %d, matchedField: %d, searchWordEnd/Len: %d/%d matchWeight: %d)", this.m_result, this.m_searchedFieldID, this.m_matchedField, this.m_searchWordEnd, this.m_searchWordLen, this.m_matchWeight);
    }

    private static class HNRResult
    extends AddressSearchInternalResult {
        private final String m_hnr;
        private final boolean m_extendedHnr;

        HNRResult(int searchEnd, String hnr, AddressSearchInternalResult prevSearchResult, SearchInput searchInput) {
            super(searchEnd, null, HNR_FIELD, 0, searchInput);
            this.setPrevious(prevSearchResult);
            this.m_hnr = hnr;
            this.m_extendedHnr = false;
        }

        HNRResult(int searchEnd, String hnr, AddressSearchInternalResult prevSearchResult, SearchInput searchInput, boolean extHNR) {
            super(searchEnd, null, HNR_FIELD, 0, searchInput);
            this.setPrevious(prevSearchResult);
            this.m_hnr = hnr;
            this.m_extendedHnr = extHNR;
        }

        @Override
        boolean isHNRMatchResult() {
            return true;
        }

        @Override
        boolean isExtendedHNRMatchResult() {
            return this.m_extendedHnr;
        }

        @Override
        int getWordMatchLen() {
            return this.m_hnr.length();
        }

        @Override
        List<AddressPtr> getAddressPtrs() {
            return null;
        }

        @Override
        String getHnr() {
            return this.m_hnr;
        }

        @Override
        public boolean isFullInputMatch() {
            return this.getSearchInput().isOnLastWord();
        }

        @Override
        int getInternalMatchWeight() {
            return 100;
        }
    }

    private static class PsuedoResult
    extends AddressSearchInternalResult {
        private final String[] m_searchWords;

        PsuedoResult(int searchEnd, SearchResult searchResult, int fieldID, int searchWordLen, String[] searchWords, SearchInput searchInput) {
            super(searchEnd, searchResult, fieldID, searchWordLen, searchInput);
            this.m_searchWords = searchWords;
        }

        @Override
        boolean isPsuedoResult() {
            return true;
        }

        @Override
        List<AddressPtr> getAddressPtrs() {
            return null;
        }

        @Override
        String[] getSearchWords() {
            return this.m_searchWords;
        }

        @Override
        public boolean isFullInputMatch() {
            return true;
        }

        @Override
        int getInternalMatchWeight() {
            return 100;
        }
    }
}

