/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressSearchHandler;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.SearchInput;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.SearchResults;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.IAreaIDReadingFilter;
import com.mapinfo.mapmarker.autosuggest.utils.ArrayIterator;
import com.mapinfo.mapmarker.autosuggest.utils.IPeekableIterator;
import com.mapinfo.mapmarker.autosuggest.utils.IteratorUtils;
import com.mapinfo.mapmarker.autosuggest.utils.SubLevelIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class AddressSearchInternalResults
implements Iterable<AddressSearchInternalResult> {
    protected List<Object> m_internalList = new ArrayList<Object>();
    private List<IAreaIDReadingFilter> m_areaFilters;

    AddressSearchInternalResults() {
    }

    int internalItemCount() {
        return this.m_internalList.size();
    }

    void createAndAddNewInternalResult(SearchResults searchResults, AddressSearchInternalResult prevResult, SearchInput searchInput) {
        this.m_internalList.add(new SavedSearchResults(searchResults, prevResult, searchInput));
    }

    void add(AddressSearchInternalResult addrSearchInternalResult) {
        this.m_internalList.add(addrSearchInternalResult);
    }

    void addFirst(AddressSearchInternalResult addrSearchInternalResult) {
        this.m_internalList.add(0, addrSearchInternalResult);
    }

    void combine(AddressSearchInternalResults addrSearchInternalResults) {
        this.m_internalList.addAll(addrSearchInternalResults.m_internalList);
    }

    boolean isEmpty() {
        return this.m_internalList.isEmpty();
    }

    @Override
    public IPeekableIterator<AddressSearchInternalResult> iterator() {
        SubLevelIterator<Object, AddressSearchInternalResult, AddressSearchInternalResult> it;
        if (!this.m_internalList.isEmpty() && (it = new SubLevelIterator<Object, AddressSearchInternalResult, AddressSearchInternalResult>(){

            @Override
            public Iterator<AddressSearchInternalResult> getSubIterator(Object mainItem) {
                Iterator it = null;
                it = mainItem instanceof AddressSearchInternalResult ? ArrayIterator.iterator((AddressSearchInternalResult)mainItem) : AddressSearchInternalResults.this.makeResultsFromSearchResultIt((SavedSearchResults)mainItem);
                return it != null && it.hasNext() ? it : null;
            }

            @Override
            public AddressSearchInternalResult getItem(AddressSearchInternalResult subItem) {
                return subItem;
            }

            @Override
            public Iterator<Object> getMainIterator() {
                return AddressSearchInternalResults.this.m_internalList.iterator();
            }
        }).hasNext()) {
            return it;
        }
        return IteratorUtils.getEmptyPeekableIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.iterator() != null) {
            for (AddressSearchInternalResult result : this) {
                sb.append(result.getMatchedString());
                sb.append("=");
                sb.append(result.getAddressPtrs());
                sb.append(", ");
            }
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        return "AddressSearchInternalResult(" + sb.toString() + ")";
    }

    void setAreaFilters(List<IAreaIDReadingFilter> areaFilters) {
        this.m_areaFilters = areaFilters;
    }

    private List<IAreaIDReadingFilter> getAreaFilters() {
        return this.m_areaFilters;
    }

    private Iterator<AddressSearchInternalResult> makeResultsFromSearchResultIt(SavedSearchResults savedSearchResult) {
        return new AddressSearchInternalResultIt(savedSearchResult);
    }

    private final class AddressSearchInternalResultIt
    extends SubLevelIterator<SearchResult, Map.Entry<Integer, List<AddressPtr>>, AddressSearchInternalResult> {
        private SearchResult m_currSearchResult;
        private int m_searchEnd;
        private int m_matchLen;
        final int m_lastSearchEndNdx;
        final SavedSearchResults savedSearchResult;

        AddressSearchInternalResultIt(SavedSearchResults savedSearchResult) {
            this.savedSearchResult = savedSearchResult;
            this.m_lastSearchEndNdx = AddressSearchHandler.calculateLastSearchWordEnd(savedSearchResult.m_prevResult, savedSearchResult.m_searchInput);
        }

        @Override
        protected SearchResult nextMainItem() {
            SearchResult sr = (SearchResult)super.nextMainItem();
            if (sr != null) {
                this.m_matchLen = AddressSearchHandler.calculateMatchLength(sr.getWord(), this.savedSearchResult.m_searchInput, sr.getMatchedLen());
                this.m_searchEnd = this.m_lastSearchEndNdx + this.m_matchLen;
            }
            this.m_currSearchResult = sr;
            return sr;
        }

        @Override
        public Iterator<Map.Entry<Integer, List<AddressPtr>>> getSubIterator(SearchResult searchResult) {
            AddressPtrMap addrPtrMap = searchResult.getAddressPtrMap();
            if (addrPtrMap.size() > 0) {
                return addrPtrMap.getEntrySet().iterator();
            }
            List r = Collections.emptyList();
            return r.iterator();
        }

        @Override
        public AddressSearchInternalResult getItem(Map.Entry<Integer, List<AddressPtr>> addrPtrEn) {
            int fieldID = addrPtrEn.getKey();
            AddressSearchInternalResult addrSearchResult = new AddressSearchInternalResult(this.m_searchEnd, this.m_currSearchResult, fieldID, this.m_matchLen, this.savedSearchResult.m_searchInput);
            addrSearchResult.setPrevious(this.savedSearchResult.m_prevResult);
            return addrSearchResult;
        }

        @Override
        public Iterator<SearchResult> getMainIterator() {
            SearchResults searchResults = this.savedSearchResult.m_searchResults;
            searchResults.setAdditionalAreaFilters(AddressSearchInternalResults.this.getAreaFilters());
            return searchResults.iterator();
        }
    }

    private static class SavedSearchResults {
        final SearchResults m_searchResults;
        final AddressSearchInternalResult m_prevResult;
        final SearchInput m_searchInput;

        public SavedSearchResults(SearchResults searchResults, AddressSearchInternalResult prevResult, SearchInput searchInput) {
            this.m_searchResults = searchResults;
            this.m_prevResult = prevResult;
            this.m_searchInput = searchInput;
        }
    }
}

