/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.util.ArrayList;
import java.util.List;

public class AddressSearchPreferences {
    private static final Integer STREET_FIELD = FieldType.STREET_NAME_FIELD_TYPE.getKey();
    private List<Integer> searchableFields;
    private List<Integer> omittedFields;
    private boolean useShortenedSearchString = false;
    private boolean useSoundex = false;
    private boolean usefuzzyMatch = false;
    private int maxEditDistance = 1;
    private int minMatchCharacters = 2;
    private boolean matchFirstCharacter = true;
    private boolean charFreqMatcher = false;
    private boolean mustMatchAddressNum = false;
    private IAutoSuggestConstraints.FuzzyMatchMode mode = IAutoSuggestConstraints.FuzzyMatchMode.NONE;
    private boolean compressAreaNames = false;

    public AddressSearchPreferences() {
    }

    public AddressSearchPreferences(AddressSearchPreferences copyFrom) {
        this.useShortenedSearchString = copyFrom.useShortenedSearchString;
        this.setFuzzyMatchMode(copyFrom.getFuzzyMatchMode());
        this.mustMatchAddressNum = copyFrom.mustMatchAddressNum;
        this.usefuzzyMatch = copyFrom.usefuzzyMatch;
        this.useSoundex = copyFrom.useSoundex;
        if (copyFrom.searchableFields != null) {
            this.searchableFields = new ArrayList<Integer>(copyFrom.searchableFields);
        }
        if (copyFrom.omittedFields != null) {
            this.omittedFields = new ArrayList<Integer>(copyFrom.omittedFields);
        }
    }

    public void setFuzzyMatchMode(IAutoSuggestConstraints.FuzzyMatchMode mode) {
        if (mode == null) {
            mode = IAutoSuggestConstraints.FuzzyMatchMode.NONE;
        }
        this.mode = mode;
        switch (mode) {
            case NONE: {
                this.usefuzzyMatch = false;
                this.useSoundex = false;
                break;
            }
            case HARD_MATCH: {
                this.usefuzzyMatch = true;
                this.useSoundex = false;
                this.maxEditDistance = 1;
                this.minMatchCharacters = 2;
                this.matchFirstCharacter = true;
                break;
            }
            case SOFT_MATCH: {
                this.usefuzzyMatch = true;
                this.useSoundex = false;
                this.maxEditDistance = 2;
                this.minMatchCharacters = 2;
                this.matchFirstCharacter = false;
            }
        }
    }

    public void setSearchableFields(int ... fields) {
        this.searchableFields = IntArray.asList((int[])fields);
    }

    public void setSearchableFields(List<Integer> fields) {
        this.searchableFields = fields;
    }

    public List<Integer> getSearchableFields() {
        return this.searchableFields;
    }

    public void setOmittedFields(int ... fields) {
        this.omittedFields = IntArray.asList((int[])fields);
    }

    public List<Integer> getOmittedFields() {
        return this.omittedFields;
    }

    public boolean canSearchStreetField() {
        if (this.searchableFields != null && !this.searchableFields.isEmpty()) {
            return this.searchableFields.contains(STREET_FIELD);
        }
        if (this.omittedFields != null) {
            return !this.omittedFields.contains(STREET_FIELD);
        }
        return true;
    }

    public boolean isUseShortenedSearchString() {
        return this.useShortenedSearchString;
    }

    public void setUseShortenedSearchString(boolean useShortenedSearchString) {
        this.useShortenedSearchString = useShortenedSearchString;
    }

    public void setFuzzySearch(boolean fuzzy) {
        this.usefuzzyMatch = fuzzy;
    }

    public boolean getFuzzySearch() {
        return this.usefuzzyMatch;
    }

    public boolean getUseSoundex() {
        return this.useSoundex;
    }

    public void setUseSoundex(boolean useSoundex) {
        this.useSoundex = useSoundex;
    }

    public int maxEditDistance() {
        return this.maxEditDistance;
    }

    public int getMinMatchCharacters() {
        return this.minMatchCharacters;
    }

    public boolean isMatchFirstCharacter() {
        return this.matchFirstCharacter;
    }

    public boolean isCharFreqMatcher() {
        return this.charFreqMatcher;
    }

    public IAutoSuggestConstraints.FuzzyMatchMode getFuzzyMatchMode() {
        return this.mode;
    }

    public void setMustMatchAddressNumber(boolean match) {
        this.mustMatchAddressNum = match;
    }

    public boolean isMustMatchAddressNumber() {
        return this.mustMatchAddressNum;
    }

    public boolean isCompressAreaNames() {
        return this.compressAreaNames;
    }

    public void setCompressAreaNames(boolean compressAreaNames) {
        this.compressAreaNames = compressAreaNames;
    }
}

