/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressFieldPrefixMatcher;
import com.mapinfo.mapmarker.autosuggest.AddressFilter;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.AddressSearchPreferences;
import com.mapinfo.mapmarker.autosuggest.AutoSuggestHandler;
import com.mapinfo.mapmarker.autosuggest.BandedInternalResultFetcher;
import com.mapinfo.mapmarker.autosuggest.IAddressFilter;
import com.mapinfo.mapmarker.autosuggest.IAddressSearchResult;
import com.mapinfo.mapmarker.autosuggest.MatchedAddressIterator;
import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.utils.SubLevelIterator;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.Iterator;
import java.util.List;

public class AddressSearchResult
implements IAddressSearchResult {
    private static final int MAX_FALLBACK_RESULTS_TO_KEEP = 100;
    private final AutoSuggestHandler m_autoSuggestHandler;
    private final AddressSearchPreferences m_addrSearchPreferences;
    private String m_searchString;
    private boolean m_returnFallbackResults = false;
    private int m_fallbackResultAdded = 0;
    private Iterator<SimpleAddress> m_it = null;
    private Iterable<AddressSearchInternalResult> m_results;
    private SearchAreas m_searchAreas;
    private BandedInternalResultFetcher m_currIntResultFetcher;
    private String m_inputCountry;

    protected AddressSearchResult(AutoSuggestHandler autoSuggestHandler, Iterable<AddressSearchInternalResult> results, AddressSearchPreferences addrSearchPreferences, String searchString, SearchAreas searchAreas) {
        this.m_autoSuggestHandler = autoSuggestHandler;
        this.m_addrSearchPreferences = addrSearchPreferences;
        this.m_searchString = searchString;
        this.setAddressSearchInternalResults(results);
        this.setSearchAreas(searchAreas);
    }

    void setAddressSearchInternalResults(Iterable<AddressSearchInternalResult> results) {
        this.m_results = results;
    }

    void setSearchAreas(SearchAreas searchAreas) {
        this.m_searchAreas = searchAreas;
    }

    public AutoSuggestHandler getAutoSuggestHandler() {
        return this.m_autoSuggestHandler;
    }

    public String getSearchedString() {
        return this.m_searchString;
    }

    public SearchAreas getSearchAreas() {
        return this.m_searchAreas;
    }

    @Override
    public Iterator<SimpleAddress> getResultIterator(int limit) {
        Iterator<SimpleAddress> it = this.internalGetResultIterator(limit, false, false);
        this.m_it = it;
        return it;
    }

    public Iterator<SimpleAddress> getStoredIterator() {
        return this.m_it;
    }

    @Override
    public Iterator<SimpleAddress> getResultIterator(int limit, boolean singleAddressOnAreaOnlyMatch) {
        this.m_it = this.internalGetResultIterator(limit, singleAddressOnAreaOnlyMatch, false);
        return this.m_it;
    }

    @Override
    public int getMinimumDistanceForFurtherResults() {
        return this.m_currIntResultFetcher == null ? 0 : this.m_currIntResultFetcher.getMinimumDistance();
    }

    @Override
    public Iterator<SimpleAddress> getResultIterator(boolean singleAddressOnAreaOnlyMatch, boolean fetchNearBy) {
        this.m_it = this.internalGetResultIterator(-1, singleAddressOnAreaOnlyMatch, fetchNearBy);
        return this.m_it;
    }

    Iterator<SimpleAddress> internalGetResultIterator(final int limit, final boolean singleAddressOnAreaOnlyMatch, boolean fetchNearBy) {
        BandedInternalResultFetcher fetcher;
        this.m_currIntResultFetcher = fetcher = new BandedInternalResultFetcher(this.m_results, this.m_searchAreas, fetchNearBy);
        return new SubLevelIterator<AddressSearchInternalResult, SimpleAddress, SimpleAddress>(limit){

            @Override
            public Iterator<SimpleAddress> getSubIterator(AddressSearchInternalResult interSearchRes) {
                int maxRequired;
                int n = maxRequired = limit > 0 ? limit - this.getFetchedCount() : Integer.MAX_VALUE;
                if (maxRequired > 0) {
                    return this.getNextResultSetIt(interSearchRes, maxRequired);
                }
                return null;
            }

            private Iterator<SimpleAddress> getNextResultSetIt(AddressSearchInternalResult interSearchRes, int maxRequired) {
                Iterator<SimpleAddress> candIt = null;
                if (interSearchRes.isFallbackResult()) {
                    if (AddressSearchResult.this.m_returnFallbackResults || this.getFetchedCount() == 0) {
                        candIt = AddressSearchResult.this.fetchAddresses(interSearchRes, singleAddressOnAreaOnlyMatch, maxRequired);
                        if (candIt != null) {
                            AddressSearchResult.this.m_returnFallbackResults = true;
                        }
                    } else {
                        fetcher.removeAllPreMarkItems();
                    }
                } else {
                    candIt = AddressSearchResult.this.fetchAddresses(interSearchRes, singleAddressOnAreaOnlyMatch, maxRequired);
                }
                return candIt;
            }

            @Override
            public SimpleAddress getItem(SimpleAddress subItem) {
                return subItem;
            }

            @Override
            public Iterator<AddressSearchInternalResult> getMainIterator() {
                return fetcher;
            }
        };
    }

    void saveResultForFallback(AddressSearchInternalResult addrSearchIntRes, SearchResult searchResult) {
        if (!this.m_addrSearchPreferences.isMustMatchAddressNumber() && this.m_fallbackResultAdded < 100) {
            AddressSearchInternalResult fallbackResult = this.createFallbackResult(addrSearchIntRes, searchResult);
            this.m_currIntResultFetcher.insertBeforeMarker(fallbackResult);
            ++this.m_fallbackResultAdded;
        }
    }

    AddressSearchInternalResult createFallbackResult(AddressSearchInternalResult addrSearchIntRes, SearchResult searchResult) {
        AddressSearchInternalResult realResult = addrSearchIntRes.getRealResult();
        AddressSearchInternalResult fallbackResult = null;
        if (realResult == addrSearchIntRes) {
            fallbackResult = addrSearchIntRes.copy(searchResult);
        } else {
            fallbackResult = addrSearchIntRes.copy();
            fallbackResult.replace(realResult, realResult.copy(searchResult));
        }
        fallbackResult.setFallbackResult(true);
        return fallbackResult;
    }

    protected Iterator<SimpleAddress> fetchAddresses(AddressSearchInternalResult addrSearchIntRes, boolean singleAddressOnAreaOnlyMatch, int maxRequired) {
        IAddressFilter addressFilter = this.getFilter(addrSearchIntRes, singleAddressOnAreaOnlyMatch);
        if (addressFilter != null) {
            Iterator<SimpleAddress> candIt;
            SearchResult savedSearchResult = null;
            if (this.filterForMatchingHNRRanges(addrSearchIntRes)) {
                savedSearchResult = addressFilter.getSearchResult();
                addressFilter.filterAddressPtrsForMatchingRange();
            }
            if ((candIt = this.fetchAddressesInternal(addrSearchIntRes, addressFilter, maxRequired)) != null) {
                return candIt;
            }
            if (savedSearchResult != null) {
                this.saveResultForFallback(addrSearchIntRes, savedSearchResult);
            }
        }
        return null;
    }

    Iterator<SimpleAddress> fetchAddressesInternal(AddressSearchInternalResult addrSearchIntRes, IAddressFilter addrfilter, int maxRequired) {
        AddressFieldPrefixMatcher addrFieldPrefixMatcher;
        Iterator<SimpleAddress> candIt;
        AutoSuggestHandler handler;
        Iterator<SimpleAddress> it;
        if (addrfilter.hasPossibleResults() && (it = (handler = this.getAutoSuggestHandler()).getAddressIterator(addrfilter.getSearchResult(), addrfilter, maxRequired)) != null && it.hasNext() && (candIt = this.getMatchedAddressIterator(it, addrSearchIntRes, addrfilter, maxRequired, addrFieldPrefixMatcher = this.getAddressFieldPrefixMatcher(addrSearchIntRes))) != null && candIt.hasNext()) {
            return candIt;
        }
        return null;
    }

    boolean filterForMatchingHNRRanges(AddressSearchInternalResult addrSearchIntRes) {
        return !addrSearchIntRes.isFallbackResult() && addrSearchIntRes.hasHNRMatch();
    }

    Iterator<SimpleAddress> getMatchedAddressIterator(Iterator<SimpleAddress> addrItr, AddressSearchInternalResult addrSearchInternalresult, IAddressFilter addrFilter, int maxRequired, AddressFieldPrefixMatcher addrFieldPrefixMatcher) {
        return new MatchedAddressIterator(addrItr, addrSearchInternalresult, addrFilter, maxRequired, addrFieldPrefixMatcher, this.m_searchString, this.getAutoSuggestHandler().getCategoryInfoManager());
    }

    IAddressFilter getFilter(AddressSearchInternalResult addrSearchIntRes, boolean singleCandidateOnAreaOnlyMatch) {
        SearchAreas searchAreas;
        AddressFilter filter = new AddressFilter(addrSearchIntRes, this.getAutoSuggestHandler().getAddressMetaData());
        if (filter.initFilter(singleCandidateOnAreaOnlyMatch) && (searchAreas = this.m_currIntResultFetcher.getCurrentSearchAreas()) != null) {
            boolean bl = filter.filterSearchResultForDistanceBand(this.m_currIntResultFetcher.getMinimumDistance(), this.m_currIntResultFetcher.getMaximumDistance(), searchAreas);
        }
        if (filter.hasPossibleResults()) {
            return filter;
        }
        return null;
    }

    boolean resultsPossible(AddressSearchInternalResult addrSearchInternalRes) {
        AddressPtrMap addrPtrMap;
        boolean moreResults = false;
        AddressSearchInternalResult realAddrSearchIntRes = addrSearchInternalRes.getRealResult();
        if (realAddrSearchIntRes != null && (addrPtrMap = realAddrSearchIntRes.getSearchResult().getAddressPtrMap()) != null) {
            int fieldToMatch = addrSearchInternalRes.getMatchedFieldType();
            if (addrPtrMap.size() > 0) {
                moreResults = fieldToMatch < 0 || addrPtrMap.find(fieldToMatch) != null;
            }
        }
        return moreResults;
    }

    AddressFieldPrefixMatcher getAddressFieldPrefixMatcher(AddressSearchInternalResult addrSearchInternalResult) {
        addrSearchInternalResult = addrSearchInternalResult.getNonHNRResult();
        AddressSearchPreferences addrSearchPreferences = this.getAddressSearchPreferences();
        List ignoreFields = ListUtils.addToList((List)null, addrSearchInternalResult.getMatchedFieldTypes());
        if (addrSearchPreferences != null) {
            ignoreFields = ListUtils.addToList((List)ignoreFields, addrSearchPreferences.getOmittedFields());
        }
        List<Integer> allowedFields = addrSearchPreferences == null ? null : addrSearchPreferences.getSearchableFields();
        AddressFieldPrefixMatcher addrPrefixMatcher = new AddressFieldPrefixMatcher(allowedFields, ignoreFields, addrSearchInternalResult.getSearchResult().getWord(), addrSearchInternalResult.getSearchWords(), this.getAutoSuggestHandler().getTokenStandardiser());
        return addrPrefixMatcher;
    }

    AddressSearchPreferences getAddressSearchPreferences() {
        return this.m_addrSearchPreferences;
    }

    void groupResultByArea(AddressSearchInternalResult AddressSearchInternalResult2) {
        List<AddressPtr> addrPtrList = AddressSearchInternalResult2.getAddressPtrs();
        int c = addrPtrList.size();
        for (int i = 0; i < c; ++i) {
            AddressPtr addrPtr = addrPtrList.get(i);
            AddressPtr addrPtrCopy = new AddressPtr(addrPtr.getAreaID());
            addrPtrCopy.addAddressID(addrPtr.getFirstAddressID());
            addrPtrList.set(i, addrPtrCopy);
        }
    }

    @Override
    public boolean resultsHasDistance() {
        return this.m_searchAreas != null && this.m_searchAreas.getCenterPoint() != null;
    }

    @Override
    public boolean isAddressDictionary() {
        AutoSuggestHandler handler = this.getAutoSuggestHandler();
        if (handler != null) {
            return handler.getDataSetType() == 0;
        }
        return true;
    }

    @Override
    public void setOptimalMaxDistance(int max) {
        if (this.m_currIntResultFetcher != null) {
            this.m_currIntResultFetcher.setOptimalMaxDistance(max);
        }
    }

    @Override
    public int getOptimalMaxDistance() {
        return this.m_currIntResultFetcher == null ? 0 : this.m_currIntResultFetcher.getOptimalMaxDistance();
    }

    @Override
    public void setInputCountry(String country) {
        this.m_inputCountry = country;
    }

    @Override
    public String getInputCountry() {
        return this.m_inputCountry;
    }
}

