/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressSearchHandler;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResults;
import com.mapinfo.mapmarker.autosuggest.AutoSuggestHandler;
import com.mapinfo.mapmarker.autosuggest.SearchInput;
import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.SearchResults;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.CategoryIDDataItem;
import com.mapinfo.mapmarker.autosuggest.dp.CategoryInfoManager;
import com.mapinfo.mapmarker.autosuggest.dp.IAreaIDReadingFilter;
import com.mapinfo.mapmarker.autosuggest.exception.DataFetchException;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.autosuggest.filters.GeocompleteFilters;
import com.mapinfo.mapmarker.autosuggest.utils.ConditionalIterator;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeMatchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CategorySearchHandler {
    private final AutoSuggestHandler m_autoSuggestHandler;
    private final CategoryInfoManager m_categoryInfoManager;
    private static final CompositeSearchResults EMPTY_INTERNALRESULTS = new CompositeSearchResults(null);

    CategorySearchHandler(AutoSuggestHandler autoSuggestHandler) {
        this.m_autoSuggestHandler = autoSuggestHandler;
        this.m_categoryInfoManager = autoSuggestHandler.getCategoryInfoManager();
    }

    protected AddressSearchInternalResults searchCategories(AddressSearchInternalResult previousSearchResult, SearchInput searchInput, SearchRequest request) throws SuggestFailureException {
        CategoryInfoManager categoryInfoManager;
        if (this.m_autoSuggestHandler.getDataSetType() == 1 && (categoryInfoManager = this.m_autoSuggestHandler.getCategoryInfoManager()) != null) {
            CategorySearchInput catSearchInput = this.getCategorySearchInput(searchInput, request);
            return this.searchCategories(catSearchInput, previousSearchResult, request);
        }
        return null;
    }

    int getCategoryFieldID() {
        return this.m_categoryInfoManager == null ? -1 : this.m_categoryInfoManager.getCategoryField();
    }

    int getSubCategoryFieldID() {
        return this.m_categoryInfoManager == null ? -1 : this.m_categoryInfoManager.getSubCategoryField();
    }

    private AddressSearchInternalResults searchCategories(CategorySearchInput catSearchInput, AddressSearchInternalResult previousSearchResult, SearchRequest request) throws SuggestFailureException {
        CategoryInfoManager.CategorySearchType catSearchType = catSearchInput.getSearchType();
        if (catSearchType != CategoryInfoManager.CategorySearchType.NONE) {
            CompositeSearchResults compositeSavedResults = (CompositeSearchResults)catSearchInput.getResults();
            if (compositeSavedResults != null) {
                return compositeSavedResults == EMPTY_INTERNALRESULTS ? null : this.updateResultsForRequest(request, compositeSavedResults.getSearchResultList(), catSearchInput, previousSearchResult);
            }
            RadixTreeMatchResult<CategoryIDDataItem> radixTreeResult = this.getMatchedCategoryIDs(catSearchInput, request);
            List<SearchResults> catSearchResults = null;
            if (radixTreeResult != null) {
                catSearchResults = this.searchOnCategoryCodes(radixTreeResult, request, catSearchInput);
            }
            if (catSearchResults != null) {
                catSearchInput.setResults(new CompositeSearchResults(catSearchResults));
                return this.makeAddressSearchInternalResults(catSearchResults, catSearchInput, previousSearchResult);
            }
            catSearchInput.setResults(EMPTY_INTERNALRESULTS);
        }
        return null;
    }

    private RadixTreeMatchResult<CategoryIDDataItem> getMatchedCategoryIDs(SearchInput searchInput, SearchRequest searchRequest) {
        NodeFilter nodeFilter = new NodeFilter(searchRequest.getKeyFilter(), null);
        return this.m_categoryInfoManager.searchRadixTree(searchRequest.getSearchkey(), searchRequest.getSearchKeyExtensions(), searchRequest.isMatchFully(), !searchInput.isOnLastWord(), nodeFilter);
    }

    private AddressSearchInternalResults updateResultsForRequest(SearchRequest request, List<SearchResults> searchResultsList, SearchInput searchInput, AddressSearchInternalResult prevInternalResult) throws SuggestFailureException {
        SearchRequest catIDSearchRequest = this.setupRequestForCategoryIDSearch(request);
        ArrayList<SearchResults> newSearchResults = new ArrayList<SearchResults>(searchResultsList.size());
        for (SearchResults searchResults : searchResultsList) {
            newSearchResults.add(this.m_autoSuggestHandler.makeResultCopyForRequest(catIDSearchRequest, searchResults));
        }
        return this.makeAddressSearchInternalResults(newSearchResults, searchInput, prevInternalResult);
    }

    private AddressSearchInternalResults makeAddressSearchInternalResults(List<SearchResults> searchResultsList, SearchInput searchInput, AddressSearchInternalResult prevInternalResult) {
        AddressSearchInternalResults addrSearchResults = new AddressSearchInternalResults();
        for (SearchResults searchResults : searchResultsList) {
            addrSearchResults.createAndAddNewInternalResult(searchResults, prevInternalResult, searchInput);
        }
        return addrSearchResults;
    }

    private CategorySearchInput getCategorySearchInput(SearchInput searchInput, SearchRequest request) {
        return new CategorySearchInput(searchInput, this.getSearchType(request));
    }

    private CategoryInfoManager.CategorySearchType getSearchType(SearchRequest request) {
        boolean canSearchCategory = request.canSearchOnField(this.m_categoryInfoManager.getCategoryField());
        boolean canSearchSubCategory = request.canSearchOnField(this.m_categoryInfoManager.getSubCategoryField());
        return this.m_categoryInfoManager.makeCategorySearchType(canSearchCategory, canSearchSubCategory);
    }

    private List<SearchResults> searchOnCategoryCodes(RadixTreeMatchResult<CategoryIDDataItem> radixTreeMatchResult, SearchRequest request, SearchInput searchInput) throws SuggestFailureException {
        ArrayList<SearchResults> searchResultsList = new ArrayList<SearchResults>();
        Iterator<IMatchResult<CategoryIDDataItem>> it = radixTreeMatchResult.iterator();
        while (it.hasNext()) {
            this.populateListWithConvertedResults(it.next(), request, searchInput, searchResultsList);
        }
        return searchResultsList;
    }

    private void populateListWithConvertedResults(IMatchResult<CategoryIDDataItem> categoryIDMatchItem, SearchRequest request, SearchInput searchInput, List<SearchResults> searchResultList) {
        CategoryIDDataItem catIDItem = categoryIDMatchItem.getValue();
        Iterator<Map.Entry<Integer, Set<Integer>>> it = catIDItem.getFieldIDCategoryIDIterator(request.getAllowedTypes());
        while (it.hasNext()) {
            Map.Entry<Integer, Set<Integer>> en = it.next();
            Integer fieldID = en.getKey();
            if (!this.checkAllowedField(request, fieldID)) continue;
            searchResultList.add(new ConvertingCategorySearchResults(categoryIDMatchItem, fieldID, en.getValue(), request, searchInput));
        }
    }

    private SearchRequest setupRequestForCategoryIDSearch(SearchRequest searchRequest) {
        SearchRequest miCodeSearchRequest = new SearchRequest();
        miCodeSearchRequest.copyFrom(searchRequest);
        miCodeSearchRequest.setMatchFully(true);
        int categoryCodeFieldID = this.m_categoryInfoManager.getCategoryIDField();
        miCodeSearchRequest.setAllowedTypes(Arrays.asList(categoryCodeFieldID));
        return miCodeSearchRequest;
    }

    private boolean checkAllowedField(SearchRequest request, Integer fieldID) {
        List<Integer> ignoredFields = request.getIgnoreTypes();
        return ignoredFields == null || !ignoredFields.contains(fieldID);
    }

    private List<String> getCatIDSearchKeys(Set<Integer> catIDs) {
        ArrayList<String> catIDSearchKeys = new ArrayList<String>();
        for (Integer catID : catIDs) {
            catIDSearchKeys.add(this.m_categoryInfoManager.makeCategorySearchKey(catID.toString()));
        }
        return catIDSearchKeys;
    }

    private void updateSearchRequestForKeys(SearchRequest searchRequest, List<String> keys) {
        int nKeys = keys.size();
        String commonPrefix = keys.get(0);
        for (int i = 1; i < nKeys; ++i) {
            commonPrefix = this.getCommonPrefix(commonPrefix, keys.get(i));
        }
        searchRequest.setSearchKey(commonPrefix);
        searchRequest.setKeyFilter(GeocompleteFilters.getIDKeyFilter(keys));
        if (nKeys > 1) {
            int prefixLen = commonPrefix.length();
            String[] exts = new String[nKeys];
            for (int i = 0; i < nKeys; ++i) {
                String searchKey = keys.get(i);
                exts[i] = searchKey.length() > prefixLen ? keys.get(i).substring(prefixLen) : "";
            }
            searchRequest.setSearchKeyExtensions(exts);
        }
    }

    private String getCommonPrefix(String str1, String str2) {
        int n = Math.min(str1.length(), str2.length());
        int prefixLen = 0;
        int i = 0;
        while (i < n && str1.charAt(i) == str2.charAt(i)) {
            ++i;
            ++prefixLen;
        }
        return str1.substring(0, prefixLen);
    }

    private CategorySearchResults convertToLiteralCategoryResults(Integer catFieldID, Set<Integer> catIDs, IMatchResult<CategoryIDDataItem> categoryIDMatchItem, SearchRequest request, SearchInput searchInput) {
        SearchRequest miCodeSearchRequest = this.setupRequestForCategoryIDSearch(request);
        try {
            return this.searchOnCategoryIDs(catFieldID, catIDs, categoryIDMatchItem, miCodeSearchRequest, searchInput);
        }
        catch (Exception e) {
            throw new DataFetchException(e);
        }
    }

    private CategorySearchResults searchOnCategoryIDs(int catFieldID, Set<Integer> catIDs, IMatchResult<CategoryIDDataItem> categoryIDMatchItem, SearchRequest searchRequest, SearchInput searchInput) throws SuggestFailureException {
        List<String> searchKeys = this.getCatIDSearchKeys(catIDs);
        this.updateSearchRequestForKeys(searchRequest, searchKeys);
        SearchResults searchResults = null;
        searchResults = searchRequest.getSearchKeyExtensions() != null ? this.m_autoSuggestHandler.doIncrementalWordSearch(searchRequest) : this.m_autoSuggestHandler.search(searchRequest);
        if (searchResults != null) {
            return new CategorySearchResults(categoryIDMatchItem, catFieldID, searchResults, searchInput);
        }
        return null;
    }

    static class CategorySearchInput
    extends SearchInput {
        private final SearchInput m_searchInput;
        private final CategoryInfoManager.CategorySearchType m_catSearchType;

        CategorySearchInput(SearchInput input, CategoryInfoManager.CategorySearchType catSearchType) {
            super(input);
            this.m_searchInput = input;
            this.m_catSearchType = catSearchType;
        }

        @Override
        public int hashCode() {
            return this.m_searchInput.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CategorySearchInput) {
                CategorySearchInput other = (CategorySearchInput)obj;
                return this.m_catSearchType == other.m_catSearchType && this.m_searchInput.equals(other.m_searchInput);
            }
            return false;
        }

        SearchInput getSearchInput() {
            return this.m_searchInput;
        }

        CategoryInfoManager.CategorySearchType getSearchType() {
            return this.m_catSearchType;
        }
    }

    static final class CompositeSearchResults
    extends SearchResults {
        private final List<SearchResults> m_searchResultsList;

        CompositeSearchResults(List<SearchResults> searchResultsList) {
            super(null, null);
            this.m_searchResultsList = searchResultsList;
        }

        List<SearchResults> getSearchResultList() {
            return this.m_searchResultsList;
        }
    }

    final class CategorySearchResults
    extends SearchResults {
        private final IMatchResult<CategoryIDDataItem> m_catIDMatchedItem;
        private final SearchInput m_searchInput;
        private final int m_matchedCategoryField;

        CategorySearchResults(IMatchResult<CategoryIDDataItem> catIDMatchedItem, int matchedCatField, SearchResults searchResults, SearchInput searchInput) {
            super(searchResults);
            this.m_catIDMatchedItem = catIDMatchedItem;
            this.m_matchedCategoryField = matchedCatField;
            this.m_searchInput = searchInput;
        }

        @Override
        SearchResults copyWithNewRequestAndFilter(SearchRequest req, INodeValueFilter<AddressPtrMap> nodeValueFilter) {
            SearchResults results = super.copyWithNewRequestAndFilter(req, nodeValueFilter);
            return new CategorySearchResults(this.m_catIDMatchedItem, this.m_matchedCategoryField, results, this.m_searchInput);
        }

        @Override
        public Iterator<SearchResult> iterator() {
            return new ConditionalIterator<SearchResult>(super.iterator()){

                @Override
                public SearchResult updateItem(SearchResult item) {
                    return CategorySearchResults.this.convert(item);
                }
            };
        }

        private SearchResult convert(SearchResult categoryIDSearchResult) {
            String originalSearchKey = this.m_searchInput.getSearchString();
            String matchedCategoryName = this.m_catIDMatchedItem.getKey();
            int matchedLen = AddressSearchHandler.calculateMatchLength(this.m_catIDMatchedItem.getKey(), originalSearchKey, this.m_catIDMatchedItem.getTargetMatchLen());
            AddressPtrMap addrPtrMap = this.getAddressPtrMapForMatchedField(categoryIDSearchResult.getAddressPtrMap());
            SearchResult newResult = SearchResult.getInstance(matchedCategoryName, addrPtrMap, categoryIDSearchResult.getSearchRequest(), matchedLen, this.m_catIDMatchedItem.getWeight(), this.m_catIDMatchedItem.isFullInputMatch());
            return newResult;
        }

        private AddressPtrMap getAddressPtrMapForMatchedField(AddressPtrMap addrPtrMap) {
            AddressPtrMap newAddressPtrMap = new AddressPtrMap();
            newAddressPtrMap.addAll(this.m_matchedCategoryField, addrPtrMap.getMap().get(CategorySearchHandler.this.m_categoryInfoManager.getCategoryIDField()));
            return newAddressPtrMap;
        }
    }

    final class ConvertingCategorySearchResults
    extends SearchResults {
        private final Integer m_categoryFieldID;
        private final Set<Integer> m_categoryIDs;
        private final IMatchResult<CategoryIDDataItem> m_categoryMatchItem;
        private CategorySearchResults m_convertedResult;
        private final SearchInput m_searchInput;
        private List<IAreaIDReadingFilter> m_areaFilters;

        private ConvertingCategorySearchResults(ConvertingCategorySearchResults copyFrom) {
            super(copyFrom);
            this.m_categoryFieldID = copyFrom.m_categoryFieldID;
            this.m_categoryIDs = copyFrom.m_categoryIDs;
            this.m_categoryMatchItem = copyFrom.m_categoryMatchItem;
            this.m_searchInput = copyFrom.m_searchInput;
        }

        ConvertingCategorySearchResults(IMatchResult<CategoryIDDataItem> catMatchItem, Integer catFieldID, Set<Integer> catIDs, SearchRequest searchRequest, SearchInput searchInput) {
            super(null, searchRequest);
            this.m_categoryFieldID = catFieldID;
            this.m_categoryIDs = catIDs;
            this.m_categoryMatchItem = catMatchItem;
            this.m_searchInput = searchInput;
        }

        @Override
        public Iterator<SearchResult> iterator() {
            if (this.m_convertedResult == null) {
                this.m_convertedResult = CategorySearchHandler.this.convertToLiteralCategoryResults(this.m_categoryFieldID, this.m_categoryIDs, this.m_categoryMatchItem, this.getSearchRequest(), this.m_searchInput);
            }
            if (this.m_convertedResult == null) {
                List l = Collections.emptyList();
                return l.iterator();
            }
            return this.m_convertedResult.iterator();
        }

        @Override
        SearchResults copyWithNewRequestAndFilter(SearchRequest req, INodeValueFilter<AddressPtrMap> nodeValueFilter) {
            if (this.m_convertedResult != null) {
                SearchResults results = this.m_convertedResult.copyWithNewRequestAndFilter(req, nodeValueFilter);
                CategorySearchResults catResults = new CategorySearchResults(this.m_convertedResult.m_catIDMatchedItem, this.m_convertedResult.m_matchedCategoryField, results, this.m_convertedResult.m_searchInput);
                catResults.setAdditionalAreaFilters(this.m_areaFilters);
                return catResults;
            }
            return new ConvertingCategorySearchResults(this);
        }

        @Override
        public void setAdditionalAreaFilters(List<IAreaIDReadingFilter> areaFilters) {
            if (this.m_convertedResult != null) {
                this.m_convertedResult.setAdditionalAreaFilters(areaFilters);
            } else {
                this.m_areaFilters = areaFilters;
            }
        }
    }
}

