/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.IDictionarySearchPriority;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DictionarySearchPriority
implements IDictionarySearchPriority {
    private int dictionaryCount;
    private List<SearchDictionary> dictionaries;
    private Map<String, SearchDictionary> dictionaryMap;
    private IDictionarySearchPriority.DictionaryUsagePreference dictionaryUsagePreference;

    public DictionarySearchPriority(int count) {
        this.dictionaryCount = count;
        this.dictionaries = new ArrayList<SearchDictionary>(count);
        this.dictionaryMap = new HashMap<String, SearchDictionary>(count);
        this.dictionaryUsagePreference = IDictionarySearchPriority.DictionaryUsagePreference.NONE;
    }

    public DictionarySearchPriority(IDictionarySearchPriority searchPriority) {
        if (searchPriority == null) {
            throw new IllegalArgumentException("searchPriority can not be null.");
        }
        this.dictionaryCount = searchPriority.getDictionaryCount();
        this.dictionaries = new ArrayList<SearchDictionary>(this.dictionaryCount);
        this.dictionaryMap = new HashMap<String, SearchDictionary>(this.dictionaryCount);
        this.dictionaryUsagePreference = IDictionarySearchPriority.DictionaryUsagePreference.NONE;
        for (int index = 0; index < this.dictionaryCount; ++index) {
            int cfgIdx = index + 1;
            this.addDictionary(cfgIdx, searchPriority.isDictionaryAvailableForSearch(cfgIdx), searchPriority.getDictionaryDescription(cfgIdx), searchPriority.getSearchPriorityForDictionary(cfgIdx), searchPriority.isUserDictionary(cfgIdx));
        }
    }

    @Override
    public int getDictionaryCount() {
        return this.dictionaryCount;
    }

    @Override
    public boolean addDictionary(int cfgIdx, boolean bSearchable, String desc, int userPriority, boolean bUserDict) {
        if (cfgIdx < 1 || cfgIdx > this.dictionaryCount || userPriority < 1 || userPriority > this.dictionaryCount) {
            return false;
        }
        SearchDictionary aDict = new SearchDictionary(--cfgIdx, desc, --userPriority, bSearchable, bUserDict);
        this.dictionaries.add(cfgIdx, aDict);
        this.dictionaryMap.put(desc, aDict);
        return true;
    }

    @Override
    public boolean isDictionaryAvailableForSearch(int cfgIdx) {
        int trueCfgIdx = cfgIdx - 1;
        if (trueCfgIdx < 0 || trueCfgIdx >= this.dictionaryCount || trueCfgIdx >= this.dictionaries.size()) {
            return false;
        }
        SearchDictionary dict = this.dictionaries.get(trueCfgIdx);
        if (dict == null) {
            return false;
        }
        return dict.isSearchable;
    }

    @Override
    public boolean isUserDictionary(int cfgIdx) {
        int trueCfgIdx = cfgIdx - 1;
        if (trueCfgIdx < 0 || trueCfgIdx >= this.dictionaryCount || trueCfgIdx >= this.dictionaries.size()) {
            return false;
        }
        SearchDictionary dict = this.dictionaries.get(trueCfgIdx);
        if (dict == null) {
            return false;
        }
        return dict.isUserDictionary;
    }

    @Override
    public void setDictionaryAvailableForSearch(int cfgIdx, boolean bAvailable) {
        int trueCfgIdx = cfgIdx - 1;
        if (trueCfgIdx < 0 || trueCfgIdx >= this.dictionaryCount || trueCfgIdx >= this.dictionaries.size()) {
            return;
        }
        SearchDictionary dict = this.dictionaries.get(trueCfgIdx);
        if (dict == null) {
            return;
        }
        dict.isSearchable = bAvailable;
    }

    @Override
    public int getSearchPriorityForDictionary(String dictName) {
        SearchDictionary dict = this.dictionaryMap.get(dictName);
        if (dict == null) {
            return -1;
        }
        return dict.userPriority + 1;
    }

    @Override
    public int getSearchPriorityForDictionary(int cfgIdx) {
        int trueCfgIdx = cfgIdx - 1;
        if (trueCfgIdx < 0 || trueCfgIdx >= this.dictionaryCount || trueCfgIdx >= this.dictionaries.size()) {
            return -1;
        }
        SearchDictionary dict = this.dictionaries.get(trueCfgIdx);
        if (dict == null) {
            return -1;
        }
        return dict.userPriority + 1;
    }

    @Override
    public void setSearchPriorityForDictionary(int cfgIdx, int newSearchPriority) {
        SearchDictionary tmpDict;
        int i;
        int trueCfgIdx = cfgIdx - 1;
        int trueNewSearchPriority = newSearchPriority - 1;
        if (trueCfgIdx < 0 || trueCfgIdx >= this.dictionaryCount || trueCfgIdx >= this.dictionaries.size() || trueNewSearchPriority < 0 || trueNewSearchPriority >= this.dictionaryCount) {
            return;
        }
        SearchDictionary dict = this.dictionaries.get(trueCfgIdx);
        if (dict == null) {
            return;
        }
        int count = this.getDictionaryCount();
        int currentPriority = dict.userPriority;
        for (i = 0; i < count; ++i) {
            if (i == trueCfgIdx) continue;
            tmpDict = this.dictionaries.get(i);
            if (tmpDict.userPriority <= currentPriority) continue;
            --tmpDict.userPriority;
        }
        for (i = 0; i < count; ++i) {
            if (i == trueCfgIdx) continue;
            tmpDict = this.dictionaries.get(i);
            if (tmpDict.userPriority < trueNewSearchPriority) continue;
            ++tmpDict.userPriority;
        }
        dict.userPriority = trueNewSearchPriority;
    }

    @Override
    public String getDictionaryDescription(int cfgIdx) {
        int trueCfgIdx = cfgIdx - 1;
        if (trueCfgIdx < 0 || trueCfgIdx >= this.dictionaryCount || trueCfgIdx >= this.dictionaries.size()) {
            return null;
        }
        SearchDictionary dict = this.dictionaries.get(trueCfgIdx);
        if (dict == null) {
            return null;
        }
        return dict.description;
    }

    @Override
    public boolean isDictionaryAvailableForSearch(String dictName) {
        SearchDictionary dict = this.dictionaryMap.get(dictName);
        if (dict == null) {
            return false;
        }
        return dict.isSearchable;
    }

    @Override
    public void setDictionaryUsagePreference(IDictionarySearchPriority.DictionaryUsagePreference dictionaryUsagePreference) {
        this.dictionaryUsagePreference = dictionaryUsagePreference;
        List<SearchDictionary> prioritySortedDictionaries = this.prioritySortDictionaries();
        switch (dictionaryUsagePreference) {
            case PREFER_UD: {
                int priority = 0;
                for (SearchDictionary dictionary : prioritySortedDictionaries) {
                    if (!dictionary.isUserDictionary) continue;
                    dictionary.userPriority = priority++;
                }
                for (SearchDictionary dictionary : prioritySortedDictionaries) {
                    if (dictionary.isUserDictionary) continue;
                    dictionary.userPriority = priority++;
                }
                break;
            }
            case PREFER_STD: {
                int priority = 0;
                for (SearchDictionary dictionary : prioritySortedDictionaries) {
                    if (dictionary.isUserDictionary) continue;
                    dictionary.userPriority = priority++;
                }
                for (SearchDictionary dictionary : prioritySortedDictionaries) {
                    if (!dictionary.isUserDictionary) continue;
                    dictionary.userPriority = priority++;
                }
                break;
            }
            case UD_ONLY: {
                for (SearchDictionary dictionary : this.dictionaries) {
                    dictionary.isSearchable = dictionary.isUserDictionary;
                }
                break;
            }
            case STD_ONLY: {
                for (SearchDictionary dictionary : this.dictionaries) {
                    dictionary.isSearchable = !dictionary.isUserDictionary;
                }
                break;
            }
            case NONE: {
                for (SearchDictionary dictionary : this.dictionaries) {
                    dictionary.isSearchable = true;
                }
                break;
            }
        }
    }

    @Override
    public IDictionarySearchPriority.DictionaryUsagePreference getDictionaryUsagePreference() {
        return this.dictionaryUsagePreference;
    }

    public String toString() {
        int ct = this.getDictionaryCount();
        StringBuilder sb = new StringBuilder(256);
        sb.append("DictionarySearchPriority contents: ");
        sb.append(System.getProperty("line.separator"));
        for (int i = 1; i <= ct; ++i) {
            sb.append("  Dictionary number: ");
            sb.append(i);
            sb.append(" user priority: ");
            sb.append(this.getSearchPriorityForDictionary(i));
            sb.append(" available: ");
            sb.append(this.isDictionaryAvailableForSearch(i));
            sb.append(" desc: ");
            sb.append(this.getDictionaryDescription(i));
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private List<SearchDictionary> prioritySortDictionaries() {
        ArrayList<SearchDictionary> sortedList = new ArrayList<SearchDictionary>();
        for (int i = 0; i < this.dictionaries.size(); ++i) {
            for (SearchDictionary dictionary : this.dictionaries) {
                if (dictionary.userPriority != i) continue;
                sortedList.add(dictionary);
            }
        }
        return sortedList;
    }

    private class SearchDictionary {
        String description;
        int userPriority;
        boolean isSearchable;
        boolean isUserDictionary;
        int configuredPriority;

        public SearchDictionary(int configuredPriority, String desc, int priority, boolean isSearchable, boolean isUserDictionary) {
            this.isSearchable = isSearchable;
            this.isUserDictionary = isUserDictionary;
            this.configuredPriority = configuredPriority;
            this.description = desc;
            this.userPriority = priority;
        }
    }
}

