/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

public class FieldMatchInfo {
    private final int fieldID;
    private final String matchedChars;
    private final int matchedValueNdx;
    private final int matchStartCharNdx;
    private final boolean matchedOrig;
    private final int inputField;

    public FieldMatchInfo(int fieldID, String matchedChars, int matchStartCharNdx, int matchedValueNdx) {
        this(fieldID, 0, matchedChars, matchStartCharNdx, matchedValueNdx, true);
    }

    public FieldMatchInfo(int fieldID, int inField, String matchedChars, int matchStartCharNdx, int matchedValueNdx) {
        this(fieldID, inField, matchedChars, matchStartCharNdx, matchedValueNdx, true);
    }

    public FieldMatchInfo(int fieldID, String matchedChars, int matchStartCharNdx, int matchedValueNdx, boolean matchedOrig) {
        this(fieldID, 0, matchedChars, matchStartCharNdx, matchedValueNdx, matchedOrig);
    }

    public FieldMatchInfo(int fieldID, int inField, String matchedChars, int matchStartCharNdx, int matchedValueNdx, boolean matchedOrig) {
        this.fieldID = fieldID;
        this.inputField = inField;
        this.matchedChars = matchedChars;
        this.matchedValueNdx = matchedValueNdx;
        this.matchStartCharNdx = matchStartCharNdx;
        this.matchedOrig = matchedOrig;
    }

    public int getFieldID() {
        return this.fieldID;
    }

    public int getMatchedLength() {
        return this.matchedChars.length();
    }

    public String getMatchedString() {
        return this.matchedChars;
    }

    public int getMatchedValueNdx() {
        return this.matchedValueNdx;
    }

    public int getMatchStartCharNdx() {
        return this.matchStartCharNdx;
    }

    public boolean getMatchedOrig() {
        return this.matchedOrig;
    }

    public int getInputField() {
        return this.inputField;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FieldMatchInfo(input field=");
        sb.append(this.inputField);
        sb.append(", matched field=");
        sb.append(this.fieldID);
        sb.append(", matched chars='");
        sb.append(this.matchedChars);
        sb.append("', match start=");
        sb.append(this.matchStartCharNdx);
        sb.append(", matched item ndx=");
        sb.append(this.matchedValueNdx);
        sb.append(") ");
        return sb.toString();
    }
}

