/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressSearchHandler;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResults;
import com.mapinfo.mapmarker.autosuggest.AddressSearchPreferences;
import com.mapinfo.mapmarker.autosuggest.IAddressSearchResult;
import com.mapinfo.mapmarker.autosuggest.InputAddress;
import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.SearchInput;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.autosuggest.utils.IteratorUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class MultiFieldSearchHandler {
    private static final int CITY_FIELD = 18;
    private static final int STATE_FIELD = 16;
    private static final int PC_FIELD = 15;
    private final AddressSearchHandler addrSearchHandler;

    MultiFieldSearchHandler(AddressSearchHandler addrSearchHandler) {
        this.addrSearchHandler = addrSearchHandler;
    }

    public IAddressSearchResult searchAddress(InputAddress inAddress, SearchAreas searchAreas, AddressSearchPreferences addrPrefs) throws SuggestFailureException {
        SearchInput searchInput;
        IAddressSearchResult result = null;
        List<FieldSearch> searchFields = this.getSearchFields(inAddress, searchAreas, addrPrefs);
        AddressSearchInternalResults preFetchedResults = null;
        if (!searchFields.isEmpty() && ((preFetchedResults = this.searchFields(searchFields, searchAreas, addrPrefs)) == null || preFetchedResults.isEmpty())) {
            if (!"XWG".equals(this.addrSearchHandler.getAddressMetaData().getDataName())) {
                return null;
            }
            preFetchedResults = null;
        }
        if ((searchInput = this.addrSearchHandler.makeSearchInput(inAddress.getMainSearchString(), addrPrefs)) != null) {
            searchInput.setSearchAreas(searchAreas);
            result = StringUtilities.isEmpty((String)searchInput.getSearchString()) ? this.addrSearchHandler.makeSearchResult(preFetchedResults, addrPrefs, searchInput) : this.addrSearchHandler.searchAddress(searchInput, preFetchedResults, addrPrefs);
        }
        if (result != null) {
            result.setInputCountry(inAddress.getCountry());
        }
        return result;
    }

    private AddressSearchInternalResults searchFields(List<FieldSearch> searchFields, SearchAreas searchAreas, AddressSearchPreferences addrPrefs) throws SuggestFailureException {
        AddressSearchInternalResults currResults = null;
        for (FieldSearch searchField : searchFields) {
            AddressSearchPreferences fieldSearchPrefs = searchField.getSearchPrefs();
            SearchInput searchInput = searchField.getSearchInput();
            AddressSearchInternalResults results = null;
            if (currResults == null) {
                results = this.search(searchInput, null, fieldSearchPrefs);
            } else {
                for (AddressSearchInternalResult prevResult : IteratorUtils.iterable(currResults.iterator())) {
                    AddressSearchInternalResults subResults = this.search(searchInput, prevResult, fieldSearchPrefs);
                    results = this.addrSearchHandler.combineResults(results, subResults);
                }
            }
            if (!(currResults = results).isEmpty()) continue;
            break;
        }
        return currResults;
    }

    private AddressSearchInternalResults search(SearchInput searchInput, AddressSearchInternalResult prevResult, AddressSearchPreferences searchPrefs) throws SuggestFailureException {
        AddressSearchInternalResults results = this.addrSearchHandler.internalSearch1(searchInput, prevResult, searchPrefs, true);
        AddressSearchInternalResults filteredResults = new AddressSearchInternalResults();
        if (results != null) {
            for (AddressSearchInternalResult result : IteratorUtils.iterable(results.iterator())) {
                if (!result.isFullInputMatch()) {
                    if (searchPrefs.getSearchableFields().size() <= 1) continue;
                    AddressSearchInternalResults newResults = this.continueSearch(searchInput, result, searchPrefs);
                    filteredResults = this.addrSearchHandler.combineResults(filteredResults, newResults);
                    continue;
                }
                filteredResults.add(result);
            }
        }
        return filteredResults;
    }

    private AddressSearchInternalResults continueSearch(SearchInput searchInput, AddressSearchInternalResult prevResult, AddressSearchPreferences searchPrefs) throws SuggestFailureException {
        AddressSearchPreferences searchPrefsCopy = new AddressSearchPreferences(searchPrefs);
        this.removeMatchedField(prevResult, searchPrefsCopy);
        SearchInput subInput = searchInput.getSubInput(prevResult.getMatchedLen());
        return this.search(subInput, prevResult, searchPrefsCopy);
    }

    private void removeMatchedField(AddressSearchInternalResult result, AddressSearchPreferences searchPrefs) {
        ArrayList<Integer> searchableFields = new ArrayList<Integer>(searchPrefs.getSearchableFields());
        searchableFields.remove((Object)result.getMatchedFieldType());
        searchPrefs.setSearchableFields(searchableFields);
    }

    private List<FieldSearch> getSearchFields(InputAddress inAddress, SearchAreas searchAreas, AddressSearchPreferences addrPrefs) {
        ArrayList<FieldSearch> searchFields = new ArrayList<FieldSearch>(4);
        AddressMetaData addrMetaData = this.addrSearchHandler.getAddressMetaData();
        String inFieldValue = inAddress.getCategory();
        if (inFieldValue != null && this.addrSearchHandler.isPOIDataSet()) {
            int catFieldID = addrMetaData.getFieldID(AddressMetaData.CATEGORY_FIELD_NAME);
            List<Integer> fieldTypes = Arrays.asList(catFieldID, addrMetaData.getFieldID(AddressMetaData.SUB_CATEGORY_FIELD_NAME));
            this.addField(searchFields, catFieldID, fieldTypes, inFieldValue, searchAreas, addrPrefs);
        }
        if ((inFieldValue = inAddress.getCity()) != null) {
            this.addField(searchFields, 18, Collections.singletonList(18), inFieldValue, searchAreas, addrPrefs);
        }
        if ((inFieldValue = inAddress.getStateProvince()) != null) {
            this.addField(searchFields, 16, Collections.singletonList(16), inFieldValue, searchAreas, addrPrefs);
        }
        if ((inFieldValue = inAddress.getPostCode()) != null) {
            this.addField(searchFields, 15, Collections.singletonList(15), inFieldValue, searchAreas, addrPrefs);
        }
        return searchFields;
    }

    private void addField(List<FieldSearch> searchFields, int inField, List<Integer> fieldTypes, String searchStr, SearchAreas searchAreas, AddressSearchPreferences searchPrefs) {
        SearchInput searchInput = this.addrSearchHandler.makeSearchInput(searchStr, searchPrefs);
        if (searchInput != null) {
            searchInput.setSearchAreas(searchAreas);
            searchInput.setInputField(inField);
            AddressSearchPreferences searchPrefsCopy = new AddressSearchPreferences(searchPrefs);
            searchPrefsCopy.setSearchableFields(fieldTypes);
            searchFields.add(new FieldSearch(searchInput, searchPrefsCopy));
        }
    }

    private static final class FieldSearch {
        private SearchInput searchInput;
        private AddressSearchPreferences searchPrefs;

        FieldSearch(SearchInput searchInput, AddressSearchPreferences searchPrefs) {
            this.searchInput = searchInput;
            this.searchPrefs = searchPrefs;
        }

        SearchInput getSearchInput() {
            return this.searchInput;
        }

        AddressSearchPreferences getSearchPrefs() {
            return this.searchPrefs;
        }
    }
}

