/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AreaGeomItem;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeResults;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTreeUtils;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SearchAreas
implements IQuadTreeResults<AreaGeomItem> {
    private static final NumberRange FULL_RANGE = new NumberRange(0, Integer.MAX_VALUE);
    private final double[] centerPoint;
    private List<BoundedAreaGeomItems> bagItemsList;
    private BoundedAreaGeomItems farthestBAGItems;
    private BoundedAreaGeomItems closestsBAGItems;
    private HashSet<AreaGeomItem> areaSet;
    private Rectangle inputBounds;

    public SearchAreas() {
        this(null);
    }

    public SearchAreas(double[] centerPoint) {
        this.centerPoint = centerPoint;
        this.bagItemsList = new ArrayList<BoundedAreaGeomItems>();
        this.areaSet = new HashSet();
    }

    @Override
    public void add(Collection<AreaGeomItem> items, NumberRange distRange) {
        if (distRange == null) {
            distRange = FULL_RANGE;
        }
        BoundedAreaGeomItems quadWithDistRange = new BoundedAreaGeomItems(items, distRange);
        this.add(quadWithDistRange);
    }

    private void add(BoundedAreaGeomItems bagItems) {
        this.areaSet.addAll(bagItems.getAreaGeomItems());
        this.bagItemsList.add(bagItems);
        this.setFarthestAndClosest(bagItems);
    }

    private void setFarthestAndClosest(BoundedAreaGeomItems bagItems) {
        if (this.farthestBAGItems == null) {
            this.farthestBAGItems = bagItems;
            this.closestsBAGItems = bagItems;
        } else {
            NumberRange range = bagItems.getDistRange();
            if (this.farthestBAGItems.getDistRange().getEnd() < range.getEnd()) {
                this.farthestBAGItems = bagItems;
            }
            if (this.closestsBAGItems.getDistRange().getStart() > range.getStart()) {
                this.closestsBAGItems = bagItems;
            }
        }
    }

    public List<AddressPtr> retainAvailableAreas(Collection<AddressPtr> addrPtrs) {
        ArrayList<AddressPtr> retainedList = new ArrayList<AddressPtr>(addrPtrs.size());
        for (AddressPtr addrPtr : addrPtrs) {
            if (!this.containsArea(addrPtr.getAreaID())) continue;
            retainedList.add(addrPtr);
        }
        return retainedList;
    }

    public boolean containsArea(int areaID) {
        AreaGeomItem searchItem = new AreaGeomItem(areaID, null);
        return this.areaSet.contains(searchItem);
    }

    @Override
    public Iterator<AreaGeomItem> iterator() {
        return this.areaSet.iterator();
    }

    public int size() {
        return this.areaSet.size();
    }

    public int minimumDistance() {
        return this.closestsBAGItems == null ? 0 : this.closestsBAGItems.getDistRange().getStart();
    }

    public int maximumDistance() {
        return this.farthestBAGItems == null ? 0 : this.farthestBAGItems.getDistRange().getEnd();
    }

    public SearchAreas subSet(int fromDistance, int toDistance) {
        double[] centerPoint = this.getCenterPoint();
        SearchAreas subAreas = new SearchAreas(centerPoint);
        for (BoundedAreaGeomItems bagItems : this.bagItemsList) {
            NumberRange distRange;
            if (!bagItems.intersects(fromDistance, toDistance)) continue;
            if (centerPoint != null && !(distRange = bagItems.getDistRange()).isWithinRangeOf(fromDistance, toDistance)) {
                BoundedAreaGeomItems subBAGItem = bagItems.subSet(fromDistance, toDistance, centerPoint);
                if (subBAGItem == null) continue;
                subAreas.add(subBAGItem);
                continue;
            }
            subAreas.add(bagItems);
        }
        return subAreas.size() == 0 ? null : subAreas;
    }

    public double[] getCenterPoint() {
        return this.centerPoint;
    }

    public void setInputBounds(Rectangle bounds) {
        this.inputBounds = bounds;
    }

    public Rectangle getInputBounds() {
        return this.inputBounds;
    }

    private class BoundedAreaGeomItems {
        private final Collection<AreaGeomItem> areaGeomItems;
        private final NumberRange distRange;

        BoundedAreaGeomItems(Collection<AreaGeomItem> areaGeomItems, NumberRange distRange) {
            this.areaGeomItems = areaGeomItems;
            this.distRange = distRange;
        }

        Collection<AreaGeomItem> getAreaGeomItems() {
            return this.areaGeomItems;
        }

        NumberRange getDistRange() {
            return this.distRange;
        }

        boolean intersects(int start, int end) {
            return this.distRange.intersects(start, end);
        }

        BoundedAreaGeomItems subSet(int from, int to, double[] centerPoint) {
            int closest = Integer.MAX_VALUE;
            int furthest = Integer.MIN_VALUE;
            ArrayList<AreaGeomItem> retained = new ArrayList<AreaGeomItem>(this.areaGeomItems.size());
            for (AreaGeomItem item : this.areaGeomItems) {
                NumberRange range = QuadTreeUtils.calculateNumberRange(item, centerPoint);
                if (!range.isStartWithinRangeOf(from, to)) continue;
                retained.add(item);
                closest = Math.min(closest, range.getStart());
                furthest = Math.max(furthest, range.getEnd());
            }
            if (!retained.isEmpty()) {
                return new BoundedAreaGeomItems(retained, new NumberRange(closest, furthest));
            }
            return null;
        }
    }
}

