/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.IAddressPtrFilter;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.List;

public class SearchRequest {
    private String key;
    private String[] keyExtensions;
    private List<AddressPtr> allowedAddrPtrList;
    private List<Integer> allowedTypeList;
    private List<Integer> ignoreTypeList;
    private INodeKeyFilter keyFilter = null;
    private List<IAddressPtrFilter> additionalFilters;
    private SearchAreas searchAreas;
    private boolean fuzzySearch;
    private boolean filterWithinBounds;
    private boolean matchFully;

    public SearchRequest() {
    }

    public SearchRequest(String key, SearchAreas searchAreas) {
        this.key = key;
        this.searchAreas = searchAreas;
    }

    public SearchRequest(SearchRequest copy) {
        this.copyFrom(copy);
    }

    public void setSearchKey(String key) {
        this.key = key;
    }

    public void setSearchKeyExtensions(String[] keyExts) {
        this.keyExtensions = keyExts;
    }

    public double[] getSearchPoint() {
        return this.searchAreas == null ? null : this.searchAreas.getCenterPoint();
    }

    public String getSearchkey() {
        return this.key;
    }

    public String[] getSearchKeyExtensions() {
        return this.keyExtensions;
    }

    public void setAllowedAddressPtrFromResult(SearchResult sr) {
        AddressPtrMap addrPtrMap = sr.getAddressPtrMap();
        this.allowedAddrPtrList = ListUtils.addToList(this.allowedAddrPtrList, addrPtrMap.getAddressPtrIterator());
        this.ignoreTypeList = ListUtils.addToList(this.ignoreTypeList, addrPtrMap.getFields());
    }

    public void appendAllowedAddressPtrList(List<AddressPtr> allowedPtrList) {
        this.allowedAddrPtrList = ListUtils.addToList(this.allowedAddrPtrList, allowedPtrList);
    }

    protected List<AddressPtr> getAllowedAddrPtrList() {
        return this.allowedAddrPtrList;
    }

    public void setAllowedTypes(List<Integer> allowedTypes) {
        this.allowedTypeList = allowedTypes;
    }

    public List<Integer> getAllowedTypes() {
        return this.allowedTypeList;
    }

    public void setIgnoreTypes(List<Integer> ignoreTypes) {
        this.ignoreTypeList = ignoreTypes;
    }

    public List<Integer> getIgnoreTypes() {
        return this.ignoreTypeList;
    }

    public Rectangle getSearchBounds() {
        return this.searchAreas == null ? null : this.searchAreas.getInputBounds();
    }

    protected INodeKeyFilter getKeyFilter() {
        return this.keyFilter;
    }

    protected void setKeyFilter(INodeKeyFilter keyFilter) {
        this.keyFilter = keyFilter;
    }

    public void setAdditionalFilters(List<IAddressPtrFilter> additionalFilters) {
        this.additionalFilters = additionalFilters;
    }

    public List<IAddressPtrFilter> getAdditionalFilters() {
        return this.additionalFilters;
    }

    public SearchAreas getSearchAreas() {
        return this.searchAreas;
    }

    public void setSearchAreas(SearchAreas searchAreas) {
        this.searchAreas = searchAreas;
    }

    public boolean canSearchOnField(int fieldID) {
        if (this.ignoreTypeList != null && this.ignoreTypeList.contains(fieldID)) {
            return false;
        }
        if (this.allowedTypeList == null || this.allowedTypeList.isEmpty()) {
            return true;
        }
        return this.allowedTypeList.contains(fieldID);
    }

    public boolean isFuzzySearch() {
        return this.fuzzySearch;
    }

    public void setFuzzySearch(boolean fuzzy) {
        this.fuzzySearch = fuzzy;
    }

    public void setFilterWithinBounds(boolean b) {
        this.filterWithinBounds = b;
    }

    public void setMatchFully(boolean b) {
        this.matchFully = b;
    }

    public boolean isMatchFully() {
        return this.matchFully;
    }

    public boolean doFilterWithinBounds() {
        return this.getSearchBounds() != null && this.filterWithinBounds;
    }

    public void copyFrom(SearchRequest other) {
        this.key = other.getSearchkey();
        this.keyExtensions = other.keyExtensions;
        this.allowedAddrPtrList = other.allowedAddrPtrList;
        this.allowedTypeList = other.allowedTypeList;
        this.ignoreTypeList = other.ignoreTypeList;
        this.keyFilter = other.keyFilter;
        this.additionalFilters = other.additionalFilters;
        this.searchAreas = other.searchAreas;
        this.fuzzySearch = other.fuzzySearch;
        this.filterWithinBounds = other.filterWithinBounds;
        this.matchFully = other.matchFully;
    }

    public String toString() {
        return String.format("SearchRequest(key: '%s', fuzzy: %s)", this.key, this.fuzzySearch);
    }
}

