/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.IAddressFilter;
import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.IDataReader;
import com.mapinfo.mapmarker.autosuggest.exception.DataFetchException;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import com.mapinfo.mapmarker.autosuggest.utils.SubLevelIterator;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SearchResultAddressIterator
extends ReadOnlyIterator<SimpleAddress> {
    private final SearchResult m_searchResult;
    private final IDataReader m_dataSetReader;
    private final int m_max;
    private Iterator<SubLevelIterator.Pair<Integer, AddressPtr>> m_addrPtrEnIt = null;
    private Iterator<SubLevelIterator.Pair<Integer, Integer>> m_addrIt;
    private SimpleAddress m_nextAddress = null;
    private int m_fetched = 0;
    private IAddressFilter m_addrFilter;

    public SearchResultAddressIterator(SearchResult sr, IAddressFilter filter, IDataReader dataSetReader, int max) {
        this.m_searchResult = sr;
        this.m_addrFilter = filter;
        this.m_dataSetReader = dataSetReader;
        this.m_max = max;
        this.init();
    }

    void init() {
        this.setAddressPtrMapIt();
        this.setNextAddressPtrIt();
        try {
            this.setNextAddress();
        }
        catch (IOException ioe) {
            throw new DataFetchException(ioe);
        }
    }

    private boolean setAddressPtrMapIt() {
        AddressPtrMap item = this.getSearchResult().getAddressPtrMap();
        if (item != null) {
            int fetchFieldID = this.getAddressFilter().getMatchedFieldID();
            if (fetchFieldID > -1) {
                List<AddressPtr> addrPtrList = item.find(fetchFieldID);
                if (addrPtrList != null) {
                    HashMap<Integer, List<AddressPtr>> map = new HashMap<Integer, List<AddressPtr>>(1);
                    map.put(fetchFieldID, addrPtrList);
                    this.m_addrPtrEnIt = SubLevelIterator.getMapIterator(map);
                    return true;
                }
            } else {
                this.m_addrPtrEnIt = SubLevelIterator.getMapIterator(item.getMap());
                return true;
            }
        }
        return false;
    }

    private void setNextAddressPtrIt() {
        this.m_addrIt = null;
        if (this.m_addrPtrEnIt != null && this.canFetchMore() && this.m_addrPtrEnIt.hasNext()) {
            SubLevelIterator.Pair<Integer, AddressPtr> addrPtrPair = this.m_addrPtrEnIt.next();
            this.m_addrIt = addrPtrPair.getValue().iterator();
        }
    }

    private boolean canFetchMore() {
        return this.m_max <= 0 || this.m_fetched < this.m_max;
    }

    private boolean setNextAddress() throws IOException {
        this.m_nextAddress = null;
        IAddressFilter addrFilter = this.getAddressFilter();
        IDataReader dataReader = this.getDataReader();
        while (this.m_addrIt != null) {
            while (this.m_addrIt.hasNext() && this.canFetchMore()) {
                SubLevelIterator.Pair<Integer, Integer> areaAddressPair = this.m_addrIt.next();
                SimpleAddress addr = dataReader.getAddress(areaAddressPair.getKey(), areaAddressPair.getValue(), addrFilter.getRangeFilter());
                if (addr == null || !addrFilter.acceptAddress(addr)) continue;
                this.calculateDistance(addr);
                this.m_nextAddress = addr;
                ++this.m_fetched;
                return true;
            }
            this.setNextAddressPtrIt();
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.m_nextAddress != null;
    }

    @Override
    public SimpleAddress next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SimpleAddress addr = this.m_nextAddress;
        try {
            this.setNextAddress();
        }
        catch (Exception e) {
            throw new DataFetchException(e);
        }
        return addr;
    }

    void calculateDistance(SimpleAddress addr) {
        double[] searchPoint = this.getSearchPoint();
        double distance = -0.0;
        if (searchPoint != null) {
            double[] geom = addr.getGeomtry();
            if (geom != null) {
                distance = GeomUtil.getDistance(searchPoint, geom);
            } else {
                Rectangle bounds = addr.getBounds();
                if (bounds != null) {
                    distance = GeomUtil.getDistance(searchPoint, bounds);
                }
            }
        }
        addr.setDistance(distance);
    }

    public double[] getSearchPoint() {
        SearchRequest req = this.getSearchRequest();
        return req.getSearchPoint();
    }

    private SearchRequest getSearchRequest() {
        return this.getSearchResult().getSearchRequest();
    }

    SearchResult getSearchResult() {
        return this.m_searchResult;
    }

    IAddressFilter getAddressFilter() {
        return this.m_addrFilter;
    }

    IDataReader getDataReader() {
        return this.m_dataSetReader;
    }
}

