/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressPtrFilter;
import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.IAreaIDReadingFilter;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeMatchResult;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SearchResults
implements Iterable<SearchResult> {
    private final RadixTreeMatchResult<AddressPtrMap> m_radixTreeResult;
    private final SearchRequest m_searchRequest;

    SearchResults(SearchResults copyFrom) {
        this(copyFrom.m_radixTreeResult, copyFrom.m_searchRequest);
    }

    SearchResults(RadixTreeMatchResult<AddressPtrMap> radixTreeResult, SearchRequest searchRequest) {
        this.m_radixTreeResult = radixTreeResult;
        this.m_searchRequest = searchRequest;
    }

    SearchResults copyWithNewRequestAndFilter(SearchRequest req, INodeValueFilter<AddressPtrMap> nodeValueFilter) {
        NodeFilter<AddressPtrMap> currFilter = this.m_radixTreeResult.getNodeFilter();
        INodeKeyFilter currKeyFilter = currFilter == null ? null : currFilter.getKeyFilter();
        NodeFilter<AddressPtrMap> newFilter = new NodeFilter<AddressPtrMap>(currKeyFilter, nodeValueFilter);
        RadixTreeMatchResult<AddressPtrMap> newRadixTreeResult = this.m_radixTreeResult.copyOf(newFilter);
        return new SearchResults(newRadixTreeResult, req);
    }

    @Override
    public Iterator<SearchResult> iterator() {
        final Iterator<IMatchResult<AddressPtrMap>> it = this.m_radixTreeResult.iterator();
        if (it != null && it.hasNext()) {
            return new ReadOnlyIterator<SearchResult>(){
                final Iterator<IMatchResult<AddressPtrMap>> m_it;
                {
                    this.m_it = it;
                }

                @Override
                public boolean hasNext() {
                    return this.m_it.hasNext();
                }

                @Override
                public SearchResult next() {
                    IMatchResult<AddressPtrMap> matchResult = this.m_it.next();
                    SearchResult sr = SearchResult.getInstance(matchResult, SearchResults.this.m_searchRequest);
                    return sr;
                }
            };
        }
        List r = Collections.emptyList();
        return r.iterator();
    }

    RadixTreeMatchResult<AddressPtrMap> getRadixTreeResult() {
        return this.m_radixTreeResult;
    }

    SearchRequest getSearchRequest() {
        return this.m_searchRequest;
    }

    public void setAdditionalAreaFilters(List<IAreaIDReadingFilter> areaFilters) {
        AddressPtrFilter filter = (AddressPtrFilter)this.getRadixTreeResult().getNodeFilter().getValueFilter();
        filter.setAdditionalAreaFilters(areaFilters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SearchResults(");
        for (SearchResult searchResult : this) {
            sb.append(" ");
            sb.append(searchResult);
        }
        sb.append(" )");
        return sb.toString();
    }
}

