/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressStringFormatter;
import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.FormattedString;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleUnit;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class SimpleAddress
extends SimpleStreetAddress {
    private static int HNR_FIELDTYPE = FieldType.ADDRESS_NUMBER_FIELD_TYPE.getKey();
    private double[] geometry;
    private double[] centroid;
    private double distance;
    private String hnr;
    private Map<Integer, FieldMatchInfo> fieldMatchInfos = new HashMap<Integer, FieldMatchInfo>(5);
    private int[] streetFormatFields;
    private int[] lastlineFormatFields;
    private boolean hnrMatched = false;
    private int matchScore;
    private SimpleRange matchedRanged;
    private boolean areaAddressGroup;
    private FieldType.FieldLevel lowestMatchedFieldInAddrHierarchy;
    private String streetFormatPattern;
    private String lastLisntFormatPattern;

    @Override
    public String getFieldValue(int fieldID) {
        if (fieldID == HNR_FIELDTYPE) {
            return this.getHNR();
        }
        return super.getFieldValue(fieldID);
    }

    @Override
    public String getFieldValue(int fieldID, int i) {
        if (fieldID == HNR_FIELDTYPE) {
            return this.getHNR();
        }
        return super.getFieldValue(fieldID, i);
    }

    public void setGeometry(double[] geom) {
        this.geometry = geom;
    }

    public double[] getGeomtry() {
        return this.geometry;
    }

    public FieldMatchInfo getFieldMatchInfo(int fieldID) {
        return this.fieldMatchInfos.get(fieldID);
    }

    public Map<Integer, FieldMatchInfo> getFieldMatchInfos() {
        return this.fieldMatchInfos;
    }

    public int getNumFieldsMatched() {
        return this.fieldMatchInfos.size();
    }

    public void setHNR(String hnr) {
        this.hnr = hnr;
    }

    public String getHNR() {
        return this.hnr;
    }

    public FormattedString getFormattedAddressString(boolean usePrefferedName, int ... fields) {
        AddressStringFormatter formatter = new AddressStringFormatter(this.fieldMatchInfos, this);
        return formatter.getFormattedAddressString(usePrefferedName, fields);
    }

    public FormattedString getFormattedAddressString(boolean usePrefferedName, String ... fields) {
        AddressStringFormatter formatter = new AddressStringFormatter(this.fieldMatchInfos, this);
        return formatter.getFormattedAddressString(usePrefferedName, fields);
    }

    public FormattedString getFormattedAddressString(int ... fields) {
        AddressStringFormatter formatter = new AddressStringFormatter(this.fieldMatchInfos, this);
        return formatter.getFormattedAddressString(true, fields);
    }

    @Override
    public String toString() {
        String out = "";
        Map<Integer, List<String>> fields = this.getFields();
        if (fields != null) {
            TreeMap<Integer, List<String>> sortedFields = new TreeMap<Integer, List<String>>(fields);
            StringBuilder sb = new StringBuilder(100);
            if (this.hnr != null) {
                sb.append(this.hnr);
                sb.append(" ");
            }
            for (List<String> fvs : sortedFields.values()) {
                String f;
                if (fvs == null || fvs.size() <= 0 || MMUtils.isEmpty((String)(f = fvs.get(0)))) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(f.charAt(0));
                if (f.length() <= 0) continue;
                sb.append(f.substring(1).toLowerCase());
            }
            out = sb.toString();
        }
        return out;
    }

    public void setCentroid(double[] centroid) {
        this.centroid = centroid;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public double[] getCentroid() {
        return this.centroid;
    }

    public boolean hasGeometry() {
        return this.geometry != null && this.geometry.length > 0;
    }

    public void addFieldMatchInfos(List<FieldMatchInfo> fieldMatchInfos) {
        int n = fieldMatchInfos.size();
        for (int i = 0; i < n; ++i) {
            this.addFieldMatchInfo(fieldMatchInfos.get(i));
        }
    }

    public void addFieldMatchInfo(FieldMatchInfo fieldMatchInfo) {
        this.fieldMatchInfos.put(fieldMatchInfo.getFieldID(), fieldMatchInfo);
    }

    public void setStreetFormatFields(int[] streetFormatFields) {
        this.streetFormatFields = streetFormatFields;
    }

    public int[] getStreetFormatFields() {
        if (this.streetFormatFields == null) {
            this.streetFormatFields = new int[]{FieldType.ADDRESS_NUMBER_FIELD_TYPE.getKey(), FieldType.STREET_NAME_FIELD_TYPE.getKey()};
        }
        return this.streetFormatFields;
    }

    public void setLastlineFormatFields(int[] lastlineFormatFields) {
        this.lastlineFormatFields = lastlineFormatFields;
    }

    public int[] getLastlineFormatFields() {
        return this.lastlineFormatFields;
    }

    public int getNumCharsMatched() {
        int len = 0;
        for (FieldMatchInfo fieldMatchInfo : this.fieldMatchInfos.values()) {
            len += fieldMatchInfo.getMatchedLength();
        }
        return len;
    }

    public int getNumCharsMatched(int field) {
        FieldMatchInfo fieldMatchInfo = this.fieldMatchInfos.get(field);
        if (fieldMatchInfo != null) {
            return fieldMatchInfo.getMatchedLength();
        }
        return 0;
    }

    public boolean matchedOnField(int field) {
        FieldMatchInfo fieldMatchInfo = this.fieldMatchInfos.get(field);
        return fieldMatchInfo != null && fieldMatchInfo.getMatchedLength() > 0;
    }

    public boolean hnrMatched() {
        return this.hnrMatched;
    }

    public void setHnrMatched(boolean b) {
        this.hnrMatched = b;
    }

    public void setMatchedRange(SimpleRange range) {
        this.matchedRanged = range;
    }

    public boolean hasMatchedRange() {
        return this.matchedRanged != null;
    }

    public void setMatchScore(int score) {
        this.matchScore = score;
    }

    public int getMatchScore() {
        return this.matchScore;
    }

    public int getMatchedIndex(int fieldTypeKey) {
        FieldMatchInfo fieldMatchInfo = this.fieldMatchInfos.get(fieldTypeKey);
        if (fieldMatchInfo != null) {
            return fieldMatchInfo.getMatchedValueNdx();
        }
        return 0;
    }

    public int getUnitCount(int rangeNdx) {
        SimpleRange range = this.getRangeAt(rangeNdx);
        return range == null ? 0 : range.getUnitCount();
    }

    public void setIsAreaAddressGroup(boolean b) {
        this.areaAddressGroup = b;
    }

    public boolean isAreaAddressGroup() {
        return this.areaAddressGroup;
    }

    public FieldType.FieldLevel getLowestMatchedFieldInAddrHierarchy() {
        return this.lowestMatchedFieldInAddrHierarchy;
    }

    public void setLowestMatchedFieldInAddrHierarchy(int matchedFieldId) {
        FieldType type = FieldType.getPredefinedField((int)matchedFieldId);
        if (type != null && (type.getLevel() == FieldType.FieldLevel.LEVEL_RANGE || type.getLevel() == FieldType.FieldLevel.LEVEL_UNIT)) {
            this.lowestMatchedFieldInAddrHierarchy = type.getLevel();
        } else {
            List<SimpleRange> ranges = this.getRanges();
            if (null != ranges) {
                block0: for (SimpleRange range : ranges) {
                    if (range.getFields().containsKey(matchedFieldId)) {
                        this.lowestMatchedFieldInAddrHierarchy = FieldType.FieldLevel.LEVEL_RANGE;
                        break;
                    }
                    List<SimpleUnit> units = range.getUnits();
                    if (null == units) continue;
                    for (SimpleUnit unit : units) {
                        if (!unit.getFields().containsKey(matchedFieldId)) continue;
                        this.lowestMatchedFieldInAddrHierarchy = FieldType.FieldLevel.LEVEL_UNIT;
                        continue block0;
                    }
                }
            }
        }
    }

    public void setStreetFormatFieldsPattern(String streetFormatFieldsPattern) {
        this.streetFormatPattern = streetFormatFieldsPattern;
    }

    public void setLastlineFormatFieldsPattern(String lastlineFormatFieldsPattern) {
        this.lastLisntFormatPattern = lastlineFormatFieldsPattern;
    }

    public String[] getStreetFormatFieldsPattern() {
        String[] parsed = this.parseFormatString(this.streetFormatPattern);
        if ((parsed == null || parsed.length == 0) && this.getStreetFormatFields() != null) {
            parsed = this.generateDefaultPattern(this.getStreetFormatFields());
        }
        if (parsed == null || parsed.length == 0) {
            parsed = this.parseFormatString("[" + 4 + "]{ }[" + 8 + "]");
        }
        return parsed;
    }

    private String[] generateDefaultPattern(int[] formatFields) {
        ArrayList<String> defaultFormatPattern = new ArrayList<String>();
        for (int i = 0; i < formatFields.length; ++i) {
            defaultFormatPattern.add(String.valueOf(formatFields[i]));
            if (8 == formatFields[i]) {
                if (i + 1 < formatFields.length && 4 == formatFields[i + 1]) {
                    defaultFormatPattern.add("{ }");
                    continue;
                }
                defaultFormatPattern.add("{, }");
                continue;
            }
            if (4 == formatFields[i] || 15 == formatFields[i] || 201 == formatFields[i]) {
                defaultFormatPattern.add("{ }");
                continue;
            }
            defaultFormatPattern.add("{, }");
        }
        if (defaultFormatPattern.size() > 1) {
            defaultFormatPattern.remove(defaultFormatPattern.size() - 1);
        }
        String[] parsed = defaultFormatPattern.toArray(new String[0]);
        return parsed;
    }

    public String[] getLastlineFormatFieldsPattern() {
        String[] parsed = this.parseFormatString(this.lastLisntFormatPattern);
        if ((parsed == null || parsed.length == 0) && this.getLastlineFormatFields() != null) {
            parsed = this.generateDefaultPattern(this.getLastlineFormatFields());
        }
        if (parsed == null || parsed.length == 0) {
            parsed = this.parseFormatString("[" + 19 + "]{, }[" + 18 + "]{, }[" + 17 + "]{, }[" + 16 + "]{ }[" + 15 + "]");
        }
        return parsed;
    }

    private String[] parseFormatString(String format) {
        String[] parsed = null;
        if (!StringUtilities.isEmpty((String)format)) {
            StringTokenizer tokenizer = new StringTokenizer(format, "[]");
            int tokenCount = tokenizer.countTokens();
            parsed = new String[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                parsed[i] = tokenizer.nextToken();
                ++i;
            }
        }
        return parsed;
    }
}

