/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressSearchHandler;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResults;
import com.mapinfo.mapmarker.autosuggest.AddressSearchPreferences;
import com.mapinfo.mapmarker.autosuggest.SearchInput;
import com.mapinfo.mapmarker.autosuggest.dp.IAreaIDReadingFilter;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.autosuggest.utils.AutoSuggestLog;
import com.mapinfo.mapmarker.autosuggest.utils.IPeekableIterator;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class WeightedInternalResultFetcher
implements Iterable<AddressSearchInternalResult> {
    private final AddressSearchPreferences searchPrefs;
    private final SearchInput mainSearchInput;
    private final AddressSearchHandler handler;
    private final AddressSearchInternalResults initialResults;

    WeightedInternalResultFetcher(AddressSearchHandler handler, SearchInput searchInput, AddressSearchPreferences searchPrefs) throws SuggestFailureException {
        this(handler, searchInput, searchPrefs, null);
    }

    WeightedInternalResultFetcher(AddressSearchHandler handler, SearchInput searchInput, AddressSearchPreferences searchPrefs, AddressSearchInternalResults preFetchedResults) throws SuggestFailureException {
        this.searchPrefs = searchPrefs;
        this.mainSearchInput = searchInput;
        this.handler = handler;
        this.initialResults = preFetchedResults == null ? this.getInitialResults() : preFetchedResults;
    }

    private AddressSearchInternalResults getInitialResults() throws SuggestFailureException {
        return this.handler.internalSearchNext(this.mainSearchInput, null, this.searchPrefs);
    }

    private AddressSearchInternalResults matchRestOfTheInput(AddressSearchInternalResult from) throws SuggestFailureException {
        return this.handler.internalSearchNext(from.getSearchInput(), from, this.searchPrefs);
    }

    @Override
    public Iterator<AddressSearchInternalResult> iterator() {
        if (this.initialResults != null) {
            final TreeSet<IPeekableIterator<AddressSearchInternalResult>> resultsList = new TreeSet<IPeekableIterator<AddressSearchInternalResult>>(new AddressSearchInternalResultsComparator());
            resultsList.add((IPeekableIterator<AddressSearchInternalResult>)this.initialResults.iterator());
            return new ReadOnlyIterator<AddressSearchInternalResult>(){
                private AddressSearchInternalResult m_next;
                {
                    this.m_next = WeightedInternalResultFetcher.this.getNextResult(resultsList);
                }

                @Override
                public boolean hasNext() {
                    return this.m_next != null;
                }

                @Override
                public AddressSearchInternalResult next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    AddressSearchInternalResult next = this.m_next;
                    this.m_next = WeightedInternalResultFetcher.this.getNextResult(resultsList);
                    return next;
                }
            };
        }
        List list = Collections.emptyList();
        return list.iterator();
    }

    private AddressSearchInternalResult getNextResult(TreeSet<IPeekableIterator<AddressSearchInternalResult>> resultSet) {
        AddressSearchInternalResult currBestResult = null;
        do {
            AddressSearchInternalResults newResults;
            block6: {
                if ((currBestResult = this.getBestNextResultFromInternalList(resultSet)) == null) continue;
                newResults = null;
                SearchInput searchInput = currBestResult.getSearchInput();
                try {
                    if (!searchInput.isMainFieldInput()) {
                        newResults = this.handler.internalSearchNext(this.mainSearchInput, currBestResult, this.searchPrefs);
                        break block6;
                    }
                    if (this.handler.moreCharactersLeftToMatch(searchInput, currBestResult)) {
                        if (!searchInput.isOnLastWord()) {
                            newResults = this.matchRestOfTheInput(currBestResult);
                        }
                        break block6;
                    }
                    return currBestResult;
                }
                catch (SuggestFailureException e) {
                    AutoSuggestLog.getLog().error((Object)("Search failure while looking for more results: " + searchInput), (Throwable)e);
                }
            }
            if (newResults == null) continue;
            resultSet.add((IPeekableIterator<AddressSearchInternalResult>)newResults.iterator());
        } while (currBestResult != null);
        return null;
    }

    private AddressSearchInternalResult getBestNextResultFromInternalList(TreeSet<IPeekableIterator<AddressSearchInternalResult>> resultsList) {
        while (!resultsList.isEmpty()) {
            IPeekableIterator<AddressSearchInternalResult> it = resultsList.pollLast();
            if (!it.hasNext()) continue;
            AddressSearchInternalResult result = (AddressSearchInternalResult)it.next();
            if (it.hasNext()) {
                resultsList.add(it);
            }
            return result;
        }
        return null;
    }

    void setAreaFilters(List<IAreaIDReadingFilter> areaFilters) {
        if (this.initialResults != null) {
            this.initialResults.setAreaFilters(areaFilters);
        }
    }

    boolean isEmpty() {
        return this.initialResults == null || this.initialResults.isEmpty();
    }

    private static class AddressSearchInternalResultsComparator
    implements Comparator<IPeekableIterator<AddressSearchInternalResult>> {
        private AddressSearchInternalResultsComparator() {
        }

        @Override
        public int compare(IPeekableIterator<AddressSearchInternalResult> o1, IPeekableIterator<AddressSearchInternalResult> o2) {
            AddressSearchInternalResult a1 = o1.hasNext() ? o1.peekNext() : null;
            AddressSearchInternalResult a2 = o2.hasNext() ? o2.peekNext() : null;
            int c = 0;
            if (a1 != null && a2 != null) {
                return a1.compareTo(a2);
            }
            c = a1 != null ? 1 : -1;
            return c;
        }
    }
}

