/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.api;

import com.mapinfo.mapmarker.autosuggest.AutoSuggestHandler;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AutoSuggestDictionaryMetaData {
    private final boolean isUserDictionary;
    private final List<String> supportedCountries;
    private final int dictionaryType;
    private final String dictionaryTypeString;
    private final String dataVintage;
    private final String dataProductCode;
    private final File dictionaryFile;

    AutoSuggestDictionaryMetaData(AutoSuggestHandler handler, File dictionaryFile) {
        this.dictionaryFile = dictionaryFile;
        this.supportedCountries = new ArrayList<String>();
        AddressMetaData metaData = handler.getAddressMetaData();
        if (metaData != null) {
            this.isUserDictionary = metaData.isCustomData();
            this.dictionaryType = metaData.getDataSetType();
            this.dataVintage = metaData.getDataVintage();
            this.dataProductCode = metaData.getDataProductCode();
            this.dictionaryTypeString = this.dictionaryType == 1 ? "POI" : "Street";
            String sc = metaData.getSupportedCountries();
            if (sc != null && sc.length() > 0) {
                this.supportedCountries.addAll(Arrays.asList(sc.split("\\W+")));
            }
        } else {
            this.dataVintage = "";
            this.dataProductCode = "";
            this.dictionaryTypeString = "";
            this.dictionaryType = -1;
            this.isUserDictionary = false;
        }
    }

    public boolean isUserDictionary() {
        return this.isUserDictionary;
    }

    public List<String> getSupportedCountriesFromDictionary() {
        return this.supportedCountries;
    }

    public int getDictionaryType() {
        return this.dictionaryType;
    }

    public String getDictionaryDataVintage() {
        return this.dataVintage;
    }

    public String getDictionaryDataProductCode() {
        return this.dataProductCode;
    }

    public File getDictionaryFile() {
        return this.dictionaryFile;
    }

    public String getDataTypeString() {
        return this.dictionaryTypeString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        sb.append("AutoSuggestDictionaryMetaData ----------- \n");
        sb.append("\tdicitonaryFileName: ").append(this.dictionaryFile.getName()).append("\n");
        sb.append("\tisUserDictionary: ").append(this.isUserDictionary).append("\n");
        sb.append("\tdictionaryType: ").append("" + this.dictionaryType).append("\n");
        sb.append("\tdictionaryTypeString: ").append(this.dictionaryTypeString).append("\n");
        sb.append("\tdataVintage: ").append(this.dataVintage).append("\n");
        sb.append("\tdataProductCode: ").append(this.dataProductCode).append("\n");
        sb.append("\tsupportedCountries: ");
        for (String supportedCountry : this.supportedCountries) {
            sb.append(supportedCountry).append(", ");
        }
        String outputString = sb.toString();
        return outputString.endsWith(", ") ? outputString.substring(0, outputString.length() - 2) : outputString;
    }
}

