/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.api;

import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestAPI;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidates;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.autosuggest.wrapper.AutoSuggestFactory;
import com.mapinfo.mapmarker.autosuggest.wrapper.CandidateCompare;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidates;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSuggestEngine
implements AutoSuggestAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AutoSuggestEngine.class);
    private boolean bAdjustInputOnNullResult;

    @Override
    public ISuggestedCandidates suggest(String str, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        return this.suggest(str, null, constraints);
    }

    @Override
    public ISuggestedCandidates suggest(String str, String country, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        AddressImpl address = new AddressImpl();
        address.setMainAddress(str);
        address.setCountry(country);
        return this.suggest((Address)address, constraints);
    }

    @Override
    public ISuggestedCandidates suggest(Address address, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("suggest('" + address + "')");
        }
        if (address == null) {
            return new SuggestedCandidates(null);
        }
        if (constraints == null) {
            constraints = new AutoSuggestConstraints();
        }
        if (address.getCountry() != null) {
            address.setCountry(address.getCountry().toUpperCase());
        }
        AutoSuggestConstraints constraintsCopy = new AutoSuggestConstraints(constraints);
        List<AutoSuggestAPI> instanceList = AutoSuggestFactory.getInstanceList(address.getCountry(), constraintsCopy);
        if (instanceList == null) {
            return new SuggestedCandidates(null);
        }
        ArrayList<ISuggestedCandidate> candidateList = new ArrayList<ISuggestedCandidate>();
        for (AutoSuggestAPI instance : instanceList) {
            ISuggestedCandidates candidates = instance.suggest(address, (IAutoSuggestConstraints)constraintsCopy);
            if (instanceList.size() == 1) {
                return candidates;
            }
            if (candidates.getCount() <= 0) continue;
            for (int i = 0; i < candidates.getCount(); ++i) {
                candidateList.add(candidates.getCandidateAt(i));
            }
        }
        if (instanceList.size() > 1) {
            int max;
            Collections.sort(candidateList, new CandidateCompare());
            if (constraintsCopy != null && (max = constraintsCopy.getMaxCandidates()) > 0) {
                while (candidateList.size() > max) {
                    candidateList.remove(max);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("suggest('" + address + "'): found " + Arrays.toString(candidateList.toArray()));
        }
        return new SuggestedCandidates(candidateList);
    }

    public void setAdjustInputOnNullResult(boolean value) {
        this.bAdjustInputOnNullResult = value;
    }

    @Override
    public ISuggestedCandidates findNearestPOIs(IAutoSuggestConstraints constraints) throws SuggestFailureException {
        return this.findNearestPOIs(null, constraints);
    }

    @Override
    public ISuggestedCandidates findNearestPOIs(String country, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        ArrayList<ISuggestedCandidate> candidateList = new ArrayList<ISuggestedCandidate>();
        SuggestedCandidates results = new SuggestedCandidates(candidateList);
        if (constraints.getOrigin() != null) {
            constraints.setSearchType(3);
            List<AutoSuggestAPI> instanceList = AutoSuggestFactory.getInstanceList(country, constraints);
            for (AutoSuggestAPI instance : instanceList) {
                ISuggestedCandidates candidates = instance.findNearestPOIs(country, constraints);
                if (candidates.getCount() <= 0) continue;
                for (int i = 0; i < candidates.getCount(); ++i) {
                    candidateList.add(candidates.getCandidateAt(i));
                }
            }
            Collections.sort(candidateList, new CandidateCompare());
            int maximum = constraints.getMaxCandidates();
            if (maximum > 0) {
                while (candidateList.size() > maximum) {
                    candidateList.remove(maximum);
                }
            }
        }
        return results;
    }
}

